/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.xml.sax.SAXException;

public class ImageryLayerInfo {
    public static final ImageryLayerInfo instance = new ImageryLayerInfo();
    private final List<ImageryInfo> layers = new ArrayList<ImageryInfo>();
    private final Map<String, ImageryInfo> layerIds = new HashMap<String, ImageryInfo>();
    private static final List<ImageryInfo> defaultLayers = new ArrayList<ImageryInfo>();
    private static final Map<String, ImageryInfo> defaultLayerIds = new HashMap<String, ImageryInfo>();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{Main.getJOSMWebsite() + "/maps"};

    public static Collection<String> getImageryLayersSites() {
        return Main.pref.getCollection("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES));
    }

    private ImageryLayerInfo() {
    }

    public ImageryLayerInfo(ImageryLayerInfo info) {
        this.layers.addAll(info.layers);
    }

    public void clear() {
        this.layers.clear();
        this.layerIds.clear();
    }

    public void load() {
        this.clear();
        List<ImageryInfo.ImageryPreferenceEntry> entries = Main.pref.getListOfStructs("imagery.entries", null, ImageryInfo.ImageryPreferenceEntry.class);
        if (entries != null) {
            for (ImageryInfo.ImageryPreferenceEntry prefEntry : entries) {
                try {
                    ImageryInfo i = new ImageryInfo(prefEntry);
                    this.add(i);
                }
                catch (IllegalArgumentException e) {
                    Main.warn("Unable to load imagery preference entry:" + e);
                }
            }
            Collections.sort(this.layers);
        }
        this.loadDefaults(false);
    }

    public void loadDefaults(boolean clearCache) {
        defaultLayers.clear();
        defaultLayerIds.clear();
        for (String source : ImageryLayerInfo.getImageryLayersSites()) {
            boolean online = true;
            try {
                OnlineResource.JOSM_WEBSITE.checkOfflineAccess(source, Main.getJOSMWebsite());
            }
            catch (OfflineAccessException e) {
                Main.warn(e.getMessage());
                online = false;
            }
            if (clearCache && online) {
                CachedFile.cleanup(source);
            }
            try {
                ImageryReader reader = new ImageryReader(source);
                List<ImageryInfo> result = reader.parse();
                defaultLayers.addAll(result);
            }
            catch (IOException ex) {
                Main.error(ex, false);
            }
            catch (SAXException ex) {
                Main.error(ex);
            }
        }
        while (defaultLayers.remove(null)) {
        }
        Collections.sort(defaultLayers);
        ImageryLayerInfo.buildIdMap(defaultLayers, defaultLayerIds);
        this.updateEntriesFromDefaults();
        ImageryLayerInfo.buildIdMap(this.layers, this.layerIds);
    }

    private static void buildIdMap(List<ImageryInfo> lst, Map<String, ImageryInfo> idMap) {
        idMap.clear();
        HashSet<String> notUnique = new HashSet<String>();
        for (ImageryInfo imageryInfo : lst) {
            if (imageryInfo.getId() == null) continue;
            if (idMap.containsKey(imageryInfo.getId())) {
                notUnique.add(imageryInfo.getId());
                Main.error("Id ''{0}'' is not unique - used by ''{1}'' and ''{2}''!", imageryInfo.getId(), imageryInfo.getName(), idMap.get(imageryInfo.getId()).getName());
                continue;
            }
            idMap.put(imageryInfo.getId(), imageryInfo);
        }
        for (String string : notUnique) {
            idMap.remove(string);
        }
    }

    public void updateEntriesFromDefaults() {
        boolean changed = false;
        Collection<String> knownDefaults = Main.pref.getCollection("imagery.layers.default");
        TreeSet<String> newKnownDefaults = new TreeSet<String>(knownDefaults);
        for (ImageryInfo def : defaultLayers) {
            if (!def.isDefaultEntry()) continue;
            boolean isKnownDefault = false;
            for (String url : knownDefaults) {
                if (!this.isSimilar(url, def.getUrl())) continue;
                isKnownDefault = true;
                break;
            }
            boolean isInUserList = false;
            if (!isKnownDefault) {
                newKnownDefaults.add(def.getUrl());
                for (ImageryInfo i : this.layers) {
                    if (!this.isSimilar(def, i)) continue;
                    isInUserList = true;
                    break;
                }
            }
            if (isKnownDefault || isInUserList) continue;
            this.add(new ImageryInfo(def));
            changed = true;
        }
        Main.pref.putCollection("imagery.layers.default", newKnownDefaults);
        Collection<String> addedIds = Main.pref.getCollection("imagery.layers.addedIds");
        TreeSet<String> newAddedIds = new TreeSet<String>(addedIds);
        for (ImageryInfo info : this.layers) {
            for (ImageryInfo def : defaultLayers) {
                if (!this.isSimilar(def, info) || def.getId() == null || addedIds.contains(def.getId()) || !defaultLayerIds.containsKey(def.getId())) continue;
                newAddedIds.add(def.getId());
                if (info.getId() != null) continue;
                info.setId(def.getId());
                changed = true;
            }
        }
        Main.pref.putCollection("imagery.layers.addedIds", newAddedIds);
        for (int i = 0; i < this.layers.size(); ++i) {
            ImageryInfo matchingDefault;
            ImageryInfo info = this.layers.get(i);
            if (info.getId() == null || (matchingDefault = defaultLayerIds.get(info.getId())) == null || matchingDefault.equalsPref(info)) continue;
            this.layers.set(i, matchingDefault);
            changed = true;
        }
        if (changed) {
            this.save();
        }
    }

    private boolean isSimilar(ImageryInfo iiA, ImageryInfo iiB) {
        if (iiA.getId() != null && iiB.getId() != null) {
            return iiA.getId().equals(iiB.getId());
        }
        return this.isSimilar(iiA.getUrl(), iiB.getUrl());
    }

    private boolean isSimilar(String a, String b) {
        return Objects.equals(a, b) || a != null && b != null && !a.isEmpty() && !b.isEmpty() && (a.contains(b) || b.contains(a));
    }

    public void add(ImageryInfo info) {
        this.layers.add(info);
    }

    public void remove(ImageryInfo info) {
        this.layers.remove(info);
    }

    public void save() {
        ArrayList<ImageryInfo.ImageryPreferenceEntry> entries = new ArrayList<ImageryInfo.ImageryPreferenceEntry>();
        for (ImageryInfo info : this.layers) {
            entries.add(new ImageryInfo.ImageryPreferenceEntry(info));
        }
        Main.pref.putListOfStructs("imagery.entries", entries, ImageryInfo.ImageryPreferenceEntry.class);
    }

    public List<ImageryInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<ImageryInfo> getDefaultLayers() {
        return Collections.unmodifiableList(defaultLayers);
    }

    public static void addLayer(ImageryInfo info) {
        instance.add(info);
        instance.save();
    }

    public static void addLayers(Collection<ImageryInfo> infos) {
        for (ImageryInfo i : infos) {
            instance.add(i);
        }
        instance.save();
        Collections.sort(ImageryLayerInfo.instance.layers);
    }

    public String getUniqueId(ImageryInfo info) {
        if (info.getId() != null && this.layerIds.get(info.getId()) == info) {
            return info.getId();
        }
        return null;
    }
}

