/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;

public class ImageryInfo
implements Comparable<ImageryInfo>,
Attributed {
    private String name;
    private String origName;
    private String langName;
    private String id;
    private String url = null;
    private boolean defaultEntry = false;
    private String cookies = null;
    private String eulaAcceptanceRequired = null;
    private ImageryType imageryType = ImageryType.WMS;
    private double pixelPerDegree = 0.0;
    private int defaultMaxZoom = 0;
    private int defaultMinZoom = 0;
    private ImageryBounds bounds = null;
    private List<String> serverProjections;
    private String description;
    private String langDescription;
    private String attributionText;
    private String attributionLinkURL;
    private String attributionImage;
    private String attributionImageURL;
    private String termsOfUseText;
    private String termsOfUseURL;
    private String countryCode = "";
    private String icon;

    public ImageryInfo() {
    }

    public ImageryInfo(String name) {
        this.name = name;
    }

    public ImageryInfo(String name, String url) {
        this.name = name;
        this.setExtendedUrl(url);
    }

    public ImageryInfo(String name, String url, String eulaAcceptanceRequired) {
        this.name = name;
        this.setExtendedUrl(url);
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
    }

    public ImageryInfo(String name, String url, String type, String eulaAcceptanceRequired, String cookies) {
        this.name = name;
        this.setExtendedUrl(url);
        ImageryType t = ImageryType.fromString(type);
        this.cookies = cookies;
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
        if (t != null) {
            this.imageryType = t;
        } else if (type != null && !type.trim().isEmpty()) {
            throw new IllegalArgumentException("unknown type: " + type);
        }
    }

    public ImageryInfo(ImageryPreferenceEntry e) {
        CheckParameterUtil.ensureParameterNotNull(e.name, "name");
        CheckParameterUtil.ensureParameterNotNull(e.url, "url");
        this.name = e.name;
        this.id = e.id;
        this.url = e.url;
        this.description = e.description;
        this.cookies = e.cookies;
        this.eulaAcceptanceRequired = e.eula;
        this.imageryType = ImageryType.fromString(e.type);
        if (this.imageryType == null) {
            throw new IllegalArgumentException("unknown type");
        }
        this.pixelPerDegree = e.pixel_per_eastnorth;
        this.defaultMaxZoom = e.max_zoom;
        this.defaultMinZoom = e.min_zoom;
        if (e.bounds != null) {
            this.bounds = new ImageryBounds(e.bounds, ",");
            if (e.shapes != null) {
                try {
                    for (String s : e.shapes.split(";")) {
                        this.bounds.addShape(new Shape(s, ","));
                    }
                }
                catch (IllegalArgumentException ex) {
                    Main.warn(ex);
                }
            }
        }
        if (e.projections != null) {
            this.serverProjections = Arrays.asList(e.projections.split(","));
        }
        this.attributionText = e.attribution_text;
        this.attributionLinkURL = e.attribution_url;
        this.attributionImage = e.logo_image;
        this.attributionImageURL = e.logo_url;
        this.termsOfUseText = e.terms_of_use_text;
        this.termsOfUseURL = e.terms_of_use_url;
        this.countryCode = e.country_code;
        this.icon = e.icon;
    }

    public ImageryInfo(ImageryInfo i) {
        this.name = i.name;
        this.id = i.id;
        this.url = i.url;
        this.defaultEntry = i.defaultEntry;
        this.cookies = i.cookies;
        this.eulaAcceptanceRequired = null;
        this.imageryType = i.imageryType;
        this.pixelPerDegree = i.pixelPerDegree;
        this.defaultMaxZoom = i.defaultMaxZoom;
        this.defaultMinZoom = i.defaultMinZoom;
        this.bounds = i.bounds;
        this.serverProjections = i.serverProjections;
        this.attributionText = i.attributionText;
        this.attributionLinkURL = i.attributionLinkURL;
        this.attributionImage = i.attributionImage;
        this.attributionImageURL = i.attributionImageURL;
        this.termsOfUseText = i.termsOfUseText;
        this.termsOfUseURL = i.termsOfUseURL;
        this.countryCode = i.countryCode;
        this.icon = i.icon;
        this.description = i.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageryInfo that = (ImageryInfo)o;
        if (this.imageryType != that.imageryType) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public boolean equalsPref(ImageryInfo other) {
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        if (!Objects.equals(this.cookies, other.cookies)) {
            return false;
        }
        if (!Objects.equals(this.eulaAcceptanceRequired, other.eulaAcceptanceRequired)) {
            return false;
        }
        if (this.imageryType != other.imageryType) {
            return false;
        }
        if (this.defaultMaxZoom != other.defaultMaxZoom) {
            return false;
        }
        if (this.defaultMinZoom != other.defaultMinZoom) {
            return false;
        }
        if (!Objects.equals(this.bounds, other.bounds)) {
            return false;
        }
        if (!Objects.equals(this.serverProjections, other.serverProjections)) {
            return false;
        }
        if (!Objects.equals(this.attributionText, other.attributionText)) {
            return false;
        }
        if (!Objects.equals(this.attributionLinkURL, other.attributionLinkURL)) {
            return false;
        }
        if (!Objects.equals(this.attributionImage, other.attributionImage)) {
            return false;
        }
        if (!Objects.equals(this.attributionImageURL, other.attributionImageURL)) {
            return false;
        }
        if (!Objects.equals(this.termsOfUseText, other.termsOfUseText)) {
            return false;
        }
        if (!Objects.equals(this.termsOfUseURL, other.termsOfUseURL)) {
            return false;
        }
        if (!Objects.equals(this.countryCode, other.countryCode)) {
            return false;
        }
        if (!Objects.equals(this.icon, other.icon)) {
            return false;
        }
        return Objects.equals(this.description, other.description);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.imageryType != null ? this.imageryType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ImageryInfo{name='" + this.name + '\'' + ", countryCode='" + this.countryCode + '\'' + ", url='" + this.url + '\'' + ", imageryType=" + (Object)((Object)this.imageryType) + '}';
    }

    @Override
    public int compareTo(ImageryInfo in) {
        int i = this.countryCode.compareTo(in.countryCode);
        if (i == 0) {
            i = this.name.toLowerCase().compareTo(in.name.toLowerCase());
        }
        if (i == 0) {
            i = this.url.compareTo(in.url);
        }
        if (i == 0) {
            i = Double.compare(this.pixelPerDegree, in.pixelPerDegree);
        }
        return i;
    }

    public boolean equalsBaseValues(ImageryInfo in) {
        return this.url.equals(in.url);
    }

    public void setPixelPerDegree(double ppd) {
        this.pixelPerDegree = ppd;
    }

    public void setDefaultMaxZoom(int defaultMaxZoom) {
        this.defaultMaxZoom = defaultMaxZoom;
    }

    public void setDefaultMinZoom(int defaultMinZoom) {
        this.defaultMinZoom = defaultMinZoom;
    }

    public void setBounds(ImageryBounds b) {
        this.bounds = b;
    }

    public ImageryBounds getBounds() {
        return this.bounds;
    }

    @Override
    public boolean requiresAttribution() {
        return this.attributionText != null || this.attributionImage != null || this.termsOfUseText != null || this.termsOfUseURL != null;
    }

    @Override
    public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
        return this.attributionText;
    }

    @Override
    public String getAttributionLinkURL() {
        return this.attributionLinkURL;
    }

    @Override
    public Image getAttributionImage() {
        ImageIcon i = ImageProvider.getIfAvailable(this.attributionImage);
        if (i != null) {
            return i.getImage();
        }
        return null;
    }

    @Override
    public String getAttributionImageURL() {
        return this.attributionImageURL;
    }

    @Override
    public String getTermsOfUseText() {
        return this.termsOfUseText;
    }

    @Override
    public String getTermsOfUseURL() {
        return this.termsOfUseURL;
    }

    public void setAttributionText(String text) {
        this.attributionText = text;
    }

    public void setAttributionImageURL(String text) {
        this.attributionImageURL = text;
    }

    public void setAttributionImage(String text) {
        this.attributionImage = text;
    }

    public void setAttributionLinkURL(String text) {
        this.attributionLinkURL = text;
    }

    public void setTermsOfUseText(String text) {
        this.termsOfUseText = text;
    }

    public void setTermsOfUseURL(String text) {
        this.termsOfUseURL = text;
    }

    public void setExtendedUrl(String url) {
        CheckParameterUtil.ensureParameterNotNull(url);
        this.url = url;
        this.imageryType = ImageryType.WMS;
        this.defaultMaxZoom = 0;
        this.defaultMinZoom = 0;
        for (ImageryType type : ImageryType.values()) {
            Matcher m = Pattern.compile(type.getTypeString() + "(?:\\[(?:(\\d+),)?(\\d+)\\])?:(.*)").matcher(url);
            if (!m.matches()) continue;
            this.url = m.group(3);
            this.imageryType = type;
            if (m.group(2) != null) {
                this.defaultMaxZoom = Integer.valueOf(m.group(2));
            }
            if (m.group(1) == null) break;
            this.defaultMinZoom = Integer.valueOf(m.group(1));
            break;
        }
        if (this.serverProjections == null || this.serverProjections.isEmpty()) {
            try {
                this.serverProjections = new ArrayList<String>();
                Matcher m = Pattern.compile(".*\\{PROJ\\(([^)}]+)\\)\\}.*").matcher(url.toUpperCase());
                if (m.matches()) {
                    for (String p : m.group(1).split(",")) {
                        this.serverProjections.add(p);
                    }
                }
            }
            catch (Exception e) {
                Main.warn(e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.origName != null ? this.origName : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(String language, String name) {
        boolean isdefault = LanguageInfo.getJOSMLocaleCode(null).equals(language);
        if (LanguageInfo.isBetterLanguage(this.langName, language)) {
            this.name = isdefault ? I18n.tr(name, new Object[0]) : name;
            this.langName = language;
        }
        if (this.origName == null || isdefault) {
            this.origName = name;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void clearId() {
        if (this.id != null) {
            TreeSet<String> newAddedIds = new TreeSet<String>(Main.pref.getCollection("imagery.layers.addedIds"));
            newAddedIds.add(this.id);
            Main.pref.putCollection("imagery.layers.addedIds", newAddedIds);
        }
        this.id = null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(boolean defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    public String getCookies() {
        return this.cookies;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    public int getMaxZoom() {
        return this.defaultMaxZoom;
    }

    public int getMinZoom() {
        return this.defaultMinZoom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String language, String description) {
        boolean isdefault = LanguageInfo.getJOSMLocaleCode(null).equals(language);
        if (LanguageInfo.isBetterLanguage(this.langDescription, language)) {
            this.description = isdefault ? I18n.tr(description, new Object[0]) : description;
            this.langDescription = language;
        }
    }

    public String getToolTipText() {
        String desc = this.getDescription();
        if (desc != null && !desc.isEmpty()) {
            return "<html>" + this.getName() + "<br>" + desc + "</html>";
        }
        return this.getName();
    }

    public String getEulaAcceptanceRequired() {
        return this.eulaAcceptanceRequired;
    }

    public void setEulaAcceptanceRequired(String eulaAcceptanceRequired) {
        this.eulaAcceptanceRequired = eulaAcceptanceRequired;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<String> getServerProjections() {
        if (this.serverProjections == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.serverProjections);
    }

    public void setServerProjections(Collection<String> serverProjections) {
        this.serverProjections = new ArrayList<String>(serverProjections);
    }

    public String getExtendedUrl() {
        return this.imageryType.getTypeString() + (this.defaultMaxZoom != 0 ? "[" + (this.defaultMinZoom != 0 ? this.defaultMinZoom + "," : "") + this.defaultMaxZoom + "]" : "") + ":" + this.url;
    }

    public String getToolbarName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + "#PPD=" + this.pixelPerDegree;
        }
        return res;
    }

    public String getMenuName() {
        String res = this.name;
        if (this.pixelPerDegree != 0.0) {
            res = res + " (" + this.pixelPerDegree + ")";
        }
        return res;
    }

    public boolean hasAttribution() {
        return this.attributionText != null;
    }

    public void copyAttribution(ImageryInfo i) {
        this.attributionImage = i.attributionImage;
        this.attributionImageURL = i.attributionImageURL;
        this.attributionText = i.attributionText;
        this.attributionLinkURL = i.attributionLinkURL;
        this.termsOfUseText = i.termsOfUseText;
        this.termsOfUseURL = i.termsOfUseURL;
    }

    public void setAttribution(AbstractTileSource s) {
        ImageIcon i;
        if (this.attributionText != null) {
            if ("osm".equals(this.attributionText)) {
                s.setAttributionText(new OsmTileSource.Mapnik().getAttributionText(0, null, null));
            } else {
                s.setAttributionText(this.attributionText);
            }
        }
        if (this.attributionLinkURL != null) {
            if ("osm".equals(this.attributionLinkURL)) {
                s.setAttributionLinkURL(new OsmTileSource.Mapnik().getAttributionLinkURL());
            } else {
                s.setAttributionLinkURL(this.attributionLinkURL);
            }
        }
        if (this.attributionImage != null && (i = ImageProvider.getIfAvailable(null, this.attributionImage)) != null) {
            s.setAttributionImage(i.getImage());
        }
        if (this.attributionImageURL != null) {
            s.setAttributionImageURL(this.attributionImageURL);
        }
        if (this.termsOfUseText != null) {
            s.setTermsOfUseText(this.termsOfUseText);
        }
        if (this.termsOfUseURL != null) {
            if ("osm".equals(this.termsOfUseURL)) {
                s.setTermsOfUseURL(new OsmTileSource.Mapnik().getTermsOfUseURL());
            } else {
                s.setTermsOfUseURL(this.termsOfUseURL);
            }
        }
    }

    public ImageryType getImageryType() {
        return this.imageryType;
    }

    public void setImageryType(ImageryType imageryType) {
        this.imageryType = imageryType;
    }

    public boolean isBlacklisted() {
        Capabilities capabilities = OsmApi.getOsmApi().getCapabilities();
        return capabilities != null && capabilities.isOnImageryBlacklist(this.url);
    }

    public static class ImageryPreferenceEntry {
        @Preferences.pref
        String name;
        @Preferences.pref
        String id;
        @Preferences.pref
        String type;
        @Preferences.pref
        String url;
        @Preferences.pref
        double pixel_per_eastnorth;
        @Preferences.pref
        String eula;
        @Preferences.pref
        String attribution_text;
        @Preferences.pref
        String attribution_url;
        @Preferences.pref
        String logo_image;
        @Preferences.pref
        String logo_url;
        @Preferences.pref
        String terms_of_use_text;
        @Preferences.pref
        String terms_of_use_url;
        @Preferences.pref
        String country_code = "";
        @Preferences.pref
        int max_zoom;
        @Preferences.pref
        int min_zoom;
        @Preferences.pref
        String cookies;
        @Preferences.pref
        String bounds;
        @Preferences.pref
        String shapes;
        @Preferences.pref
        String projections;
        @Preferences.pref
        String icon;
        @Preferences.pref
        String description;

        public ImageryPreferenceEntry() {
        }

        public ImageryPreferenceEntry(ImageryInfo i) {
            this.name = i.name;
            this.id = i.id;
            this.type = i.imageryType.getTypeString();
            this.url = i.url;
            this.pixel_per_eastnorth = i.pixelPerDegree;
            this.eula = i.eulaAcceptanceRequired;
            this.attribution_text = i.attributionText;
            this.attribution_url = i.attributionLinkURL;
            this.logo_image = i.attributionImage;
            this.logo_url = i.attributionImageURL;
            this.terms_of_use_text = i.termsOfUseText;
            this.terms_of_use_url = i.termsOfUseURL;
            this.country_code = i.countryCode;
            this.max_zoom = i.defaultMaxZoom;
            this.min_zoom = i.defaultMinZoom;
            this.cookies = i.cookies;
            this.icon = i.icon;
            this.description = i.description;
            if (i.bounds != null) {
                this.bounds = i.bounds.encodeAsString(",");
                StringBuilder shapesString = new StringBuilder();
                for (Shape s : i.bounds.getShapes()) {
                    if (shapesString.length() > 0) {
                        shapesString.append(";");
                    }
                    shapesString.append(s.encodeAsString(","));
                }
                if (shapesString.length() > 0) {
                    this.shapes = shapesString.toString();
                }
            }
            if (i.serverProjections != null && !i.serverProjections.isEmpty()) {
                StringBuilder val = new StringBuilder();
                for (String p : i.serverProjections) {
                    if (val.length() > 0) {
                        val.append(",");
                    }
                    val.append(p);
                }
                this.projections = val.toString();
            }
        }

        public String toString() {
            String s = "ImageryPreferenceEntry [name=" + this.name;
            if (this.id != null) {
                s = s + " id=" + this.id;
            }
            s = s + "]";
            return s;
        }
    }

    public static class ImageryBounds
    extends Bounds {
        private List<Shape> shapes = new ArrayList<Shape>();

        public ImageryBounds(String asString, String separator) {
            super(asString, separator);
        }

        public final void addShape(Shape shape) {
            this.shapes.add(shape);
        }

        public final void setShapes(List<Shape> shapes) {
            this.shapes = shapes;
        }

        public final List<Shape> getShapes() {
            return this.shapes;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.shapes == null ? 0 : this.shapes.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageryBounds other = (ImageryBounds)obj;
            return !(this.shapes == null ? other.shapes != null : !this.shapes.equals(other.shapes));
        }
    }

    public static enum ImageryType {
        WMS("wms"),
        TMS("tms"),
        HTML("html"),
        BING("bing"),
        SCANEX("scanex"),
        WMS_ENDPOINT("wms_endpoint");

        private final String typeString;

        private ImageryType(String urlString) {
            this.typeString = urlString;
        }

        public final String getTypeString() {
            return this.typeString;
        }

        public static ImageryType fromString(String s) {
            for (ImageryType type : ImageryType.values()) {
                if (!type.getTypeString().equals(s)) continue;
                return type;
            }
            return null;
        }
    }
}

