/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;

public class ImmutableGpxTrack
extends WithAttributes
implements GpxTrack {
    private final Collection<GpxTrackSegment> segments;
    private final double length;
    private final Bounds bounds;

    public ImmutableGpxTrack(Collection<Collection<WayPoint>> trackSegs, Map<String, Object> attributes) {
        ArrayList<ImmutableGpxTrackSegment> newSegments = new ArrayList<ImmutableGpxTrackSegment>();
        for (Collection<WayPoint> trackSeg : trackSegs) {
            if (trackSeg == null || trackSeg.isEmpty()) continue;
            newSegments.add(new ImmutableGpxTrackSegment(trackSeg));
        }
        this.attr = Collections.unmodifiableMap(new HashMap<String, Object>(attributes));
        this.segments = Collections.unmodifiableCollection(newSegments);
        this.length = this.calculateLength();
        this.bounds = this.calculateBounds();
    }

    private double calculateLength() {
        double result = 0.0;
        for (GpxTrackSegment trkseg : this.segments) {
            result += trkseg.length();
        }
        return result;
    }

    private Bounds calculateBounds() {
        Bounds result = null;
        for (GpxTrackSegment segment : this.segments) {
            Bounds segBounds = segment.getBounds();
            if (segBounds == null) continue;
            if (result == null) {
                result = new Bounds(segBounds);
                continue;
            }
            result.extend(segBounds);
        }
        return result;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attr;
    }

    @Override
    public Bounds getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return new Bounds(this.bounds);
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    public Collection<GpxTrackSegment> getSegments() {
        return this.segments;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }
}

