/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.geom.Area;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;

public class GpxData
extends WithAttributes {
    public File storageFile;
    public boolean fromServer;
    public String creator;
    public final Collection<GpxTrack> tracks = new LinkedList<GpxTrack>();
    public final Collection<GpxRoute> routes = new LinkedList<GpxRoute>();
    public final Collection<WayPoint> waypoints = new LinkedList<WayPoint>();
    public final Set<DataSource> dataSources = new HashSet<DataSource>();

    public void mergeFrom(GpxData other) {
        if (this.storageFile == null && other.storageFile != null) {
            this.storageFile = other.storageFile;
        }
        this.fromServer = this.fromServer && other.fromServer;
        for (Map.Entry ent : other.attr.entrySet()) {
            String k = (String)ent.getKey();
            if (k.equals("meta.links") && this.attr.containsKey("meta.links")) {
                Collection my = super.getCollection("meta.links");
                Collection their = (Collection)ent.getValue();
                my.addAll(their);
                continue;
            }
            this.put(k, ent.getValue());
        }
        this.tracks.addAll(other.tracks);
        this.routes.addAll(other.routes);
        this.waypoints.addAll(other.waypoints);
        this.dataSources.addAll(other.dataSources);
    }

    public boolean hasTrackPoints() {
        for (GpxTrack trk : this.tracks) {
            for (GpxTrackSegment trkseg : trk.getSegments()) {
                if (trkseg.getWayPoints().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRoutePoints() {
        for (GpxRoute rte : this.routes) {
            if (rte.routePoints.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return !this.hasRoutePoints() && !this.hasTrackPoints() && this.waypoints.isEmpty();
    }

    public Bounds getMetaBounds() {
        Object value = this.get("meta.bounds");
        if (value instanceof Bounds) {
            return (Bounds)value;
        }
        return null;
    }

    public Bounds recalculateBounds() {
        Bounds bounds = null;
        for (WayPoint wpt : this.waypoints) {
            if (bounds == null) {
                bounds = new Bounds(wpt.getCoor());
                continue;
            }
            bounds.extend(wpt.getCoor());
        }
        for (GpxRoute rte : this.routes) {
            for (WayPoint wpt : rte.routePoints) {
                if (bounds == null) {
                    bounds = new Bounds(wpt.getCoor());
                    continue;
                }
                bounds.extend(wpt.getCoor());
            }
        }
        for (GpxTrack trk : this.tracks) {
            Bounds trkBounds = trk.getBounds();
            if (trkBounds == null) continue;
            if (bounds == null) {
                bounds = new Bounds(trkBounds);
                continue;
            }
            bounds.extend(trkBounds);
        }
        return bounds;
    }

    public double length() {
        double result = 0.0;
        for (GpxTrack trk : this.tracks) {
            result += trk.length();
        }
        return result;
    }

    public static Date[] getMinMaxTimeForTrack(GpxTrack trk) {
        WayPoint earliest = null;
        WayPoint latest = null;
        for (GpxTrackSegment seg : trk.getSegments()) {
            for (WayPoint pnt : seg.getWayPoints()) {
                if (latest == null) {
                    latest = earliest = pnt;
                    continue;
                }
                if (pnt.compareTo(earliest) < 0) {
                    earliest = pnt;
                    continue;
                }
                latest = pnt;
            }
        }
        if (earliest == null || latest == null) {
            return null;
        }
        return new Date[]{earliest.getTime(), latest.getTime()};
    }

    public Date[] getMinMaxTimeForAllTracks() {
        double min = 1.0E100;
        double max = -1.0E100;
        double now = (double)System.currentTimeMillis() / 1000.0;
        for (GpxTrack trk : this.tracks) {
            for (GpxTrackSegment seg : trk.getSegments()) {
                for (WayPoint pnt : seg.getWayPoints()) {
                    double t = pnt.time;
                    if (!(t > 0.0) || !(t <= now)) continue;
                    if (t > max) {
                        max = t;
                    }
                    if (!(t < min)) continue;
                    min = t;
                }
            }
        }
        if (min == 1.0E100 || max == -1.0E100) {
            return null;
        }
        return new Date[]{new Date((long)(min * 1000.0)), new Date((long)(max * 1000.0))};
    }

    public WayPoint nearestPointOnTrack(EastNorth P, double tolerance) {
        double PNminsq = tolerance * tolerance;
        EastNorth bestEN = null;
        double bestTime = 0.0;
        double px = P.east();
        double py = P.north();
        double rx = 0.0;
        double ry = 0.0;
        if (this.tracks == null) {
            return null;
        }
        for (GpxTrack track : this.tracks) {
            for (GpxTrackSegment seg : track.getSegments()) {
                EastNorth c;
                double PRsq;
                double y;
                double x;
                WayPoint R = null;
                for (WayPoint S : seg.getWayPoints()) {
                    EastNorth c2 = S.getEastNorth();
                    if (R == null) {
                        R = S;
                        rx = c2.east();
                        x = px - rx;
                        double PRsq2 = x * x + (y = py - (ry = c2.north())) * y;
                        if (!(PRsq2 < PNminsq)) continue;
                        PNminsq = PRsq2;
                        bestEN = c2;
                        bestTime = R.time;
                        continue;
                    }
                    double sx = c2.east();
                    double sy = c2.north();
                    double A2 = sy - ry;
                    double B = rx - sx;
                    double C = -A2 * rx - B * ry;
                    double RSsq = A2 * A2 + B * B;
                    if (RSsq == 0.0) continue;
                    double PNsq = A2 * px + B * py + C;
                    if ((PNsq = PNsq * PNsq / RSsq) < PNminsq) {
                        x = px - rx;
                        y = py - ry;
                        double PRsq3 = x * x + y * y;
                        x = px - sx;
                        y = py - sy;
                        double PSsq = x * x + y * y;
                        if (PRsq3 - PNsq <= RSsq && PSsq - PNsq <= RSsq) {
                            double RNoverRS = Math.sqrt((PRsq3 - PNsq) / RSsq);
                            double nx = rx - RNoverRS * B;
                            double ny = ry + RNoverRS * A2;
                            bestEN = new EastNorth(nx, ny);
                            bestTime = R.time + RNoverRS * (S.time - R.time);
                            PNminsq = PNsq;
                        }
                    }
                    R = S;
                    rx = sx;
                    ry = sy;
                }
                if (R == null || !((PRsq = (x = px - (rx = (c = R.getEastNorth()).east())) * x + (y = py - (ry = c.north())) * y) < PNminsq)) continue;
                PNminsq = PRsq;
                bestEN = c;
                bestTime = R.time;
            }
        }
        if (bestEN == null) {
            return null;
        }
        WayPoint best = new WayPoint(Main.getProjection().eastNorth2latlon(bestEN));
        best.time = bestTime;
        return best;
    }

    public Iterable<Collection<WayPoint>> getLinesIterable(final boolean[] trackVisibility) {
        return new Iterable<Collection<WayPoint>>(){

            @Override
            public Iterator<Collection<WayPoint>> iterator() {
                return new LinesIterator(GpxData.this, trackVisibility);
            }
        };
    }

    public void resetEastNorthCache() {
        if (this.waypoints != null) {
            for (WayPoint wp : this.waypoints) {
                wp.invalidateEastNorthCache();
            }
        }
        if (this.tracks != null) {
            for (GpxTrack track : this.tracks) {
                for (GpxTrackSegment segment : track.getSegments()) {
                    for (WayPoint wp : segment.getWayPoints()) {
                        wp.invalidateEastNorthCache();
                    }
                }
            }
        }
        if (this.routes != null) {
            for (GpxRoute route : this.routes) {
                if (route.routePoints == null) continue;
                for (WayPoint wp : route.routePoints) {
                    wp.invalidateEastNorthCache();
                }
            }
        }
    }

    public Collection<DataSource> getDataSources() {
        return this.dataSources;
    }

    public Area getDataSourceArea() {
        return DataSource.getDataSourceArea(this.dataSources);
    }

    public List<Bounds> getDataSourceBounds() {
        return DataSource.getDataSourceBounds(this.dataSources);
    }

    public static class LinesIterator
    implements Iterator<Collection<WayPoint>> {
        private Iterator<GpxTrack> itTracks;
        private int idxTracks;
        private Iterator<GpxTrackSegment> itTrackSegments;
        private final Iterator<GpxRoute> itRoutes;
        private Collection<WayPoint> next;
        private final boolean[] trackVisibility;

        public LinesIterator(GpxData data, boolean[] trackVisibility) {
            this.itTracks = data.tracks.iterator();
            this.idxTracks = -1;
            this.itRoutes = data.routes.iterator();
            this.trackVisibility = trackVisibility;
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Collection<WayPoint> next() {
            Collection<WayPoint> current = this.next;
            this.next = this.getNext();
            return current;
        }

        private Collection<WayPoint> getNext() {
            if (this.itTracks != null) {
                if (this.itTrackSegments != null && this.itTrackSegments.hasNext()) {
                    return this.itTrackSegments.next().getWayPoints();
                }
                while (this.itTracks.hasNext()) {
                    GpxTrack nxtTrack = this.itTracks.next();
                    ++this.idxTracks;
                    if (this.trackVisibility != null && !this.trackVisibility[this.idxTracks]) continue;
                    this.itTrackSegments = nxtTrack.getSegments().iterator();
                    if (!this.itTrackSegments.hasNext()) continue;
                    return this.itTrackSegments.next().getWayPoints();
                }
                this.itTracks = null;
            }
            if (this.itRoutes.hasNext()) {
                return this.itRoutes.next().routePoints;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

