/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import org.openstreetmap.josm.data.coor.LatLon;

public final class QuadTiling {
    public static final int NR_LEVELS = 24;
    public static final double WORLD_PARTS = 1.6777216E7;
    public static final int TILES_PER_LEVEL_SHIFT = 2;
    public static final int TILES_PER_LEVEL = 4;
    public static final int X_PARTS = 360;
    public static final int X_BIAS = -180;
    public static final int Y_PARTS = 180;
    public static final int Y_BIAS = -90;

    public static LatLon tile2LatLon(long quad) {
        double x_unit = 180.0;
        double y_unit = 90.0;
        long shift = 46L;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < 24; ++i) {
            long bits = quad >> (int)shift & 3L;
            if ((bits & 2L) != 0L) {
                x += x_unit;
            }
            if ((bits & 1L) != 0L) {
                y += y_unit;
            }
            x_unit /= 2.0;
            y_unit /= 2.0;
            shift -= 2L;
        }
        return new LatLon(y += -90.0, x += -180.0);
    }

    static long xy2tile(long x, long y) {
        long tile = 0L;
        for (int i = 23; i >= 0; --i) {
            long xbit = x >> i & 1L;
            long ybit = y >> i & 1L;
            tile <<= 2;
            tile |= xbit << 1 | ybit;
        }
        return tile;
    }

    static long lon2x(double lon) {
        long ret = (long)((lon + 180.0) * 1.6777216E7 / 360.0);
        if ((double)ret == 1.6777216E7) {
            --ret;
        }
        return ret;
    }

    static long lat2y(double lat) {
        long ret = (long)((lat + 90.0) * 1.6777216E7 / 180.0);
        if ((double)ret == 1.6777216E7) {
            --ret;
        }
        return ret;
    }

    public static long quadTile(LatLon coor) {
        return QuadTiling.xy2tile(QuadTiling.lon2x(coor.lon()), QuadTiling.lat2y(coor.lat()));
    }

    public static int index(int level, long quad) {
        long mask = 3L;
        int total_shift = 2 * (24 - level - 1);
        return (int)(mask & quad >> total_shift);
    }

    public static int index(LatLon coor, int level) {
        if (coor == null) {
            return 0;
        }
        return QuadTiling.index(coor.lat(), coor.lon(), level);
    }

    public static int index(double lat, double lon, int level) {
        long x = QuadTiling.lon2x(lon);
        long y = QuadTiling.lat2y(lat);
        int shift = 24 - level - 1;
        return (int)((x >> shift & 1L) * 2L + (y >> shift & 1L));
    }
}

