/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.awt.geom.Area;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LatLon
extends Coordinate {
    public static final double MAX_SERVER_PRECISION = 1.0E-7;
    public static final double MAX_SERVER_INV_PRECISION = 1.0E7;
    public static final int MAX_SERVER_DIGITS = 7;
    public static final LatLon ZERO = new LatLon(0.0, 0.0);
    private static DecimalFormat cDmsMinuteFormatter = new DecimalFormat("00");
    private static DecimalFormat cDmsSecondFormatter = new DecimalFormat("00.0");
    private static DecimalFormat cDmMinuteFormatter = new DecimalFormat("00.000");
    public static final DecimalFormat cDdFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
    public static final DecimalFormat cDdHighPecisionFormatter;
    private static final String cDms60;
    private static final String cDms00;
    private static final String cDm60;
    private static final String cDm00;
    public static final String SOUTH;
    public static final String NORTH;
    public static final String WEST;
    public static final String EAST;

    public static boolean isValidLat(double lat) {
        return lat >= -90.0 && lat <= 90.0;
    }

    public static boolean isValidLon(double lon) {
        return lon >= -180.0 && lon <= 180.0;
    }

    public boolean isValid() {
        return LatLon.isValidLat(this.lat()) && LatLon.isValidLon(this.lon());
    }

    public static double toIntervalLat(double value) {
        if (value < -90.0) {
            return -90.0;
        }
        if (value > 90.0) {
            return 90.0;
        }
        return value;
    }

    public static double toIntervalLon(double value) {
        if (LatLon.isValidLon(value)) {
            return value;
        }
        int n = (int)(value + Math.signum(value) * 180.0) / 360;
        return value - (double)n * 360.0;
    }

    public static String dms(double pCoordinate) {
        double tAbsCoord = Math.abs(pCoordinate);
        int tDegree = (int)tAbsCoord;
        double tTmpMinutes = (tAbsCoord - (double)tDegree) * 60.0;
        int tMinutes = (int)tTmpMinutes;
        double tSeconds = (tTmpMinutes - (double)tMinutes) * 60.0;
        String sDegrees = Integer.toString(tDegree);
        String sMinutes = cDmsMinuteFormatter.format(tMinutes);
        String sSeconds = cDmsSecondFormatter.format(tSeconds);
        if (cDms60.equals(sSeconds)) {
            sSeconds = cDms00;
            sMinutes = cDmsMinuteFormatter.format(tMinutes + 1);
        }
        if ("60".equals(sMinutes)) {
            sMinutes = "00";
            sDegrees = Integer.toString(tDegree + 1);
        }
        return sDegrees + "\u00b0" + sMinutes + "'" + sSeconds + "\"";
    }

    public static String dm(double pCoordinate) {
        double tAbsCoord = Math.abs(pCoordinate);
        int tDegree = (int)tAbsCoord;
        double tMinutes = (tAbsCoord - (double)tDegree) * 60.0;
        String sDegrees = Integer.toString(tDegree);
        String sMinutes = cDmMinuteFormatter.format(tMinutes);
        if (sMinutes.equals(cDm60)) {
            sMinutes = cDm00;
            sDegrees = Integer.toString(tDegree + 1);
        }
        return sDegrees + "\u00b0" + sMinutes + "'";
    }

    public LatLon(double lat, double lon) {
        super(lon, lat);
    }

    protected LatLon(LatLon coor) {
        super(coor.lon(), coor.lat());
    }

    public double lat() {
        return this.y;
    }

    public String latToString(CoordinateFormat d) {
        switch (d) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.y);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.y) + (this.y < 0.0 ? SOUTH : NORTH);
            }
            case NAUTICAL: {
                return LatLon.dm(this.y) + (this.y < 0.0 ? SOUTH : NORTH);
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.getProjection().latlon2eastNorth(this).north());
            }
        }
        return "ERR";
    }

    public double lon() {
        return this.x;
    }

    public String lonToString(CoordinateFormat d) {
        switch (d) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.x);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.x) + (this.x < 0.0 ? WEST : EAST);
            }
            case NAUTICAL: {
                return LatLon.dm(this.x) + (this.x < 0.0 ? WEST : EAST);
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.getProjection().latlon2eastNorth(this).east());
            }
        }
        return "ERR";
    }

    public boolean equalsEpsilon(LatLon other) {
        double p = 5.0E-8;
        return Math.abs(this.lat() - other.lat()) <= p && Math.abs(this.lon() - other.lon()) <= p;
    }

    public boolean isOutSideWorld() {
        Bounds b = Main.getProjection().getWorldBoundsLatLon();
        return this.lat() < b.getMinLat() || this.lat() > b.getMaxLat() || this.lon() < b.getMinLon() || this.lon() > b.getMaxLon();
    }

    public boolean isWithin(Bounds b) {
        return b.contains(this);
    }

    public boolean isIn(Area a) {
        return a == null || a.contains(this.x, this.y);
    }

    public double greatCircleDistance(LatLon other) {
        double R = 6378135.0;
        double sinHalfLat = Math.sin(Math.toRadians(other.lat() - this.lat()) / 2.0);
        double sinHalfLon = Math.sin(Math.toRadians(other.lon() - this.lon()) / 2.0);
        double d = 2.0 * R * Math.asin(Math.sqrt(sinHalfLat * sinHalfLat + Math.cos(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(other.lat())) * sinHalfLon * sinHalfLon));
        if (Double.isNaN(d)) {
            Main.error("NaN in greatCircleDistance");
            d = Math.PI * R;
        }
        return d;
    }

    public double heading(LatLon other) {
        double hd = Math.atan2(Math.sin(Math.toRadians(this.lon() - other.lon())) * Math.cos(Math.toRadians(other.lat())), Math.cos(Math.toRadians(this.lat())) * Math.sin(Math.toRadians(other.lat())) - Math.sin(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(other.lat())) * Math.cos(Math.toRadians(this.lon() - other.lon())));
        if ((hd %= Math.PI * 2) < 0.0) {
            hd += Math.PI * 2;
        }
        return hd;
    }

    public String toDisplayString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(5);
        return "lat=" + nf.format(this.lat()) + "\u00b0, lon=" + nf.format(this.lon()) + "\u00b0";
    }

    public String toStringCSV(String separator) {
        return Utils.join(separator, Arrays.asList(this.latToString(CoordinateFormat.DECIMAL_DEGREES), this.lonToString(CoordinateFormat.DECIMAL_DEGREES)));
    }

    public LatLon interpolate(LatLon ll2, double proportion) {
        return new LatLon(this.lat() + proportion * (ll2.lat() - this.lat()), this.lon() + proportion * (ll2.lon() - this.lon()));
    }

    public LatLon getCenter(LatLon ll2) {
        return new LatLon((this.lat() + ll2.lat()) / 2.0, (this.lon() + ll2.lon()) / 2.0);
    }

    public double distance(LatLon ll) {
        return super.distance(ll);
    }

    public double distanceSq(LatLon ll) {
        return super.distanceSq(ll);
    }

    public String toString() {
        return "LatLon[lat=" + this.lat() + ",lon=" + this.lon() + "]";
    }

    public static double roundToOsmPrecision(double value) {
        return (double)Math.round(value * 1.0E7) / 1.0E7;
    }

    public static double roundToOsmPrecisionStrict(double value) {
        return LatLon.roundToOsmPrecision(value);
    }

    public LatLon getRoundedToOsmPrecision() {
        return new LatLon(LatLon.roundToOsmPrecision(this.lat()), LatLon.roundToOsmPrecision(this.lon()));
    }

    public LatLon getRoundedToOsmPrecisionStrict() {
        return new LatLon(LatLon.roundToOsmPrecisionStrict(this.lat()), LatLon.roundToOsmPrecisionStrict(this.lon()));
    }

    @Override
    public int hashCode() {
        return this.computeHashCode(super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    static {
        cDdFormatter.applyPattern("###0.0######");
        cDdHighPecisionFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        cDdHighPecisionFormatter.applyPattern("###0.0##########");
        cDms60 = cDmsSecondFormatter.format(60.0);
        cDms00 = cDmsSecondFormatter.format(0.0);
        cDm60 = cDmMinuteFormatter.format(60.0);
        cDm00 = cDmMinuteFormatter.format(0.0);
        SOUTH = I18n.trc("compass", "S");
        NORTH = I18n.trc("compass", "N");
        WEST = I18n.trc("compass", "W");
        EAST = I18n.trc("compass", "E");
    }
}

