/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.io.Serializable;
import org.openstreetmap.josm.data.osm.BBox;

abstract class Coordinate
implements Serializable {
    protected final double x;
    protected final double y;

    Coordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    protected final double distance(Coordinate coor) {
        return this.distance(coor.x, coor.y);
    }

    public final double distance(double px, double py) {
        double dx = this.x - px;
        double dy = this.y - py;
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected final double distanceSq(Coordinate coor) {
        return this.distanceSq(coor.x, coor.y);
    }

    public final double distanceSq(double px, double py) {
        double dx = this.x - px;
        double dy = this.y - py;
        return dx * dx + dy * dy;
    }

    public BBox toBBox() {
        return new BBox(this.x, this.y);
    }

    public BBox toBBox(double r) {
        return new BBox(this.x - r, this.y - r, this.x + r, this.y + r);
    }

    protected final int computeHashCode(int init) {
        int prime = 31;
        int result = init;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public int hashCode() {
        return this.computeHashCode(1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

