/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.conflict;

import java.util.Map;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class Conflict<T extends OsmPrimitive> {
    private final T my;
    private final T their;
    private final boolean isMyDeleted;
    private Map<PrimitiveId, PrimitiveId> mergedMap;

    public Conflict(T my, T their) {
        this(my, their, false);
    }

    public Conflict(T my, T their, boolean isMyDeleted) {
        this.my = my;
        this.their = their;
        this.isMyDeleted = isMyDeleted;
    }

    public T getMy() {
        return this.my;
    }

    public T getTheir() {
        return this.their;
    }

    public boolean isMatchingMy(OsmPrimitive my) {
        return this.my == my;
    }

    public boolean isMatchingTheir(OsmPrimitive their) {
        return this.their == their;
    }

    public boolean isParticipating(OsmPrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        return primitive.getPrimitiveId().equals(((AbstractPrimitive)this.my).getPrimitiveId()) || primitive.getPrimitiveId().equals(((AbstractPrimitive)this.their).getPrimitiveId());
    }

    public boolean isParticipating(PrimitiveId id) {
        if (id == null) {
            return false;
        }
        return id.equals(((AbstractPrimitive)this.my).getPrimitiveId()) || id.equals(((AbstractPrimitive)this.their).getPrimitiveId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.my == null ? 0 : ((OsmPrimitive)this.my).hashCode());
        result = 31 * result + (this.their == null ? 0 : ((OsmPrimitive)this.their).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conflict other = (Conflict)obj;
        if (this.my != other.my) {
            return false;
        }
        return this.their == other.their;
    }

    public boolean isMyDeleted() {
        return this.isMyDeleted;
    }

    public final Map<PrimitiveId, PrimitiveId> getMergedMap() {
        return this.mergedMap;
    }

    public final void setMergedMap(Map<PrimitiveId, PrimitiveId> mergedMap) {
        this.mergedMap = mergedMap;
    }

    public String toString() {
        return "Conflict [my=" + this.my + ", their=" + this.their + "]";
    }
}

