/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderJob;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public abstract class JCSCachedTileLoaderJob<K, V extends CacheEntry>
implements Runnable,
ICachedLoaderJob<K> {
    private static final Logger log = FeatureAdapter.getLogger(JCSCachedTileLoaderJob.class.getCanonicalName());
    protected static final long DEFAULT_EXPIRE_TIME = 604800000L;
    protected static final long EXPIRE_TIME_SERVER_LIMIT = 2419200000L;
    protected static final long ABSOLUTE_EXPIRE_TIME_LIMIT = Long.MAX_VALUE;
    public static IntegerProperty THREAD_LIMIT = new IntegerProperty("cache.jcs.max_threads", 10);
    private static Executor DOWNLOAD_JOB_DISPATCHER = new ThreadPoolExecutor(2, THREAD_LIMIT.get(), 30L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingDeque<Runnable>(5){

        @Override
        public boolean offer(Runnable t) {
            return super.offerFirst(t);
        }

        @Override
        public Runnable remove() {
            return (Runnable)super.removeFirst();
        }
    });
    private static ConcurrentMap<String, Set<ICachedLoaderListener>> inProgress = new ConcurrentHashMap<String, Set<ICachedLoaderListener>>();
    private static ConcurrentMap<String, Boolean> useHead = new ConcurrentHashMap<String, Boolean>();
    private long now;
    private ICacheAccess<K, V> cache;
    private ICacheElement<K, V> cacheElement;
    protected V cacheData = null;
    protected CacheEntryAttributes attributes = null;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> headers;

    public JCSCachedTileLoaderJob(ICacheAccess<K, V> cache, int connectTimeout, int readTimeout, Map<String, String> headers) {
        this.cache = cache;
        this.now = System.currentTimeMillis();
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.headers = headers;
    }

    private void ensureCacheElement() {
        if (this.cacheElement == null && this.getCacheKey() != null) {
            this.cacheElement = this.cache.getCacheElement(this.getCacheKey());
            if (this.cacheElement != null) {
                this.attributes = (CacheEntryAttributes)this.cacheElement.getElementAttributes();
                this.cacheData = (CacheEntry)this.cacheElement.getVal();
            }
        }
    }

    public V get() {
        this.ensureCacheElement();
        return this.cacheData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(ICachedLoaderListener listener) {
        boolean first = false;
        URL url = this.getUrl();
        String deduplicationKey = null;
        if (url != null) {
            deduplicationKey = url.toString();
        }
        if (deduplicationKey == null) {
            log.log(Level.WARNING, "No url returned for: {0}, skipping", this.getCacheKey());
            return;
        }
        ConcurrentMap<String, Set<ICachedLoaderListener>> concurrentMap = inProgress;
        synchronized (concurrentMap) {
            HashSet<ICachedLoaderListener> newListeners = (HashSet<ICachedLoaderListener>)inProgress.get(deduplicationKey);
            if (newListeners == null) {
                newListeners = new HashSet<ICachedLoaderListener>();
                inProgress.put(deduplicationKey, newListeners);
                first = true;
            }
            newListeners.add(listener);
        }
        if (first) {
            this.ensureCacheElement();
            if (this.cacheElement != null && this.isCacheElementValid() && this.isObjectLoadable()) {
                log.log(Level.FINE, "JCS - Returning object from cache: {0}", this.getCacheKey());
                this.finishLoading(true);
                return;
            }
            try {
                this.getDownloadExecutor().execute(this);
            }
            catch (RejectedExecutionException e) {
                log.log(Level.FINE, "JCS - rejected job for: {0}", this.getCacheKey());
                this.finishLoading(false);
            }
        }
    }

    protected boolean isObjectLoadable() {
        byte[] content = ((CacheEntry)this.cacheData).getContent();
        return content != null && content.length > 0;
    }

    protected boolean cacheAsEmpty() {
        return false;
    }

    protected String getServerKey() {
        return this.getUrl().getHost();
    }

    protected Executor getDownloadExecutor() {
        return DOWNLOAD_JOB_DISPATCHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        currentThread.setName("JCS Downloading: " + this.getUrl());
        try {
            if (this.loadObject()) {
                this.finishLoading(true);
            } else if (this.isObjectLoadable()) {
                this.finishLoading(true);
                log.log(Level.FINE, "JCS - found stale object in cache: {0}", this.getUrl());
            } else {
                this.finishLoading(false);
            }
        }
        finally {
            currentThread.setName(oldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLoading(boolean success) {
        Set listeners = null;
        ConcurrentMap<String, Set<ICachedLoaderListener>> concurrentMap = inProgress;
        synchronized (concurrentMap) {
            listeners = (Set)inProgress.remove(this.getUrl().toString());
        }
        if (listeners == null) {
            log.log(Level.WARNING, "Listener not found for URL: {0}. Listener not notified!", this.getUrl());
            return;
        }
        try {
            for (ICachedLoaderListener l : listeners) {
                l.loadingFinished((CacheEntry)this.cacheData, success);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "JCS - Error while loading object from cache: {0}; {1}", new Object[]{e.getMessage(), this.getUrl()});
            log.log(Level.FINE, "Stacktrace", e);
            for (ICachedLoaderListener l : listeners) {
                l.loadingFinished((CacheEntry)this.cacheData, false);
            }
        }
    }

    private boolean isCacheElementValid() {
        long expires = this.attributes.getExpirationTime();
        if (expires != 0L) {
            if (this.now > (expires = Math.min(expires, this.attributes.getCreateTime() + 2419200000L))) {
                log.log(Level.FINE, "JCS - Object {0} has expired -> valid to {1}, now is: {2}", new Object[]{this.getUrl(), Long.toString(expires), Long.toString(this.now)});
                return false;
            }
        } else if (this.now - this.attributes.getLastModification() > 604800000L) {
            log.log(Level.FINE, "JCS - Object has expired, maximum file age reached {0}", this.getUrl());
            return false;
        }
        return true;
    }

    private boolean loadObject() {
        try {
            if (this.isObjectLoadable() && Boolean.TRUE.equals(useHead.get(this.getServerKey())) && this.isCacheValidUsingHead()) {
                log.log(Level.FINE, "JCS - cache entry verified using HEAD request: {0}", this.getUrl());
                return true;
            }
            HttpURLConnection urlConn = this.getURLConnection();
            if (this.isObjectLoadable() && this.now - this.attributes.getLastModification() <= Long.MAX_VALUE) {
                urlConn.setIfModifiedSince(this.attributes.getLastModification());
            }
            if (this.isObjectLoadable() && this.attributes.getEtag() != null) {
                urlConn.addRequestProperty("If-None-Match", this.attributes.getEtag());
            }
            if (urlConn instanceof HttpURLConnection && urlConn.getResponseCode() == 304) {
                log.log(Level.FINE, "JCS - IfModifiedSince/Etag test: local version is up to date: {0}", this.getUrl());
                return true;
            }
            if (this.isObjectLoadable() && (this.attributes.getEtag() != null && this.attributes.getEtag().equals(urlConn.getRequestProperty("ETag")) || this.attributes.getLastModification() == urlConn.getLastModified())) {
                String serverKey = this.getServerKey();
                log.log(Level.INFO, "JCS - Host: {0} found not to return 304 codes for If-Modifed-Since or If-None-Match headers", serverKey);
                useHead.put(serverKey, Boolean.TRUE);
            }
            this.attributes = this.parseHeaders(urlConn);
            for (int i = 0; i < 5; ++i) {
                if (!(urlConn instanceof HttpURLConnection) || urlConn.getResponseCode() != 503) {
                    byte[] raw = JCSCachedTileLoaderJob.read(urlConn);
                    if (!this.cacheAsEmpty() && raw != null && raw.length > 0) {
                        this.cacheData = this.createCacheEntry(raw);
                        this.cache.put(this.getCacheKey(), this.cacheData, this.attributes);
                        log.log(Level.FINE, "JCS - downloaded key: {0}, length: {1}, url: {2}", new Object[]{this.getCacheKey(), raw.length, this.getUrl()});
                        return true;
                    }
                    this.cacheData = this.createCacheEntry(new byte[0]);
                    this.cache.put(this.getCacheKey(), this.cacheData, this.attributes);
                    log.log(Level.FINE, "JCS - Caching empty object {0}", this.getUrl());
                    return true;
                }
                Thread.sleep(5000 + new Random().nextInt(5000));
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.FINE, "JCS - Caching empty object as server returned 404 for: {0}", this.getUrl());
            this.cache.put(this.getCacheKey(), this.createCacheEntry(new byte[0]), this.attributes);
            return this.handleNotFound();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "JCS - Exception during download " + this.getUrl(), e);
        }
        log.log(Level.WARNING, "JCS - Silent failure during download: {0}", this.getUrl());
        return false;
    }

    protected abstract boolean handleNotFound();

    protected abstract V createCacheEntry(byte[] var1);

    private CacheEntryAttributes parseHeaders(URLConnection urlConn) {
        CacheEntryAttributes ret = new CacheEntryAttributes();
        ret.setNoTileAtZoom("no-tile".equals(urlConn.getHeaderField("X-VE-Tile-Info")));
        Long lng = urlConn.getExpiration();
        if (lng.equals(0L)) {
            try {
                String str = urlConn.getHeaderField("Cache-Control");
                if (str != null) {
                    for (String token : str.split(",")) {
                        if (!token.startsWith("max-age=")) continue;
                        lng = Long.parseLong(token.substring(8)) * 1000L + System.currentTimeMillis();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ret.setExpirationTime(lng);
        ret.setLastModification(this.now);
        ret.setEtag(urlConn.getHeaderField("ETag"));
        return ret;
    }

    private HttpURLConnection getURLConnection() throws IOException, MalformedURLException {
        HttpURLConnection urlConn = (HttpURLConnection)this.getUrl().openConnection();
        urlConn.setRequestProperty("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
        urlConn.setReadTimeout(this.readTimeout);
        urlConn.setConnectTimeout(this.connectTimeout);
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            urlConn.setRequestProperty(e.getKey(), e.getValue());
        }
        return urlConn;
    }

    private boolean isCacheValidUsingHead() throws IOException {
        HttpURLConnection urlConn = (HttpURLConnection)this.getUrl().openConnection();
        urlConn.setRequestMethod("HEAD");
        long lastModified = urlConn.getLastModified();
        return this.attributes.getEtag() != null && this.attributes.getEtag().equals(urlConn.getRequestProperty("ETag")) || lastModified != 0L && lastModified <= this.attributes.getLastModification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] read(URLConnection urlConn) throws IOException {
        try (InputStream input = urlConn.getInputStream();){
            ByteArrayOutputStream bout = new ByteArrayOutputStream(input.available());
            byte[] buffer = new byte[2048];
            boolean finished = false;
            do {
                int read;
                if ((read = input.read(buffer)) >= 0) {
                    bout.write(buffer, 0, read);
                    continue;
                }
                finished = true;
            } while (!finished);
            if (bout.size() == 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
    }
}

