/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheManager;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public class JCSCacheManager {
    private static final Logger log = FeatureAdapter.getLogger(JCSCacheManager.class.getCanonicalName());
    private static volatile CompositeCacheManager cacheManager = null;
    private static long maxObjectTTL = Long.MAX_VALUE;
    public static final IntegerProperty DEFAULT_MAX_OBJECTS_IN_MEMORY = new IntegerProperty("jcs.cache.max_objects_in_memory", 1000);

    private static void initialize() throws IOException {
        File cacheDir = new File(Main.pref.getCacheDirectory(), "jcs");
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new IOException("Cannot access cache directory");
        }
        Logger jcsLog = Logger.getLogger("org.apache.commons.jcs");
        jcsLog.setLevel(Level.INFO);
        jcsLog.setUseParentHandlers(false);
        jcsLog.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                String msg = MessageFormat.format(record.getMessage(), record.getParameters());
                if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                    Main.error(msg);
                } else if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                    Main.warn(msg);
                } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                    Main.debug(msg);
                } else {
                    Main.trace(msg);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        CompositeCacheManager cm = CompositeCacheManager.getUnconfiguredInstance();
        Properties props = new Properties();
        props.setProperty("jcs.default.cacheattributes", CompositeCacheAttributes.class.getCanonicalName());
        props.setProperty("jcs.default.cacheattributes.MaxObjects", DEFAULT_MAX_OBJECTS_IN_MEMORY.get().toString());
        props.setProperty("jcs.default.cacheattributes.UseMemoryShrinker", "true");
        props.setProperty("jcs.default.cacheattributes.DiskUsagePatternName", "UPDATE");
        props.setProperty("jcs.default.elementattributes", CacheEntryAttributes.class.getCanonicalName());
        props.setProperty("jcs.default.elementattributes.IsEternal", "false");
        props.setProperty("jcs.default.elementattributes.MaxLife", Long.toString(maxObjectTTL));
        props.setProperty("jcs.default.elementattributes.IdleTime", Long.toString(maxObjectTTL));
        props.setProperty("jcs.default.elementattributes.IsSpool", "true");
        cm.configure(props);
        cacheManager = cm;
    }

    public static <K, V> CacheAccess<K, V> getCache(String cacheName) throws IOException {
        return JCSCacheManager.getCache(cacheName, DEFAULT_MAX_OBJECTS_IN_MEMORY.get(), 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> CacheAccess<K, V> getCache(String cacheName, int maxMemoryObjects, int maxDiskObjects, String cachePath) throws IOException {
        if (cacheManager != null) {
            return JCSCacheManager.getCacheInner(cacheName, maxMemoryObjects, maxDiskObjects, cachePath);
        }
        Class<JCSCacheManager> clazz = JCSCacheManager.class;
        synchronized (JCSCacheManager.class) {
            if (cacheManager == null) {
                JCSCacheManager.initialize();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return JCSCacheManager.getCacheInner(cacheName, maxMemoryObjects, maxDiskObjects, cachePath);
        }
    }

    private static <K, V> CacheAccess<K, V> getCacheInner(String cacheName, int maxMemoryObjects, int maxDiskObjects, String cachePath) {
        CompositeCache cc = cacheManager.getCache(cacheName, JCSCacheManager.getCacheAttributes(maxMemoryObjects));
        if (cachePath != null) {
            IndexedDiskCacheAttributes diskAttributes = JCSCacheManager.getDiskCacheAttributes(maxDiskObjects, cachePath);
            diskAttributes.setCacheName(cacheName);
            IndexedDiskCache diskCache = IndexedDiskCacheManager.getInstance(null, null, new StandardSerializer()).getCache(diskAttributes);
            cc.setAuxCaches(new AuxiliaryCache[]{diskCache});
        }
        return new CacheAccess(cc);
    }

    public static void shutdown() {
        CompositeCacheManager localCacheManager = cacheManager;
        if (localCacheManager != null) {
            localCacheManager.shutDown();
        }
    }

    private static IndexedDiskCacheAttributes getDiskCacheAttributes(int maxDiskObjects, String cachePath) {
        IndexedDiskCacheAttributes ret = new IndexedDiskCacheAttributes();
        ret.setMaxKeySize(maxDiskObjects);
        if (cachePath != null) {
            File path = new File(cachePath);
            if (!path.exists() && !path.mkdirs()) {
                log.log(Level.WARNING, "Failed to create cache path: {0}", cachePath);
            } else {
                ret.setDiskPath(path);
            }
        }
        return ret;
    }

    private static CompositeCacheAttributes getCacheAttributes(int maxMemoryElements) {
        CompositeCacheAttributes ret = new CompositeCacheAttributes();
        ret.setMaxObjects(maxMemoryElements);
        ret.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        return ret;
    }
}

