/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class UndoRedoHandler
implements MapView.LayerChangeListener {
    public final LinkedList<Command> commands = new LinkedList();
    public final LinkedList<Command> redoCommands = new LinkedList();
    private final LinkedList<OsmDataLayer.CommandQueueListener> listenerCommands = new LinkedList();

    public UndoRedoHandler() {
        MapView.addLayerChangeListener(this);
    }

    public void addNoRedraw(Command c) {
        CheckParameterUtil.ensureParameterNotNull(c, "c");
        c.executeCommand();
        this.commands.add(c);
        if (this.commands.size() > Main.pref.getInteger("undo.max", 1000)) {
            this.commands.removeFirst();
        }
        this.redoCommands.clear();
    }

    public void afterAdd() {
        this.fireCommandsChanged();
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds != null) {
            ds.fireSelectionChanged();
        }
    }

    public synchronized void add(Command c) {
        this.addNoRedraw(c);
        this.afterAdd();
    }

    public void undo() {
        this.undo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undo(int num) {
        if (this.commands.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> oldSelection = Main.main.getCurrentDataSet().getSelected();
        Main.main.getCurrentDataSet().beginUpdate();
        try {
            for (int i = 1; i <= num; ++i) {
                Command c = this.commands.removeLast();
                c.undoCommand();
                this.redoCommands.addFirst(c);
                if (!this.commands.isEmpty()) continue;
                break;
            }
        }
        finally {
            Main.main.getCurrentDataSet().endUpdate();
        }
        this.fireCommandsChanged();
        Collection<OsmPrimitive> newSelection = Main.main.getCurrentDataSet().getSelected();
        if (!oldSelection.equals(newSelection)) {
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
    }

    public void redo() {
        this.redo(1);
    }

    public void redo(int num) {
        if (this.redoCommands.isEmpty()) {
            return;
        }
        Collection<OsmPrimitive> oldSelection = Main.main.getCurrentDataSet().getSelected();
        for (int i = 0; i < num; ++i) {
            Command c = this.redoCommands.removeFirst();
            c.executeCommand();
            this.commands.add(c);
            if (this.redoCommands.isEmpty()) break;
        }
        this.fireCommandsChanged();
        Collection<OsmPrimitive> newSelection = Main.main.getCurrentDataSet().getSelected();
        if (!oldSelection.equals(newSelection)) {
            Main.main.getCurrentDataSet().fireSelectionChanged();
        }
    }

    public void fireCommandsChanged() {
        for (OsmDataLayer.CommandQueueListener l : this.listenerCommands) {
            l.commandChanged(this.commands.size(), this.redoCommands.size());
        }
    }

    public void clean() {
        this.redoCommands.clear();
        this.commands.clear();
        this.fireCommandsChanged();
    }

    public void clean(Layer layer) {
        if (layer == null) {
            return;
        }
        boolean changed = false;
        Iterator it = this.commands.iterator();
        while (it.hasNext()) {
            if (!((Command)it.next()).invalidBecauselayerRemoved(layer)) continue;
            it.remove();
            changed = true;
        }
        it = this.redoCommands.iterator();
        while (it.hasNext()) {
            if (!((Command)it.next()).invalidBecauselayerRemoved(layer)) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            this.fireCommandsChanged();
        }
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        this.clean(oldLayer);
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void removeCommandQueueListener(OsmDataLayer.CommandQueueListener l) {
        this.listenerCommands.remove(l);
    }

    public boolean addCommandQueueListener(OsmDataLayer.CommandQueueListener l) {
        return this.listenerCommands.add(l);
    }
}

