/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class SystemOfMeasurement {
    public static final SystemOfMeasurement METRIC = new SystemOfMeasurement(1.0, "m", 1000.0, "km", 10000.0, "ha");
    public static final SystemOfMeasurement CHINESE = new SystemOfMeasurement(0.3333333333333333, "\u5e02\u5c3a", 500.0, "\u5e02\u91cc");
    public static final SystemOfMeasurement IMPERIAL = new SystemOfMeasurement(0.3048, "ft", 1609.344, "mi", 4046.86, "ac");
    public static final SystemOfMeasurement NAUTICAL_MILE = new SystemOfMeasurement(185.2, "kbl", 1852.0, "NM");
    public static final Map<String, SystemOfMeasurement> ALL_SYSTEMS = new LinkedHashMap<String, SystemOfMeasurement>();
    public final double aValue;
    public final double bValue;
    public final String aName;
    public final String bName;
    public final double areaCustomValue;
    public final String areaCustomName;

    public SystemOfMeasurement(double aValue, String aName, double bValue, String bName) {
        this(aValue, aName, bValue, bName, -1.0, null);
    }

    public SystemOfMeasurement(double aValue, String aName, double bValue, String bName, double areaCustomValue, String areaCustomName) {
        this.aValue = aValue;
        this.aName = aName;
        this.bValue = bValue;
        this.bName = bName;
        this.areaCustomValue = areaCustomValue;
        this.areaCustomName = areaCustomName;
    }

    public String getDistText(double dist) {
        return this.getDistText(dist, null, 0.01);
    }

    public String getDistText(double dist, NumberFormat format, double threshold) {
        double a = dist / this.aValue;
        if (!Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false) && a > this.bValue / this.aValue) {
            return SystemOfMeasurement.formatText(dist / this.bValue, this.bName, format);
        }
        if (a < threshold) {
            return "< " + SystemOfMeasurement.formatText(threshold, this.aName, format);
        }
        return SystemOfMeasurement.formatText(a, this.aName, format);
    }

    public String getAreaText(double area) {
        return this.getAreaText(area, null, 0.01);
    }

    public String getAreaText(double area, NumberFormat format, double threshold) {
        double a = area / (this.aValue * this.aValue);
        boolean lowerOnly = Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false);
        boolean customAreaOnly = Main.pref.getBoolean("system_of_measurement.use_only_custom_area_unit", false);
        if (!lowerOnly && this.areaCustomValue > 0.0 && a > this.areaCustomValue / (this.aValue * this.aValue) && a < this.bValue * this.bValue / (this.aValue * this.aValue) || customAreaOnly) {
            return SystemOfMeasurement.formatText(area / this.areaCustomValue, this.areaCustomName, format);
        }
        if (!lowerOnly && a >= this.bValue * this.bValue / (this.aValue * this.aValue)) {
            return SystemOfMeasurement.formatText(area / (this.bValue * this.bValue), this.bName + "\u00b2", format);
        }
        if (a < threshold) {
            return "< " + SystemOfMeasurement.formatText(threshold, this.aName + "\u00b2", format);
        }
        return SystemOfMeasurement.formatText(a, this.aName + "\u00b2", format);
    }

    private static String formatText(double v, String unit, NumberFormat format) {
        if (format != null) {
            return format.format(v) + " " + unit;
        }
        return String.format(Locale.US, "%." + (v < 9.999999 ? 2 : 1) + "f %s", v, unit);
    }

    static {
        ALL_SYSTEMS.put(I18n.marktr("Metric"), METRIC);
        ALL_SYSTEMS.put(I18n.marktr("Chinese"), CHINESE);
        ALL_SYSTEMS.put(I18n.marktr("Imperial"), IMPERIAL);
        ALL_SYSTEMS.put(I18n.marktr("Nautical Mile"), NAUTICAL_MILE);
    }
}

