/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.Color;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class Preferences {
    private File preferencesDir = null;
    private File cacheDir = null;
    private File userdataDir = null;
    private boolean saveOnPut = true;
    protected final SortedMap<String, Setting<?>> settingsMap = new TreeMap();
    protected final SortedMap<String, Setting<?>> defaultsMap = new TreeMap();
    protected final SortedMap<String, String> colornames = new TreeMap<String, String>();
    private final CopyOnWriteArrayList<PreferenceChangedListener> listeners = new CopyOnWriteArrayList();
    protected XMLStreamReader parser;

    public void addPreferenceChangeListener(PreferenceChangedListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removePreferenceChangeListener(PreferenceChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePreferenceChanged(String key, Setting<?> oldValue, Setting<?> newValue) {
        DefaultPreferenceChangeEvent evt = new DefaultPreferenceChangeEvent(key, oldValue, newValue);
        for (PreferenceChangedListener l : this.listeners) {
            l.preferenceChanged(evt);
        }
    }

    @Deprecated
    public String getPreferencesDir() {
        String path = this.getPreferencesDirectory().getPath();
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    public File getPreferencesDirectory() {
        if (this.preferencesDir != null) {
            return this.preferencesDir;
        }
        String path = System.getProperty("josm.pref");
        this.preferencesDir = path != null ? new File(path).getAbsoluteFile() : ((path = System.getProperty("josm.home")) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultPrefDirectory());
        return this.preferencesDir;
    }

    public File getUserDataDirectory() {
        if (this.userdataDir != null) {
            return this.userdataDir;
        }
        String path = System.getProperty("josm.userdata");
        this.userdataDir = path != null ? new File(path).getAbsoluteFile() : ((path = System.getProperty("josm.home")) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultUserDataDirectory());
        return this.userdataDir;
    }

    public File getPreferenceFile() {
        return new File(this.getPreferencesDirectory(), "preferences.xml");
    }

    public File getPluginsDirectory() {
        return new File(this.getUserDataDirectory(), "plugins");
    }

    public File getCacheDirectory() {
        if (this.cacheDir != null) {
            return this.cacheDir;
        }
        String path = System.getProperty("josm.cache");
        this.cacheDir = path != null ? new File(path).getAbsoluteFile() : ((path = System.getProperty("josm.home")) != null ? new File(path, "cache") : ((path = this.get("cache.folder", null)) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultCacheDirectory()));
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            Main.warn(I18n.tr("Failed to create missing cache directory: {0}", this.cacheDir.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing cache directory: {0}</html>", this.cacheDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
        }
        return this.cacheDir;
    }

    private void addPossibleResourceDir(Set<String> locations, String s) {
        if (s != null) {
            if (!s.endsWith(File.separator)) {
                s = s + File.separator;
            }
            locations.add(s);
        }
    }

    public Collection<String> getAllPossiblePreferenceDirs() {
        HashSet<String> locations = new HashSet<String>();
        this.addPossibleResourceDir(locations, this.getPreferencesDirectory().getPath());
        this.addPossibleResourceDir(locations, this.getUserDataDirectory().getPath());
        this.addPossibleResourceDir(locations, System.getenv("JOSM_RESOURCES"));
        this.addPossibleResourceDir(locations, System.getProperty("josm.resources"));
        if (Main.isPlatformWindows()) {
            String appdata = System.getenv("APPDATA");
            if (System.getenv("ALLUSERSPROFILE") != null && appdata != null && appdata.lastIndexOf(File.separator) != -1) {
                appdata = appdata.substring(appdata.lastIndexOf(File.separator));
                locations.add(new File(new File(System.getenv("ALLUSERSPROFILE"), appdata), "JOSM").getPath());
            }
        } else {
            locations.add("/usr/local/share/josm/");
            locations.add("/usr/local/lib/josm/");
            locations.add("/usr/share/josm/");
            locations.add("/usr/lib/josm/");
        }
        return locations;
    }

    public synchronized String get(String key) {
        String value = this.get(key, null);
        return value == null ? "" : value;
    }

    public synchronized String get(String key, String def) {
        return (String)this.getSetting(key, new StringSetting(def), StringSetting.class).getValue();
    }

    public synchronized Map<String, String> getAllPrefix(String prefix) {
        TreeMap<String, String> all = new TreeMap<String, String>();
        for (Map.Entry<String, Setting<?>> e : this.settingsMap.entrySet()) {
            if (!e.getKey().startsWith(prefix) || !(e.getValue() instanceof StringSetting)) continue;
            all.put(e.getKey(), (String)((StringSetting)e.getValue()).getValue());
        }
        return all;
    }

    public synchronized List<String> getAllPrefixCollectionKeys(String prefix) {
        LinkedList<String> all = new LinkedList<String>();
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || !(entry.getValue() instanceof ListSetting)) continue;
            all.add(entry.getKey());
        }
        return all;
    }

    public synchronized Map<String, String> getAllColors() {
        TreeMap<String, String> all = new TreeMap<String, String>();
        for (Map.Entry<String, Setting<?>> e : this.defaultsMap.entrySet()) {
            StringSetting d;
            if (!e.getKey().startsWith("color.") || !(e.getValue() instanceof StringSetting) || (d = (StringSetting)e.getValue()).getValue() == null) continue;
            all.put(e.getKey().substring(6), (String)d.getValue());
        }
        for (Map.Entry<String, Setting<?>> e : this.settingsMap.entrySet()) {
            if (!e.getKey().startsWith("color.") || !(e.getValue() instanceof StringSetting)) continue;
            all.put(e.getKey().substring(6), (String)((StringSetting)e.getValue()).getValue());
        }
        return all;
    }

    public synchronized boolean getBoolean(String key) {
        String s = this.get(key, null);
        return s == null ? false : Boolean.parseBoolean(s);
    }

    public synchronized boolean getBoolean(String key, boolean def) {
        return Boolean.parseBoolean(this.get(key, Boolean.toString(def)));
    }

    public synchronized boolean getBoolean(String key, String specName, boolean def) {
        boolean generic = this.getBoolean(key, def);
        String skey = key + "." + specName;
        Setting prop = (Setting)this.settingsMap.get(skey);
        if (prop instanceof StringSetting) {
            return Boolean.parseBoolean((String)((StringSetting)prop).getValue());
        }
        return generic;
    }

    public boolean put(String key, String value) {
        if (value != null && value.length() == 0) {
            value = null;
        }
        return this.putSetting(key, value == null ? null : new StringSetting(value));
    }

    public boolean put(String key, boolean value) {
        return this.put(key, Boolean.toString(value));
    }

    public boolean putInteger(String key, Integer value) {
        return this.put(key, Integer.toString(value));
    }

    public boolean putDouble(String key, Double value) {
        return this.put(key, Double.toString(value));
    }

    public boolean putLong(String key, Long value) {
        return this.put(key, Long.toString(value));
    }

    public void save() throws IOException {
        this.putInteger("josm.version", Version.getInstance().getVersion());
        this.updateSystemProperties();
        File prefFile = this.getPreferenceFile();
        File backupFile = new File(prefFile + "_backup");
        if (prefFile.exists()) {
            Utils.copyFile(prefFile, backupFile);
        }
        try (PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(prefFile + "_tmp"), StandardCharsets.UTF_8), false);){
            out.print(this.toXML(false));
        }
        File tmpFile = new File(prefFile + "_tmp");
        Utils.copyFile(tmpFile, prefFile);
        tmpFile.delete();
        this.setCorrectPermissions(prefFile);
        this.setCorrectPermissions(backupFile);
    }

    private void setCorrectPermissions(File file) {
        file.setReadable(false, false);
        file.setWritable(false, false);
        file.setExecutable(false, false);
        file.setReadable(true, true);
        file.setWritable(true, true);
    }

    public void load() throws IOException, SAXException, XMLStreamException {
        this.settingsMap.clear();
        File pref2 = this.getPreferenceFile();
        try (BufferedReader in = Files.newBufferedReader(pref2.toPath(), StandardCharsets.UTF_8);){
            this.validateXML(in);
        }
        in = Files.newBufferedReader(pref2.toPath(), StandardCharsets.UTF_8);
        var3_3 = null;
        try {
            this.fromXML(in);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var3_3 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    in.close();
                }
            }
        }
        this.updateSystemProperties();
        this.removeObsolete();
    }

    public void init(boolean reset) {
        File prefDir = this.getPreferencesDirectory();
        if (prefDir.exists()) {
            if (!prefDir.isDirectory()) {
                Main.warn(I18n.tr("Failed to initialize preferences. Preference directory ''{0}'' is not a directory.", prefDir.getAbsoluteFile()));
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' is not a directory.</html>", prefDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
        } else if (!prefDir.mkdirs()) {
            Main.warn(I18n.tr("Failed to initialize preferences. Failed to create missing preference directory: {0}", prefDir.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", prefDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        File preferenceFile = this.getPreferenceFile();
        try {
            if (!preferenceFile.exists()) {
                Main.info(I18n.tr("Missing preference file ''{0}''. Creating a default preference file.", preferenceFile.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            } else if (reset) {
                Main.warn(I18n.tr("Replacing existing preference file ''{0}'' with default preference file.", preferenceFile.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            }
        }
        catch (IOException e) {
            Main.error(e);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        try {
            this.load();
        }
        catch (Exception e) {
            Main.error(e);
            File backupFile = new File(prefDir, "preferences.xml.bak");
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", backupFile.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
            Main.platform.rename(preferenceFile, backupFile);
            try {
                this.resetToDefault();
                this.save();
            }
            catch (IOException e1) {
                Main.error(e1);
                Main.warn(I18n.tr("Failed to initialize preferences. Failed to reset preference file to default: {0}", this.getPreferenceFile()));
            }
        }
    }

    public final void resetToDefault() {
        this.settingsMap.clear();
    }

    public synchronized Color getColor(String colName, Color def) {
        return this.getColor(colName, null, def);
    }

    public synchronized Color getUIColor(String colName) {
        return UIManager.getColor(colName);
    }

    public synchronized String getColorName(String o) {
        Matcher m;
        try {
            m = Pattern.compile("mappaint\\.(.+?)\\.(.+)").matcher(o);
            if (m.matches()) {
                return I18n.tr("Paint style {0}: {1}", I18n.tr(I18n.escape(m.group(1)), new Object[0]), I18n.tr(I18n.escape(m.group(2)), new Object[0]));
            }
        }
        catch (Exception e) {
            Main.warn(e);
        }
        try {
            m = Pattern.compile("layer (.+)").matcher(o);
            if (m.matches()) {
                return I18n.tr("Layer: {0}", I18n.tr(I18n.escape(m.group(1)), new Object[0]));
            }
        }
        catch (Exception e) {
            Main.warn(e);
        }
        return I18n.tr(I18n.escape(this.colornames.containsKey(o) ? (String)this.colornames.get(o) : o), new Object[0]);
    }

    public Color getColor(ColorKey key) {
        return this.getColor(key.getColorName(), key.getSpecialName(), key.getDefaultValue());
    }

    public synchronized Color getColor(String colName, String specName, Color def) {
        String colStr;
        String colKey = ColorProperty.getColorKey(colName);
        if (!colKey.equals(colName)) {
            this.colornames.put(colKey, colName);
        }
        String string = colStr = specName != null ? this.get("color." + specName) : "";
        if (colStr.isEmpty()) {
            colStr = this.get("color." + colKey, ColorHelper.color2html(def, true));
        }
        if (colStr != null && !colStr.isEmpty()) {
            return ColorHelper.html2color(colStr);
        }
        return def;
    }

    public synchronized Color getDefaultColor(String colKey) {
        StringSetting col = Utils.cast(this.defaultsMap.get("color." + colKey), StringSetting.class);
        String colStr = col == null ? null : (String)col.getValue();
        return colStr == null || colStr.isEmpty() ? null : ColorHelper.html2color(colStr);
    }

    public synchronized boolean putColor(String colKey, Color val) {
        return this.put("color." + colKey, val != null ? ColorHelper.color2html(val, true) : null);
    }

    public synchronized int getInteger(String key, int def) {
        String v = this.get(key, Integer.toString(def));
        if (v.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public synchronized int getInteger(String key, String specName, int def) {
        String v = this.get(key + "." + specName);
        if (v.isEmpty()) {
            v = this.get(key, Integer.toString(def));
        }
        if (v.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public synchronized long getLong(String key, long def) {
        String v = this.get(key, Long.toString(def));
        if (null == v) {
            return def;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public synchronized double getDouble(String key, double def) {
        String v = this.get(key, Double.toString(def));
        if (null == v) {
            return def;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Collection<String> getCollection(String key, Collection<String> def) {
        return (Collection)this.getSetting(key, ListSetting.create(def), ListSetting.class).getValue();
    }

    public Collection<String> getCollection(String key) {
        Collection<String> val = this.getCollection(key, null);
        return val == null ? Collections.emptyList() : val;
    }

    public synchronized void removeFromCollection(String key, String value) {
        ArrayList<String> a = new ArrayList<String>(this.getCollection(key, Collections.emptyList()));
        a.remove(value);
        this.putCollection(key, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putSetting(String key, Setting<?> setting) {
        Setting settingOld;
        CheckParameterUtil.ensureParameterNotNull(key);
        if (setting != null && setting.getValue() == null) {
            throw new IllegalArgumentException("setting argument must not have null value");
        }
        Setting<?> settingCopy = null;
        Preferences preferences = this;
        synchronized (preferences) {
            if (setting == null) {
                settingOld = (Setting)this.settingsMap.remove(key);
                if (settingOld == null) {
                    return false;
                }
            } else {
                settingOld = (Setting)this.settingsMap.get(key);
                if (setting.equals(settingOld)) {
                    return false;
                }
                if (settingOld == null && setting.equals(this.defaultsMap.get(key))) {
                    return false;
                }
                settingCopy = setting.copy();
                this.settingsMap.put(key, settingCopy);
            }
            if (this.saveOnPut) {
                try {
                    this.save();
                }
                catch (IOException e) {
                    Main.warn(I18n.tr("Failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
                }
            }
        }
        this.firePreferenceChanged(key, settingOld, settingCopy);
        return true;
    }

    public synchronized Setting<?> getSetting(String key, Setting<?> def) {
        return this.getSetting(key, def, Setting.class);
    }

    public synchronized <T extends Setting<?>> T getSetting(String key, T def, Class<T> klass) {
        Setting prop;
        CheckParameterUtil.ensureParameterNotNull(key);
        CheckParameterUtil.ensureParameterNotNull(def);
        Setting oldDef = (Setting)this.defaultsMap.get(key);
        if (oldDef != null && oldDef.getValue() != null && def.getValue() != null && !def.equals(oldDef)) {
            Main.info("Defaults for " + key + " differ: " + def + " != " + this.defaultsMap.get(key));
        }
        if (def.getValue() != null || oldDef == null) {
            this.defaultsMap.put(key, def.copy());
        }
        if (klass.isInstance(prop = (Setting)this.settingsMap.get(key))) {
            return (T)prop;
        }
        return def;
    }

    public boolean putCollection(String key, Collection<String> value) {
        return this.putSetting(key, value == null ? null : ListSetting.create(value));
    }

    public boolean putCollectionBounded(String key, int maxsize, Collection<String> val) {
        ArrayList<String> newCollection = new ArrayList<String>(Math.min(maxsize, val.size()));
        for (String i : val) {
            if (newCollection.size() >= maxsize) break;
            newCollection.add(i);
        }
        return this.putCollection(key, newCollection);
    }

    public synchronized Collection<Collection<String>> getArray(String key, Collection<Collection<String>> def) {
        ListListSetting val = this.getSetting(key, ListListSetting.create(def), ListListSetting.class);
        return (Collection)val.getValue();
    }

    public Collection<Collection<String>> getArray(String key) {
        Collection<Collection<String>> res = this.getArray(key, null);
        return res == null ? Collections.emptyList() : res;
    }

    public boolean putArray(String key, Collection<Collection<String>> value) {
        return this.putSetting(key, value == null ? null : ListListSetting.create(value));
    }

    public Collection<Map<String, String>> getListOfStructs(String key, Collection<Map<String, String>> def) {
        return (Collection)this.getSetting(key, new MapListSetting((List<Map<String, String>>)(def == null ? null : new ArrayList<Map<String, String>>(def))), MapListSetting.class).getValue();
    }

    public boolean putListOfStructs(String key, Collection<Map<String, String>> value) {
        return this.putSetting(key, value == null ? null : new MapListSetting((List<Map<String, String>>)new ArrayList<Map<String, String>>(value)));
    }

    public <T> List<T> getListOfStructs(String key, Class<T> klass) {
        List<T> r = this.getListOfStructs(key, null, klass);
        if (r == null) {
            return Collections.emptyList();
        }
        return r;
    }

    public <T> List<T> getListOfStructs(String key, Collection<T> def, Class<T> klass) {
        Collection<Map<String, String>> prop = this.getListOfStructs(key, def == null ? null : this.serializeListOfStructs(def, klass));
        if (prop == null) {
            return def == null ? null : new ArrayList<T>(def);
        }
        ArrayList<T> lst = new ArrayList<T>();
        for (Map<String, String> entries : prop) {
            T struct = Preferences.deserializeStruct(entries, klass);
            lst.add(struct);
        }
        return lst;
    }

    public <T> boolean putListOfStructs(String key, Collection<T> val, Class<T> klass) {
        return this.putListOfStructs(key, this.serializeListOfStructs(val, klass));
    }

    private <T> Collection<Map<String, String>> serializeListOfStructs(Collection<T> l, Class<T> klass) {
        if (l == null) {
            return null;
        }
        ArrayList<Map<String, String>> vals = new ArrayList<Map<String, String>>();
        for (T struct : l) {
            if (struct == null) continue;
            vals.add(Preferences.serializeStruct(struct, klass));
        }
        return vals;
    }

    public static <T> Map<String, String> serializeStruct(T struct, Class<T> klass) {
        T structPrototype;
        try {
            structPrototype = klass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        for (Field f : klass.getDeclaredFields()) {
            if (f.getAnnotation(pref.class) == null) continue;
            f.setAccessible(true);
            try {
                Object fieldValue = f.get(struct);
                Object defaultFieldValue = f.get(structPrototype);
                if (fieldValue == null || f.getAnnotation(writeExplicitly.class) == null && Objects.equals(fieldValue, defaultFieldValue)) continue;
                hash.put(f.getName().replace("_", "-"), fieldValue.toString());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        }
        return hash;
    }

    public static <T> T deserializeStruct(Map<String, String> hash, Class<T> klass) {
        T struct = null;
        try {
            struct = klass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        for (Map.Entry<String, String> key_value : hash.entrySet()) {
            Field f;
            Object value;
            block19: {
                value = null;
                try {
                    f = klass.getDeclaredField(key_value.getKey().replace("-", "_"));
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
                catch (SecurityException ex) {
                    throw new RuntimeException(ex);
                }
                if (f.getAnnotation(pref.class) == null) continue;
                f.setAccessible(true);
                if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                    value = Boolean.parseBoolean(key_value.getValue());
                } else {
                    if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                        try {
                            value = Integer.parseInt(key_value.getValue());
                            break block19;
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                    }
                    if (f.getType() == Double.class || f.getType() == Double.TYPE) {
                        try {
                            value = Double.parseDouble(key_value.getValue());
                            break block19;
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                    }
                    if (f.getType() == String.class) {
                        value = key_value.getValue();
                    } else {
                        throw new RuntimeException("unsupported preference primitive type");
                    }
                }
            }
            try {
                f.set(struct, value);
            }
            catch (IllegalArgumentException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        return struct;
    }

    public Map<String, Setting<?>> getAllSettings() {
        return new TreeMap(this.settingsMap);
    }

    public Map<String, Setting<?>> getAllDefaults() {
        return new TreeMap(this.defaultsMap);
    }

    public void updateSystemProperties() {
        if (this.getBoolean("prefer.ipv6", false)) {
            Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true");
        }
        Utils.updateSystemProperty("http.agent", Version.getInstance().getAgentString());
        Utils.updateSystemProperty("user.language", this.get("language"));
        try {
            Field field = Toolkit.class.getDeclaredField("resources");
            field.setAccessible(true);
            field.set(null, ResourceBundle.getBundle("sun.awt.resources.awt"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getBoolean("jdk.tls.disableSNIExtension", true)) {
            Utils.updateSystemProperty("jsse.enableSNIExtension", "false");
        }
        if (this.getBoolean("jdk.Arrays.useLegacyMergeSort", !Version.getInstance().isLocalBuild())) {
            Utils.updateSystemProperty("java.util.Arrays.useLegacyMergeSort", "true");
        }
    }

    public Collection<String> getPluginSites() {
        return this.getCollection("pluginmanager.sites", Collections.singleton(Main.getJOSMWebsite() + "/pluginicons%<?plugins=>"));
    }

    public void setPluginSites(Collection<String> sites) {
        this.putCollection("pluginmanager.sites", sites);
    }

    public void validateXML(Reader in) throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try (InputStream xsdStream = new CachedFile("resource://data/preferences.xsd").getInputStream();){
            Schema schema = factory.newSchema(new StreamSource(xsdStream));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(in));
        }
    }

    public void fromXML(Reader in) throws XMLStreamException {
        XMLStreamReader parser;
        this.parser = parser = XMLInputFactory.newInstance().createXMLStreamReader(in);
        this.parse();
    }

    public void parse() throws XMLStreamException {
        int event = this.parser.getEventType();
        while (true) {
            if (event == 1) {
                this.parseRoot();
            } else if (event == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            event = this.parser.next();
        }
        this.parser.close();
    }

    public void parseRoot() throws XMLStreamException {
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                String localName;
                switch (localName = this.parser.getLocalName()) {
                    case "tag": {
                        this.settingsMap.put(this.parser.getAttributeValue(null, "key"), new StringSetting(this.parser.getAttributeValue(null, "value")));
                        this.jumpToEnd();
                        break;
                    }
                    case "list": 
                    case "collection": 
                    case "lists": 
                    case "maps": {
                        this.parseToplevelList();
                        break;
                    }
                    default: {
                        this.throwException("Unexpected element: " + localName);
                        break;
                    }
                }
                continue;
            }
            if (event == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                this.jumpToEnd();
                continue;
            }
            if (event == 2) break;
        }
    }

    protected void parseToplevelList() throws XMLStreamException {
        String key = this.parser.getAttributeValue(null, "key");
        String name = this.parser.getLocalName();
        ArrayList<String> entries = null;
        ArrayList<List<String>> lists = null;
        ArrayList<Map<String, String>> maps = null;
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                String localName;
                switch (localName = this.parser.getLocalName()) {
                    case "entry": {
                        if (entries == null) {
                            entries = new ArrayList<String>();
                        }
                        entries.add(this.parser.getAttributeValue(null, "value"));
                        this.jumpToEnd();
                        break;
                    }
                    case "list": {
                        if (lists == null) {
                            lists = new ArrayList<List<String>>();
                        }
                        lists.add(this.parseInnerList());
                        break;
                    }
                    case "map": {
                        if (maps == null) {
                            maps = new ArrayList<Map<String, String>>();
                        }
                        maps.add(this.parseMap());
                        break;
                    }
                    default: {
                        this.throwException("Unexpected element: " + localName);
                        break;
                    }
                }
                continue;
            }
            if (event == 2) break;
        }
        if (entries != null) {
            this.settingsMap.put(key, new ListSetting(Collections.unmodifiableList(entries)));
        } else if (lists != null) {
            this.settingsMap.put(key, new ListListSetting(Collections.unmodifiableList(lists)));
        } else if (maps != null) {
            this.settingsMap.put(key, new MapListSetting(Collections.unmodifiableList(maps)));
        } else if ("lists".equals(name)) {
            this.settingsMap.put(key, new ListListSetting(Collections.emptyList()));
        } else if ("maps".equals(name)) {
            this.settingsMap.put(key, new MapListSetting(Collections.emptyList()));
        } else {
            this.settingsMap.put(key, new ListSetting(Collections.emptyList()));
        }
    }

    protected List<String> parseInnerList() throws XMLStreamException {
        ArrayList<String> entries = new ArrayList<String>();
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                if ("entry".equals(this.parser.getLocalName())) {
                    entries.add(this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (event == 2) break;
        }
        return Collections.unmodifiableList(entries);
    }

    protected Map<String, String> parseMap() throws XMLStreamException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (true) {
            int event;
            if ((event = this.parser.next()) == 1) {
                if ("tag".equals(this.parser.getLocalName())) {
                    map.put(this.parser.getAttributeValue(null, "key"), this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (event == 2) break;
        }
        return Collections.unmodifiableMap(map);
    }

    protected void throwException(String msg) {
        throw new RuntimeException(msg + I18n.tr(" (at line {0}, column {1})", this.parser.getLocation().getLineNumber(), this.parser.getLocation().getColumnNumber()));
    }

    public String toXML(boolean nopass) {
        StringBuilder b = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<preferences xmlns=\"" + Main.getXMLBase() + "/preferences-1.0\" version=\"" + Version.getInstance().getVersion() + "\">\n");
        SettingToXml toXml = new SettingToXml(b, nopass);
        for (Map.Entry<String, Setting<?>> e : this.settingsMap.entrySet()) {
            toXml.setKey(e.getKey());
            e.getValue().visit(toXml);
        }
        b.append("</preferences>\n");
        return b.toString();
    }

    public void removeObsolete() {
        String[] obsolete;
        if (this.getInteger("josm.version", Version.getInstance().getVersion()) < 8099) {
            for (String key : new String[]{"mappaint.style.entries", "taggingpreset.entries"}) {
                Collection<Map<String, String>> data = this.getListOfStructs(key, (Collection<Map<String, String>>)null);
                if (data == null) continue;
                ArrayList<Map<String, String>> newlist = new ArrayList<Map<String, String>>();
                boolean modified = false;
                for (Map<String, String> map : data) {
                    LinkedHashMap<String, String> newmap = new LinkedHashMap<String, String>();
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        String val = entry.getValue();
                        String mkey = entry.getKey();
                        if ("url".equals(mkey) && val.contains("josm.openstreetmap.de/josmfile") && !val.contains("zip=1")) {
                            val = val + "&zip=1";
                            modified = true;
                        }
                        newmap.put(mkey, val);
                    }
                    newlist.add(newmap);
                }
                if (!modified) continue;
                this.putListOfStructs(key, newlist);
            }
        }
        for (String key : obsolete = new String[]{"osm.notes.enableDownload"}) {
            if (!this.settingsMap.containsKey(key)) continue;
            this.settingsMap.remove(key);
            Main.info(I18n.tr("Preference setting {0} has been removed since it is no longer used.", key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableSaveOnPut(boolean enable) {
        Preferences preferences = this;
        synchronized (preferences) {
            this.saveOnPut = enable;
        }
    }

    private class SettingToXml
    implements SettingVisitor {
        private StringBuilder b;
        private boolean noPassword;
        private String key;

        public SettingToXml(StringBuilder b, boolean noPassword) {
            this.b = b;
            this.noPassword = noPassword;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public void visit(StringSetting setting) {
            if (this.noPassword && "osm-server.password".equals(this.key)) {
                return;
            }
            if (setting.equals(Preferences.this.defaultsMap.get(this.key))) {
                return;
            }
            this.b.append("  <tag key='");
            this.b.append(XmlWriter.encode(this.key));
            this.b.append("' value='");
            this.b.append(XmlWriter.encode((String)setting.getValue()));
            this.b.append("'/>\n");
        }

        @Override
        public void visit(ListSetting setting) {
            if (setting.equals(Preferences.this.defaultsMap.get(this.key))) {
                return;
            }
            this.b.append("  <list key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (String s : (List)setting.getValue()) {
                this.b.append("    <entry value='").append(XmlWriter.encode(s)).append("'/>\n");
            }
            this.b.append("  </list>\n");
        }

        @Override
        public void visit(ListListSetting setting) {
            if (setting.equals(Preferences.this.defaultsMap.get(this.key))) {
                return;
            }
            this.b.append("  <lists key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (List list : (List)setting.getValue()) {
                this.b.append("    <list>\n");
                for (String s : list) {
                    this.b.append("      <entry value='").append(XmlWriter.encode(s)).append("'/>\n");
                }
                this.b.append("    </list>\n");
            }
            this.b.append("  </lists>\n");
        }

        @Override
        public void visit(MapListSetting setting) {
            this.b.append("  <maps key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (Map struct : (List)setting.getValue()) {
                this.b.append("    <map>\n");
                for (Map.Entry e : struct.entrySet()) {
                    this.b.append("      <tag key='").append(XmlWriter.encode((String)e.getKey())).append("' value='").append(XmlWriter.encode((String)e.getValue())).append("'/>\n");
                }
                this.b.append("    </map>\n");
            }
            this.b.append("  </maps>\n");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface writeExplicitly {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface pref {
    }

    public static interface ColorKey {
        public String getColorName();

        public String getSpecialName();

        public Color getDefaultValue();
    }

    private static class DefaultPreferenceChangeEvent
    implements PreferenceChangeEvent {
        private final String key;
        private final Setting<?> oldValue;
        private final Setting<?> newValue;

        public DefaultPreferenceChangeEvent(String key, Setting<?> oldValue, Setting<?> newValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Setting<?> getOldValue() {
            return this.oldValue;
        }

        @Override
        public Setting<?> getNewValue() {
            return this.newValue;
        }
    }

    public static interface PreferenceChangedListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }

    public static interface PreferenceChangeEvent {
        public String getKey();

        public Setting<?> getOldValue();

        public Setting<?> getNewValue();
    }

    public static interface SettingVisitor {
        public void visit(StringSetting var1);

        public void visit(ListSetting var1);

        public void visit(ListListSetting var1);

        public void visit(MapListSetting var1);
    }

    public static class MapListSetting
    extends AbstractSetting<List<Map<String, String>>> {
        public MapListSetting(List<Map<String, String>> value) {
            super(value);
            this.consistencyTest();
        }

        @Override
        public boolean equalVal(List<Map<String, String>> otherVal) {
            if (this.value == null) {
                return otherVal == null;
            }
            if (otherVal == null) {
                return false;
            }
            if (((List)this.value).size() != otherVal.size()) {
                return false;
            }
            Iterator itA = ((List)this.value).iterator();
            Iterator<Map<String, String>> itB = otherVal.iterator();
            while (itA.hasNext()) {
                if (MapListSetting.equalMap((Map)itA.next(), itB.next())) continue;
                return false;
            }
            return true;
        }

        private static boolean equalMap(Map<String, String> a, Map<String, String> b) {
            if (a == null) {
                return b == null;
            }
            if (b == null) {
                return false;
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (Map.Entry<String, String> e : a.entrySet()) {
                if (Objects.equals(e.getValue(), b.get(e.getKey()))) continue;
                return false;
            }
            return true;
        }

        public MapListSetting copy() {
            if (this.value == null) {
                return new MapListSetting(null);
            }
            ArrayList copy = new ArrayList(((List)this.value).size());
            for (Map map : (List)this.value) {
                LinkedHashMap mapCopy = new LinkedHashMap(map);
                copy.add(Collections.unmodifiableMap(mapCopy));
            }
            return new MapListSetting(Collections.unmodifiableList(copy));
        }

        private void consistencyTest() {
            if (this.value == null) {
                return;
            }
            if (((List)this.value).contains(null)) {
                throw new RuntimeException("Error: Null as list element in preference setting");
            }
            for (Map map : (List)this.value) {
                if (map.keySet().contains(null)) {
                    throw new RuntimeException("Error: Null as map key in preference setting");
                }
                if (!map.values().contains(null)) continue;
                throw new RuntimeException("Error: Null as map value in preference setting");
            }
        }

        @Override
        public void visit(SettingVisitor visitor) {
            visitor.visit(this);
        }

        public MapListSetting getNullInstance() {
            return new MapListSetting(null);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof MapListSetting)) {
                return false;
            }
            return this.equalVal((List)((MapListSetting)other).getValue());
        }
    }

    public static class ListListSetting
    extends AbstractSetting<List<List<String>>> {
        public ListListSetting(List<List<String>> value) {
            super(value);
            this.consistencyTest();
        }

        public static ListListSetting create(Collection<Collection<String>> value) {
            if (value != null) {
                ArrayList<List<String>> valueList = new ArrayList<List<String>>(value.size());
                for (Collection<String> lst : value) {
                    valueList.add(new ArrayList<String>(lst));
                }
                return new ListListSetting((List<List<String>>)valueList);
            }
            return new ListListSetting(null);
        }

        @Override
        public boolean equalVal(List<List<String>> otherVal) {
            if (this.value == null) {
                return otherVal == null;
            }
            if (otherVal == null) {
                return false;
            }
            if (((List)this.value).size() != otherVal.size()) {
                return false;
            }
            Iterator itA = ((List)this.value).iterator();
            Iterator<List<String>> itB = otherVal.iterator();
            while (itA.hasNext()) {
                if (ListSetting.equalCollection((Collection)itA.next(), (Collection<String>)itB.next())) continue;
                return false;
            }
            return true;
        }

        public ListListSetting copy() {
            if (this.value == null) {
                return new ListListSetting(null);
            }
            ArrayList copy = new ArrayList(((List)this.value).size());
            for (Collection lst : (List)this.value) {
                ArrayList lstCopy = new ArrayList(lst);
                copy.add(Collections.unmodifiableList(lstCopy));
            }
            return new ListListSetting(Collections.unmodifiableList(copy));
        }

        private void consistencyTest() {
            if (this.value == null) {
                return;
            }
            if (((List)this.value).contains(null)) {
                throw new RuntimeException("Error: Null as list element in preference setting");
            }
            for (Collection lst : (List)this.value) {
                if (!lst.contains(null)) continue;
                throw new RuntimeException("Error: Null as inner list element in preference setting");
            }
        }

        @Override
        public void visit(SettingVisitor visitor) {
            visitor.visit(this);
        }

        public ListListSetting getNullInstance() {
            return new ListListSetting(null);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof ListListSetting)) {
                return false;
            }
            return this.equalVal((List)((ListListSetting)other).getValue());
        }
    }

    public static class ListSetting
    extends AbstractSetting<List<String>> {
        public ListSetting(List<String> value) {
            super(value);
            this.consistencyTest();
        }

        public static ListSetting create(Collection<String> value) {
            return new ListSetting(value == null ? null : Collections.unmodifiableList(new ArrayList<String>(value)));
        }

        @Override
        public boolean equalVal(List<String> otherVal) {
            return ListSetting.equalCollection((Collection)this.value, otherVal);
        }

        public static boolean equalCollection(Collection<String> a, Collection<String> b) {
            if (a == null) {
                return b == null;
            }
            if (b == null) {
                return false;
            }
            if (a.size() != b.size()) {
                return false;
            }
            Iterator<String> itA = a.iterator();
            Iterator<String> itB = b.iterator();
            while (itA.hasNext()) {
                String bStr;
                String aStr = itA.next();
                if (Objects.equals(aStr, bStr = itB.next())) continue;
                return false;
            }
            return true;
        }

        public ListSetting copy() {
            return ListSetting.create((Collection)this.value);
        }

        private void consistencyTest() {
            if (this.value != null && ((List)this.value).contains(null)) {
                throw new RuntimeException("Error: Null as list element in preference setting");
            }
        }

        @Override
        public void visit(SettingVisitor visitor) {
            visitor.visit(this);
        }

        public ListSetting getNullInstance() {
            return new ListSetting(null);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof ListSetting)) {
                return false;
            }
            return this.equalVal((List)((ListSetting)other).getValue());
        }
    }

    public static class StringSetting
    extends AbstractSetting<String> {
        public StringSetting(String value) {
            super(value);
        }

        @Override
        public boolean equalVal(String otherVal) {
            if (this.value == null) {
                return otherVal == null;
            }
            return ((String)this.value).equals(otherVal);
        }

        public StringSetting copy() {
            return new StringSetting((String)this.value);
        }

        @Override
        public void visit(SettingVisitor visitor) {
            visitor.visit(this);
        }

        public StringSetting getNullInstance() {
            return new StringSetting(null);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof StringSetting)) {
                return false;
            }
            return this.equalVal((String)((StringSetting)other).getValue());
        }
    }

    public static abstract class AbstractSetting<T>
    implements Setting<T> {
        protected final T value;

        public AbstractSetting(T value) {
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "null";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AbstractSetting)) {
                return false;
            }
            AbstractSetting other = (AbstractSetting)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static interface Setting<T> {
        public T getValue();

        public boolean equalVal(T var1);

        public Setting<T> copy();

        public void visit(SettingVisitor var1);

        public Setting<T> getNullInstance();
    }
}

