/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class DataSource {
    public final Bounds bounds;
    public final String origin;

    public DataSource(Bounds bounds, String origin) {
        CheckParameterUtil.ensureParameterNotNull(bounds, "bounds");
        this.bounds = bounds;
        this.origin = origin;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bounds == null ? 0 : this.bounds.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataSource other = (DataSource)obj;
        if (this.bounds == null ? other.bounds != null : !this.bounds.equals(other.bounds)) {
            return false;
        }
        return !(this.origin == null ? other.origin != null : !this.origin.equals(other.origin));
    }

    public String toString() {
        return "DataSource [bounds=" + this.bounds + ", origin=" + this.origin + "]";
    }

    public static Area getDataSourceArea(Collection<DataSource> dataSources) {
        if (dataSources == null || dataSources.isEmpty()) {
            return null;
        }
        Area a = new Area();
        for (DataSource source : dataSources) {
            a.add(new Area(source.bounds.asRect()));
        }
        return a;
    }

    public static List<Bounds> getDataSourceBounds(Collection<DataSource> dataSources) {
        if (dataSources == null) {
            return null;
        }
        ArrayList<Bounds> ret = new ArrayList<Bounds>(dataSources.size());
        for (DataSource ds : dataSources) {
            if (ds.bounds == null) continue;
            ret.add(ds.bounds);
        }
        return ret;
    }
}

