/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.io.DownloadFileTask;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CustomConfigurator {
    private static StringBuilder summary = new StringBuilder();
    private static boolean busy = false;

    private CustomConfigurator() {
    }

    public static void log(String fmt, Object ... vars) {
        summary.append(String.format(fmt, vars));
    }

    public static void log(String s) {
        summary.append(s);
        summary.append("\n");
    }

    public static String getLog() {
        return summary.toString();
    }

    public static void readXML(String dir, String fileName) {
        CustomConfigurator.readXML(new File(dir, fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readXML(File file, Preferences prefs) {
        Class<CustomConfigurator> clazz = CustomConfigurator.class;
        synchronized (CustomConfigurator.class) {
            busy = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            new XMLCommandProcessor(prefs).openAndReadXML(file);
            clazz = CustomConfigurator.class;
            synchronized (CustomConfigurator.class) {
                CustomConfigurator.class.notifyAll();
                busy = false;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public static void readXML(File file) {
        CustomConfigurator.readXML(file, Main.pref);
    }

    public static void downloadFile(String address, String path, String base) {
        CustomConfigurator.processDownloadOperation(address, path, CustomConfigurator.getDirectoryByAbbr(base), true, false);
    }

    public static void downloadAndUnpackFile(String address, String path, String base) {
        CustomConfigurator.processDownloadOperation(address, path, CustomConfigurator.getDirectoryByAbbr(base), true, true);
    }

    public static void processDownloadOperation(String address, String path, String parentDir, boolean mkdir, boolean unzip) {
        String dir = parentDir;
        if (path.contains("..") || path.startsWith("/") || path.contains(":")) {
            return;
        }
        File fOut = new File(dir, path);
        DownloadFileTask downloadFileTask = new DownloadFileTask(Main.parent, address, fOut, mkdir, unzip);
        Main.worker.submit(downloadFileTask);
        CustomConfigurator.log("Info: downloading file from %s to %s in background ", parentDir, fOut.getAbsolutePath());
        if (unzip) {
            CustomConfigurator.log("and unpacking it");
        } else {
            CustomConfigurator.log("");
        }
    }

    public static void messageBox(String type, String text) {
        if (type == null || type.isEmpty()) {
            type = "plain";
        }
        switch (type.charAt(0)) {
            case 'i': {
                JOptionPane.showMessageDialog(Main.parent, text, I18n.tr("Information", new Object[0]), 1);
                break;
            }
            case 'w': {
                JOptionPane.showMessageDialog(Main.parent, text, I18n.tr("Warning", new Object[0]), 2);
                break;
            }
            case 'e': {
                JOptionPane.showMessageDialog(Main.parent, text, I18n.tr("Error", new Object[0]), 0);
                break;
            }
            case 'q': {
                JOptionPane.showMessageDialog(Main.parent, text, I18n.tr("Question", new Object[0]), 3);
                break;
            }
            case 'p': {
                JOptionPane.showMessageDialog(Main.parent, text, I18n.tr("Message", new Object[0]), -1);
            }
        }
    }

    public static int askForOption(String text, String opts) {
        Integer answer;
        if (opts.length() > 0) {
            Object[] options = opts.split(";");
            answer = JOptionPane.showOptionDialog(Main.parent, text, "Question", 1, 3, null, options, 0);
        } else {
            answer = JOptionPane.showOptionDialog(Main.parent, text, "Question", 1, 3, null, null, 2);
        }
        if (answer == null) {
            return -1;
        }
        return answer;
    }

    public static String askForText(String text) {
        String s = JOptionPane.showInputDialog(Main.parent, text, I18n.tr("Enter text", new Object[0]), 3);
        if (s != null && (s = s.trim()).length() > 0) {
            return s;
        }
        return "";
    }

    public static void exportPreferencesKeysToFile(String filename, boolean append, String ... keys) {
        HashSet<String> keySet = new HashSet<String>();
        Collections.addAll(keySet, keys);
        CustomConfigurator.exportPreferencesKeysToFile(filename, append, keySet);
    }

    public static void exportPreferencesKeysByPatternToFile(String fileName, boolean append, String pattern) {
        ArrayList<String> keySet = new ArrayList<String>();
        Map<String, Preferences.Setting<?>> allSettings = Main.pref.getAllSettings();
        for (String key : allSettings.keySet()) {
            if (!key.matches(pattern)) continue;
            keySet.add(key);
        }
        CustomConfigurator.exportPreferencesKeysToFile(fileName, append, keySet);
    }

    public static void exportPreferencesKeysToFile(String filename, boolean append, Collection<String> keys) {
        Element root = null;
        Document document = null;
        Document exportDocument = null;
        try {
            String toXML = Main.pref.toXML(true);
            ByteArrayInputStream is = new ByteArrayInputStream(toXML.getBytes(StandardCharsets.UTF_8));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setValidating(false);
            builderFactory.setNamespaceAware(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.parse(is);
            exportDocument = builder.newDocument();
            root = document.getDocumentElement();
        }
        catch (Exception ex) {
            Main.warn("Error getting preferences to save:" + ex.getMessage());
        }
        if (root == null) {
            return;
        }
        try {
            Element newRoot = exportDocument.createElement("config");
            exportDocument.appendChild(newRoot);
            Element prefElem = exportDocument.createElement("preferences");
            prefElem.setAttribute("operation", append ? "append" : "replace");
            newRoot.appendChild(prefElem);
            NodeList childNodes = root.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                String currentKey;
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1 || !keys.contains(currentKey = ((Element)item).getAttribute("key"))) continue;
                Node imported = exportDocument.importNode(item, true);
                prefElem.appendChild(imported);
            }
            File f = new File(filename);
            Transformer ts = TransformerFactory.newInstance().newTransformer();
            ts.setOutputProperty("indent", "yes");
            ts.transform(new DOMSource(exportDocument), new StreamResult(f.toURI().getPath()));
        }
        catch (Exception ex) {
            Main.warn("Error saving preferences part:");
            Main.error(ex);
        }
    }

    public static void deleteFile(String path, String base) {
        String dir = CustomConfigurator.getDirectoryByAbbr(base);
        if (dir == null) {
            CustomConfigurator.log("Error: Can not find base, use base=cache, base=prefs or base=plugins attribute.");
            return;
        }
        CustomConfigurator.log("Delete file: %s\n", path);
        if (path.contains("..") || path.startsWith("/") || path.contains(":")) {
            return;
        }
        File fOut = new File(dir, path);
        if (fOut.exists()) {
            CustomConfigurator.deleteFileOrDirectory(fOut);
        }
    }

    public static void deleteFileOrDirectory(String path) {
        CustomConfigurator.deleteFileOrDirectory(new File(path));
    }

    public static void deleteFileOrDirectory(File f) {
        if (f.isDirectory()) {
            for (File f1 : f.listFiles()) {
                CustomConfigurator.deleteFileOrDirectory(f1);
            }
        }
        try {
            f.delete();
        }
        catch (Exception e) {
            CustomConfigurator.log("Warning: Can not delete file " + f.getPath());
        }
    }

    public static void pluginOperation(String install, String uninstall, String delete) {
        final ArrayList installList = new ArrayList();
        final ArrayList removeList = new ArrayList();
        final ArrayList deleteList = new ArrayList();
        Collections.addAll(installList, install.toLowerCase().split(";"));
        Collections.addAll(removeList, uninstall.toLowerCase().split(";"));
        Collections.addAll(deleteList, delete.toLowerCase().split(";"));
        installList.remove("");
        removeList.remove("");
        deleteList.remove("");
        if (!installList.isEmpty()) {
            CustomConfigurator.log("Plugins install: " + installList);
        }
        if (!removeList.isEmpty()) {
            CustomConfigurator.log("Plugins turn off: " + removeList);
        }
        if (!deleteList.isEmpty()) {
            CustomConfigurator.log("Plugins delete: " + deleteList);
        }
        final ReadLocalPluginInformationTask task = new ReadLocalPluginInformationTask();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (task.isCanceled()) {
                    return;
                }
                Class<CustomConfigurator> clazz = CustomConfigurator.class;
                synchronized (CustomConfigurator.class) {
                    try {
                        while (busy) {
                            CustomConfigurator.class.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        Main.warn("InterruptedException while reading local plugin information");
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List<PluginInformation> availablePlugins = task.getAvailablePlugins();
                            ArrayList<PluginInformation> toInstallPlugins = new ArrayList<PluginInformation>();
                            ArrayList<PluginInformation> toRemovePlugins = new ArrayList<PluginInformation>();
                            ArrayList<PluginInformation> toDeletePlugins = new ArrayList<PluginInformation>();
                            for (PluginInformation pi : availablePlugins) {
                                String name = pi.name.toLowerCase();
                                if (installList.contains(name)) {
                                    toInstallPlugins.add(pi);
                                }
                                if (removeList.contains(name)) {
                                    toRemovePlugins.add(pi);
                                }
                                if (!deleteList.contains(name)) continue;
                                toDeletePlugins.add(pi);
                            }
                            if (!installList.isEmpty()) {
                                PluginDownloadTask pluginDownloadTask = new PluginDownloadTask(Main.parent, toInstallPlugins, I18n.tr("Installing plugins", new Object[0]));
                                Main.worker.submit(pluginDownloadTask);
                            }
                            ArrayList<String> pls = new ArrayList<String>(Main.pref.getCollection("plugins"));
                            for (PluginInformation pi : toInstallPlugins) {
                                if (pls.contains(pi.name)) continue;
                                pls.add(pi.name);
                            }
                            for (PluginInformation pi : toRemovePlugins) {
                                pls.remove(pi.name);
                            }
                            for (PluginInformation pi : toDeletePlugins) {
                                pls.remove(pi.name);
                                new File(Main.pref.getPluginsDirectory(), pi.name + ".jar").deleteOnExit();
                            }
                            Main.pref.putCollection("plugins", pls);
                        }
                    });
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        Main.worker.submit(task);
        Main.worker.submit(r);
    }

    private static String getDirectoryByAbbr(String base) {
        String dir = "prefs".equals(base) || base.isEmpty() ? Main.pref.getPreferencesDirectory().getAbsolutePath() : ("cache".equals(base) ? Main.pref.getCacheDirectory().getAbsolutePath() : ("plugins".equals(base) ? Main.pref.getPluginsDirectory().getAbsolutePath() : null));
        return dir;
    }

    public static Preferences clonePreferences(Preferences pref2) {
        Preferences tmp = new Preferences();
        tmp.settingsMap.putAll(pref2.settingsMap);
        tmp.defaultsMap.putAll(pref2.defaultsMap);
        tmp.colornames.putAll(pref2.colornames);
        return tmp;
    }

    public static final class PreferencesUtils {
        private static void replacePreferences(Preferences fragment, Preferences mainpref) {
            for (Map.Entry<String, Preferences.Setting<?>> entry : fragment.settingsMap.entrySet()) {
                mainpref.putSetting(entry.getKey(), entry.getValue());
            }
        }

        private static void appendPreferences(Preferences fragment, Preferences mainpref) {
            for (Map.Entry<String, Preferences.Setting<?>> entry : fragment.settingsMap.entrySet()) {
                String key = entry.getKey();
                if (entry.getValue() instanceof Preferences.StringSetting) {
                    mainpref.putSetting(key, entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Preferences.ListSetting) {
                    Preferences.ListSetting lSetting = (Preferences.ListSetting)entry.getValue();
                    Collection<String> newItems = PreferencesUtils.getCollection(mainpref, key, true);
                    if (newItems == null) continue;
                    for (String item : (List)lSetting.getValue()) {
                        if (newItems.contains(item)) continue;
                        newItems.add(item);
                    }
                    mainpref.putCollection(key, newItems);
                    continue;
                }
                if (entry.getValue() instanceof Preferences.ListListSetting) {
                    Preferences.ListListSetting llSetting = (Preferences.ListListSetting)entry.getValue();
                    Collection<Collection<String>> newLists = PreferencesUtils.getArray(mainpref, key, true);
                    if (newLists == null) continue;
                    for (Collection list : (List)llSetting.getValue()) {
                        if (newLists.contains(list)) continue;
                        newLists.add(list);
                    }
                    mainpref.putArray(key, newLists);
                    continue;
                }
                if (!(entry.getValue() instanceof Preferences.MapListSetting)) continue;
                Preferences.MapListSetting mlSetting = (Preferences.MapListSetting)entry.getValue();
                List<Map<String, String>> newMaps = PreferencesUtils.getListOfStructs(mainpref, key, true);
                if (newMaps == null) continue;
                for (Map map : (List)mlSetting.getValue()) {
                    if (newMaps.contains(map)) continue;
                    newMaps.add(map);
                }
                mainpref.putListOfStructs(entry.getKey(), newMaps);
            }
        }

        private static void deletePreferenceValues(Preferences fragment, Preferences mainpref) {
            for (Map.Entry<String, Preferences.Setting<?>> entry : fragment.settingsMap.entrySet()) {
                String key = entry.getKey();
                if (entry.getValue() instanceof Preferences.StringSetting) {
                    Preferences.StringSetting sSetting = (Preferences.StringSetting)entry.getValue();
                    if (!sSetting.equals(mainpref.settingsMap.get(key))) continue;
                    mainpref.put(key, null);
                    continue;
                }
                if (entry.getValue() instanceof Preferences.ListSetting) {
                    Preferences.ListSetting lSetting = (Preferences.ListSetting)entry.getValue();
                    Collection<String> newItems = PreferencesUtils.getCollection(mainpref, key, true);
                    if (newItems == null) continue;
                    for (String item : (List)lSetting.getValue()) {
                        CustomConfigurator.log("Deleting preferences: from list %s: %s\n", key, item);
                        newItems.remove(item);
                    }
                    mainpref.putCollection(entry.getKey(), newItems);
                    continue;
                }
                if (entry.getValue() instanceof Preferences.ListListSetting) {
                    Preferences.ListListSetting llSetting = (Preferences.ListListSetting)entry.getValue();
                    Collection<Collection<String>> newLists = PreferencesUtils.getArray(mainpref, key, true);
                    if (newLists == null) continue;
                    Iterator<Collection<String>> listIterator = newLists.iterator();
                    while (listIterator.hasNext()) {
                        Collection<String> list = listIterator.next();
                        for (Collection removeList : (List)llSetting.getValue()) {
                            if (!list.containsAll(removeList)) continue;
                            CustomConfigurator.log("Deleting preferences: list from lists %s: %s\n", key, list);
                            listIterator.remove();
                        }
                    }
                    mainpref.putArray(key, newLists);
                    continue;
                }
                if (!(entry.getValue() instanceof Preferences.MapListSetting)) continue;
                Preferences.MapListSetting mlSetting = (Preferences.MapListSetting)entry.getValue();
                List<Map<String, String>> newMaps = PreferencesUtils.getListOfStructs(mainpref, key, true);
                if (newMaps == null) continue;
                Iterator<Map<String, String>> mapIterator = newMaps.iterator();
                while (mapIterator.hasNext()) {
                    Map<String, String> map = mapIterator.next();
                    for (Map removeMap : (List)mlSetting.getValue()) {
                        if (!map.entrySet().containsAll(removeMap.entrySet())) continue;
                        CustomConfigurator.log("Deleting preferences: deleting map from maps %s: %s\n", key, map);
                        mapIterator.remove();
                    }
                }
                mainpref.putListOfStructs(entry.getKey(), newMaps);
            }
        }

        private static void deletePreferenceKeyByPattern(String pattern, Preferences pref2) {
            Map<String, Preferences.Setting<?>> allSettings = pref2.getAllSettings();
            for (Map.Entry<String, Preferences.Setting<?>> entry : allSettings.entrySet()) {
                String key = entry.getKey();
                if (!key.matches(pattern)) continue;
                CustomConfigurator.log("Deleting preferences: deleting key from preferences: " + key);
                pref2.putSetting(key, null);
            }
        }

        private static void deletePreferenceKey(String key, Preferences pref2) {
            Map<String, Preferences.Setting<?>> allSettings = pref2.getAllSettings();
            if (allSettings.containsKey(key)) {
                CustomConfigurator.log("Deleting preferences: deleting key from preferences: " + key);
                pref2.putSetting(key, null);
            }
        }

        private static Collection<String> getCollection(Preferences mainpref, String key, boolean warnUnknownDefault) {
            Preferences.ListSetting existing = Utils.cast(mainpref.settingsMap.get(key), Preferences.ListSetting.class);
            Preferences.ListSetting defaults = Utils.cast(mainpref.defaultsMap.get(key), Preferences.ListSetting.class);
            if (existing == null && defaults == null) {
                if (warnUnknownDefault) {
                    PreferencesUtils.defaultUnknownWarning(key);
                }
                return null;
            }
            if (existing != null) {
                return new ArrayList<String>((Collection)existing.getValue());
            }
            return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
        }

        private static Collection<Collection<String>> getArray(Preferences mainpref, String key, boolean warnUnknownDefault) {
            Preferences.ListListSetting existing = Utils.cast(mainpref.settingsMap.get(key), Preferences.ListListSetting.class);
            Preferences.ListListSetting defaults = Utils.cast(mainpref.defaultsMap.get(key), Preferences.ListListSetting.class);
            if (existing == null && defaults == null) {
                if (warnUnknownDefault) {
                    PreferencesUtils.defaultUnknownWarning(key);
                }
                return null;
            }
            if (existing != null) {
                return new ArrayList<Collection<String>>((Collection)existing.getValue());
            }
            return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
        }

        private static List<Map<String, String>> getListOfStructs(Preferences mainpref, String key, boolean warnUnknownDefault) {
            Preferences.MapListSetting existing = Utils.cast(mainpref.settingsMap.get(key), Preferences.MapListSetting.class);
            Preferences.MapListSetting defaults = Utils.cast(mainpref.settingsMap.get(key), Preferences.MapListSetting.class);
            if (existing == null && defaults == null) {
                if (warnUnknownDefault) {
                    PreferencesUtils.defaultUnknownWarning(key);
                }
                return null;
            }
            if (existing != null) {
                return new ArrayList<Map<String, String>>((Collection)existing.getValue());
            }
            return defaults.getValue() == null ? null : new ArrayList((Collection)defaults.getValue());
        }

        private static void defaultUnknownWarning(String key) {
            CustomConfigurator.log("Warning: Unknown default value of %s , skipped\n", key);
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Settings file asks to append preferences to <b>{0}</b>,<br/> but its default value is unknown at this moment.<br/> Please activate corresponding function manually and retry importing.", key), I18n.tr("Warning", new Object[0]), 2);
        }

        private static void showPrefs(Preferences tmpPref) {
            Main.info("properties: " + tmpPref.settingsMap);
        }

        private static void modifyPreferencesByScript(ScriptEngine engine, Preferences tmpPref, String js) throws ScriptException {
            PreferencesUtils.loadPrefsToJS(engine, tmpPref, "API.pref", true);
            engine.eval(js);
            PreferencesUtils.readPrefsFromJS(engine, tmpPref, "API.pref");
        }

        public static void readPrefsFromJS(ScriptEngine engine, Preferences tmpPref, String varInJS) throws ScriptException {
            String finish = "stringMap = new java.util.TreeMap ;listMap =  new java.util.TreeMap ;listlistMap = new java.util.TreeMap ;listmapMap =  new java.util.TreeMap ;for (key in " + varInJS + ") {" + "  val = " + varInJS + "[key];" + "  type = typeof val == 'string' ? 'string' : val.type;" + "  if (type == 'string') {" + "    stringMap.put(key, val);" + "  } else if (type == 'list') {" + "    l = new java.util.ArrayList;" + "    for (i=0; i<val.length; i++) {" + "      l.add(java.lang.String.valueOf(val[i]));" + "    }" + "    listMap.put(key, l);" + "  } else if (type == 'listlist') {" + "    l = new java.util.ArrayList;" + "    for (i=0; i<val.length; i++) {" + "      list=val[i];" + "      jlist=new java.util.ArrayList;" + "      for (j=0; j<list.length; j++) {" + "         jlist.add(java.lang.String.valueOf(list[j]));" + "      }" + "      l.add(jlist);" + "    }" + "    listlistMap.put(key, l);" + "  } else if (type == 'listmap') {" + "    l = new java.util.ArrayList;" + "    for (i=0; i<val.length; i++) {" + "      map=val[i];" + "      jmap=new java.util.TreeMap;" + "      for (var key2 in map) {" + "         jmap.put(key2,java.lang.String.valueOf(map[key2]));" + "      }" + "      l.add(jmap);" + "    }" + "    listmapMap.put(key, l);" + "  }  else {" + "   org.openstreetmap.josm.data.CustomConfigurator.log('Unknown type:'+val.type+ '- use list, listlist or listmap'); }" + "  }";
            engine.eval(finish);
            Map stringMap = (Map)engine.get("stringMap");
            SortedMap listMap = (SortedMap)engine.get("listMap");
            SortedMap listlistMap = (SortedMap)engine.get("listlistMap");
            SortedMap listmapMap = (SortedMap)engine.get("listmapMap");
            tmpPref.settingsMap.clear();
            HashMap tmp = new HashMap();
            for (Map.Entry e : stringMap.entrySet()) {
                tmp.put(e.getKey(), new Preferences.StringSetting((String)e.getValue()));
            }
            for (Map.Entry e : listMap.entrySet()) {
                tmp.put(e.getKey(), new Preferences.ListSetting((List)e.getValue()));
            }
            for (Map.Entry e : listlistMap.entrySet()) {
                List value = (List)e.getValue();
                tmp.put(e.getKey(), new Preferences.ListListSetting(value));
            }
            for (Map.Entry e : listmapMap.entrySet()) {
                tmp.put(e.getKey(), new Preferences.MapListSetting((List)e.getValue()));
            }
            for (Map.Entry e : tmp.entrySet()) {
                if (((Preferences.Setting)e.getValue()).equals(tmpPref.defaultsMap.get(e.getKey()))) continue;
                tmpPref.settingsMap.put((String)e.getKey(), (Preferences.Setting<?>)e.getValue());
            }
        }

        public static void loadPrefsToJS(ScriptEngine engine, Preferences tmpPref, String whereToPutInJS, boolean includeDefaults) throws ScriptException {
            TreeMap stringMap = new TreeMap();
            TreeMap listMap = new TreeMap();
            TreeMap listlistMap = new TreeMap();
            TreeMap listmapMap = new TreeMap();
            if (includeDefaults) {
                for (Map.Entry<String, Preferences.Setting<?>> e : tmpPref.defaultsMap.entrySet()) {
                    Preferences.Setting<?> setting = e.getValue();
                    if (setting instanceof Preferences.StringSetting) {
                        stringMap.put(e.getKey(), ((Preferences.StringSetting)setting).getValue());
                        continue;
                    }
                    if (setting instanceof Preferences.ListSetting) {
                        listMap.put(e.getKey(), ((Preferences.ListSetting)setting).getValue());
                        continue;
                    }
                    if (setting instanceof Preferences.ListListSetting) {
                        listlistMap.put(e.getKey(), ((Preferences.ListListSetting)setting).getValue());
                        continue;
                    }
                    if (!(setting instanceof Preferences.MapListSetting)) continue;
                    listmapMap.put(e.getKey(), ((Preferences.MapListSetting)setting).getValue());
                }
            }
            Iterator<Map.Entry<String, Preferences.Setting<?>>> it = tmpPref.settingsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Preferences.Setting<?>> e;
                e = it.next();
                if (e.getValue().getValue() != null) continue;
                it.remove();
            }
            for (Map.Entry<String, Preferences.Setting<?>> e : tmpPref.settingsMap.entrySet()) {
                Preferences.Setting<?> setting = e.getValue();
                if (setting instanceof Preferences.StringSetting) {
                    stringMap.put(e.getKey(), ((Preferences.StringSetting)setting).getValue());
                    continue;
                }
                if (setting instanceof Preferences.ListSetting) {
                    listMap.put(e.getKey(), ((Preferences.ListSetting)setting).getValue());
                    continue;
                }
                if (setting instanceof Preferences.ListListSetting) {
                    listlistMap.put(e.getKey(), ((Preferences.ListListSetting)setting).getValue());
                    continue;
                }
                if (!(setting instanceof Preferences.MapListSetting)) continue;
                listmapMap.put(e.getKey(), ((Preferences.MapListSetting)setting).getValue());
            }
            engine.put("stringMap", stringMap);
            engine.put("listMap", listMap);
            engine.put("listlistMap", listlistMap);
            engine.put("listmapMap", listmapMap);
            String init = "function getJSList( javaList ) { var jsList; var i;  if (javaList == null) return null;jsList = [];  for (i = 0; i < javaList.size(); i++) {    jsList.push(String(list.get(i)));  }return jsList;}function getJSMap( javaMap ) { var jsMap; var it; var e;  if (javaMap == null) return null; jsMap = {}; for (it = javaMap.entrySet().iterator(); it.hasNext();) {    e = it.next();    jsMap[ String(e.getKey()) ] = String(e.getValue());   }  return jsMap;}for (it = stringMap.entrySet().iterator(); it.hasNext();) {  e = it.next();" + whereToPutInJS + "[String(e.getKey())] = String(e.getValue());" + "}\n" + "for (it = listMap.entrySet().iterator(); it.hasNext();) {" + "  e = it.next();" + "  list = e.getValue();" + "  jslist = getJSList(list);" + "  jslist.type = 'list';" + whereToPutInJS + "[String(e.getKey())] = jslist;" + "}\n" + "for (it = listlistMap.entrySet().iterator(); it.hasNext(); ) {" + "  e = it.next();" + "  listlist = e.getValue();" + "  jslistlist = [];" + "  for (it2 = listlist.iterator(); it2.hasNext(); ) {" + "    list = it2.next(); " + "    jslistlist.push(getJSList(list));" + "    }" + "  jslistlist.type = 'listlist';" + whereToPutInJS + "[String(e.getKey())] = jslistlist;" + "}\n" + "for (it = listmapMap.entrySet().iterator(); it.hasNext();) {" + "  e = it.next();" + "  listmap = e.getValue();" + "  jslistmap = [];" + "  for (it2 = listmap.iterator(); it2.hasNext();) {" + "    map = it2.next();" + "    jslistmap.push(getJSMap(map));" + "    }" + "  jslistmap.type = 'listmap';" + whereToPutInJS + "[String(e.getKey())] = jslistmap;" + "}\n";
            engine.eval(init);
        }
    }

    public static class XMLCommandProcessor {
        Preferences mainPrefs;
        Map<String, Element> tasksMap = new HashMap<String, Element>();
        private boolean lastV;
        ScriptEngine engine;

        public void openAndReadXML(File file) {
            CustomConfigurator.log("-- Reading custom preferences from " + file.getAbsolutePath() + " --");
            try {
                String fileDir = file.getParentFile().getAbsolutePath();
                if (fileDir != null) {
                    this.engine.eval("scriptDir='" + this.normalizeDirName(fileDir) + "';");
                }
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                    this.openAndReadXML(is);
                }
            }
            catch (Exception ex) {
                CustomConfigurator.log("Error reading custom preferences: " + ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void openAndReadXML(InputStream is) {
            try {
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setValidating(false);
                builderFactory.setNamespaceAware(true);
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document document = builder.parse(is);
                Class<CustomConfigurator> clazz = CustomConfigurator.class;
                synchronized (CustomConfigurator.class) {
                    this.processXML(document);
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                }
            }
            catch (Exception ex) {
                CustomConfigurator.log("Error reading custom preferences: " + ex.getMessage());
            }
            {
                CustomConfigurator.log("-- Reading complete --");
                return;
            }
        }

        public XMLCommandProcessor(Preferences mainPrefs) {
            try {
                this.mainPrefs = mainPrefs;
                summary = new StringBuilder();
                this.engine = new ScriptEngineManager().getEngineByName("rhino");
                this.engine.eval("API={}; API.pref={}; API.fragments={};");
                this.engine.eval("homeDir='" + this.normalizeDirName(Main.pref.getPreferencesDirectory().getAbsolutePath()) + "';");
                this.engine.eval("josmVersion=" + Version.getInstance().getVersion() + ";");
                String className = CustomConfigurator.class.getName();
                this.engine.eval("API.messageBox=" + className + ".messageBox");
                this.engine.eval("API.askText=function(text) { return String(" + className + ".askForText(text));}");
                this.engine.eval("API.askOption=" + className + ".askForOption");
                this.engine.eval("API.downloadFile=" + className + ".downloadFile");
                this.engine.eval("API.downloadAndUnpackFile=" + className + ".downloadAndUnpackFile");
                this.engine.eval("API.deleteFile=" + className + ".deleteFile");
                this.engine.eval("API.plugin =" + className + ".pluginOperation");
                this.engine.eval("API.pluginInstall = function(names) { " + className + ".pluginOperation(names,'','');}");
                this.engine.eval("API.pluginUninstall = function(names) { " + className + ".pluginOperation('',names,'');}");
                this.engine.eval("API.pluginDelete = function(names) { " + className + ".pluginOperation('','',names);}");
            }
            catch (Exception ex) {
                CustomConfigurator.log("Error: initializing script engine: " + ex.getMessage());
            }
        }

        private void processXML(Document document) {
            Element root = document.getDocumentElement();
            this.processXmlFragment(root);
        }

        private void processXmlFragment(Element root) {
            NodeList childNodes = root.getChildNodes();
            int nops = childNodes.getLength();
            block30: for (int i = 0; i < nops; ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                String elementName = item.getNodeName();
                Element elem = (Element)item;
                switch (elementName) {
                    case "var": {
                        this.setVar(elem.getAttribute("name"), this.evalVars(elem.getAttribute("value")));
                        continue block30;
                    }
                    case "task": {
                        this.tasksMap.put(elem.getAttribute("name"), elem);
                        continue block30;
                    }
                    case "runtask": {
                        if (!this.processRunTaskElement(elem)) continue block30;
                        return;
                    }
                    case "ask": {
                        this.processAskElement(elem);
                        continue block30;
                    }
                    case "if": {
                        this.processIfElement(elem);
                        continue block30;
                    }
                    case "else": {
                        this.processElseElement(elem);
                        continue block30;
                    }
                    case "break": {
                        return;
                    }
                    case "plugin": {
                        this.processPluginInstallElement(elem);
                        continue block30;
                    }
                    case "messagebox": {
                        this.processMsgBoxElement(elem);
                        continue block30;
                    }
                    case "preferences": {
                        this.processPreferencesElement(elem);
                        continue block30;
                    }
                    case "download": {
                        this.processDownloadElement(elem);
                        continue block30;
                    }
                    case "delete": {
                        this.processDeleteElement(elem);
                        continue block30;
                    }
                    case "script": {
                        this.processScriptElement(elem);
                        continue block30;
                    }
                    default: {
                        CustomConfigurator.log("Error: Unknown element " + elementName);
                    }
                }
            }
        }

        private void processPreferencesElement(Element item) {
            String oper = this.evalVars(item.getAttribute("operation"));
            String id = this.evalVars(item.getAttribute("id"));
            if ("delete-keys".equals(oper)) {
                String pattern = this.evalVars(item.getAttribute("pattern"));
                String key = this.evalVars(item.getAttribute("key"));
                if (key != null) {
                    PreferencesUtils.deletePreferenceKey(key, this.mainPrefs);
                }
                if (pattern != null) {
                    PreferencesUtils.deletePreferenceKeyByPattern(pattern, this.mainPrefs);
                }
                return;
            }
            Preferences tmpPref = this.readPreferencesFromDOMElement(item);
            PreferencesUtils.showPrefs(tmpPref);
            if (id.length() > 0) {
                try {
                    String fragmentVar = "API.fragments['" + id + "']";
                    this.engine.eval(fragmentVar + "={};");
                    PreferencesUtils.loadPrefsToJS(this.engine, tmpPref, fragmentVar, false);
                }
                catch (ScriptException ex) {
                    CustomConfigurator.log("Error: can not load preferences fragment : " + ex.getMessage());
                }
            }
            if ("replace".equals(oper)) {
                CustomConfigurator.log("Preferences replace: %d keys: %s\n", tmpPref.getAllSettings().size(), tmpPref.getAllSettings().keySet().toString());
                PreferencesUtils.replacePreferences(tmpPref, this.mainPrefs);
            } else if ("append".equals(oper)) {
                CustomConfigurator.log("Preferences append: %d keys: %s\n", tmpPref.getAllSettings().size(), tmpPref.getAllSettings().keySet().toString());
                PreferencesUtils.appendPreferences(tmpPref, this.mainPrefs);
            } else if ("delete-values".equals(oper)) {
                PreferencesUtils.deletePreferenceValues(tmpPref, this.mainPrefs);
            }
        }

        private void processDeleteElement(Element item) {
            String path = this.evalVars(item.getAttribute("path"));
            String base = this.evalVars(item.getAttribute("base"));
            CustomConfigurator.deleteFile(base, path);
        }

        private void processDownloadElement(Element item) {
            String address = this.evalVars(item.getAttribute("url"));
            String path = this.evalVars(item.getAttribute("path"));
            String unzip = this.evalVars(item.getAttribute("unzip"));
            String mkdir = this.evalVars(item.getAttribute("mkdir"));
            String base = this.evalVars(item.getAttribute("base"));
            String dir = CustomConfigurator.getDirectoryByAbbr(base);
            if (dir == null) {
                CustomConfigurator.log("Error: Can not find directory to place file, use base=cache, base=prefs or base=plugins attribute.");
                return;
            }
            if (path.contains("..") || path.startsWith("/") || path.contains(":")) {
                return;
            }
            if (address == null || path == null || address.length() == 0 || path.length() == 0) {
                CustomConfigurator.log("Error: Please specify url=\"where to get file\" and path=\"where to place it\"");
                return;
            }
            CustomConfigurator.processDownloadOperation(address, path, dir, "true".equals(mkdir), "true".equals(unzip));
        }

        private void processPluginInstallElement(Element elem) {
            String install = elem.getAttribute("install");
            String uninstall = elem.getAttribute("remove");
            String delete = elem.getAttribute("delete");
            CustomConfigurator.pluginOperation(install, uninstall, delete);
        }

        private void processMsgBoxElement(Element elem) {
            String text = this.evalVars(elem.getAttribute("text"));
            String locText = this.evalVars(elem.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".text"));
            if (locText != null && locText.length() > 0) {
                text = locText;
            }
            String type = this.evalVars(elem.getAttribute("type"));
            CustomConfigurator.messageBox(type, text);
        }

        private void processAskElement(Element elem) {
            String input;
            String var;
            String text = this.evalVars(elem.getAttribute("text"));
            String locText = this.evalVars(elem.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".text"));
            if (locText.length() > 0) {
                text = locText;
            }
            if ((var = elem.getAttribute("var")).isEmpty()) {
                var = "result";
            }
            if ("true".equals(input = this.evalVars(elem.getAttribute("input")))) {
                this.setVar(var, CustomConfigurator.askForText(text));
            } else {
                String opts = this.evalVars(elem.getAttribute("options"));
                String locOpts = this.evalVars(elem.getAttribute(LanguageInfo.getJOSMLocaleCode() + ".options"));
                if (locOpts.length() > 0) {
                    opts = locOpts;
                }
                this.setVar(var, String.valueOf(CustomConfigurator.askForOption(text, opts)));
            }
        }

        public void setVar(String name, String value) {
            try {
                this.engine.eval(name + "='" + value + "';");
            }
            catch (ScriptException ex) {
                CustomConfigurator.log("Error: Can not assign variable: %s=%s  : %s\n", name, value, ex.getMessage());
            }
        }

        private void processIfElement(Element elem) {
            String realValue = this.evalVars(elem.getAttribute("test"));
            boolean v = false;
            if ("true".equals(realValue)) {
                v = true;
            } else if ("fales".equals(realValue)) {
                v = true;
            } else {
                CustomConfigurator.log("Error: Illegal test expression in if: %s=%s\n", elem.getAttribute("test"), realValue);
            }
            if (v) {
                this.processXmlFragment(elem);
            }
            this.lastV = v;
        }

        private void processElseElement(Element elem) {
            if (!this.lastV) {
                this.processXmlFragment(elem);
            }
        }

        private boolean processRunTaskElement(Element elem) {
            String taskName = elem.getAttribute("name");
            Element task = this.tasksMap.get(taskName);
            if (task == null) {
                CustomConfigurator.log("Error: Can not execute task " + taskName);
                return true;
            }
            CustomConfigurator.log("EXECUTING TASK " + taskName);
            this.processXmlFragment(task);
            return false;
        }

        private void processScriptElement(Element elem) {
            String js = elem.getChildNodes().item(0).getTextContent();
            CustomConfigurator.log("Processing script...");
            try {
                PreferencesUtils.modifyPreferencesByScript(this.engine, this.mainPrefs, js);
            }
            catch (ScriptException ex) {
                CustomConfigurator.messageBox("e", ex.getMessage());
                CustomConfigurator.log("JS error: " + ex.getMessage());
            }
            CustomConfigurator.log("Script finished");
        }

        private String evalVars(String s) {
            Pattern p = Pattern.compile("\\$\\{([^\\}]*)\\}");
            Matcher mr = p.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (mr.find()) {
                try {
                    String result = this.engine.eval(mr.group(1)).toString();
                    mr.appendReplacement(sb, result);
                }
                catch (ScriptException ex) {
                    CustomConfigurator.log("Error: Can not evaluate expression %s : %s", mr.group(1), ex.getMessage());
                }
            }
            mr.appendTail(sb);
            return sb.toString();
        }

        private Preferences readPreferencesFromDOMElement(Element item) {
            Preferences tmpPref = new Preferences();
            try {
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                CharArrayWriter outputWriter = new CharArrayWriter(8192);
                StreamResult out = new StreamResult(outputWriter);
                xformer.transform(new DOMSource(item), out);
                String fragmentWithReplacedVars = this.evalVars(outputWriter.toString());
                CharArrayReader reader = new CharArrayReader(fragmentWithReplacedVars.toCharArray());
                tmpPref.fromXML(reader);
            }
            catch (Exception ex) {
                CustomConfigurator.log("Error: can not read XML fragment :" + ex.getMessage());
            }
            return tmpPref;
        }

        private String normalizeDirName(String dir) {
            String s = dir.replace("\\", "/");
            if (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }
    }
}

