/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.io.OsmImporter;
import org.openstreetmap.josm.tools.I18n;

public class AutosaveTask
extends TimerTask
implements DataSetListenerAdapter.Listener,
MapView.LayerChangeListener {
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
    public static final BooleanProperty PROP_AUTOSAVE_ENABLED = new BooleanProperty("autosave.enabled", true);
    public static final IntegerProperty PROP_FILES_PER_LAYER = new IntegerProperty("autosave.filesPerLayer", 1);
    public static final IntegerProperty PROP_DELETED_LAYERS = new IntegerProperty("autosave.deletedLayersBackupCount", 5);
    public static final IntegerProperty PROP_INTERVAL = new IntegerProperty("autosave.interval", 300);
    public static final IntegerProperty PROP_INDEX_LIMIT = new IntegerProperty("autosave.index-limit", 1000);
    public static final BooleanProperty PROP_NOTIFICATION = new BooleanProperty("autosave.notification", false);
    private final DataSetListenerAdapter datasetAdapter = new DataSetListenerAdapter(this);
    private final Set<DataSet> changedDatasets = new HashSet<DataSet>();
    private final List<AutosaveLayerInfo> layersInfo = new ArrayList<AutosaveLayerInfo>();
    private Timer timer;
    private final Object layersLock = new Object();
    private final Deque<File> deletedLayers = new LinkedList<File>();
    private final File autosaveDir = new File(Main.pref.getUserDataDirectory(), "autosave");
    private final File deletedLayersDir = new File(Main.pref.getUserDataDirectory(), "autosave/deleted_layers");

    public void schedule() {
        if (PROP_INTERVAL.get() > 0) {
            if (!this.autosaveDir.exists() && !this.autosaveDir.mkdirs()) {
                Main.warn(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.autosaveDir.getAbsolutePath()));
                return;
            }
            if (!this.deletedLayersDir.exists() && !this.deletedLayersDir.mkdirs()) {
                Main.warn(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.deletedLayersDir.getAbsolutePath()));
                return;
            }
            for (File f : this.deletedLayersDir.listFiles()) {
                this.deletedLayers.add(f);
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, 1000L, (long)PROP_INTERVAL.get().intValue() * 1000L);
            MapView.addLayerChangeListener(this);
            if (Main.isDisplayingMapView()) {
                for (OsmDataLayer l : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
                    this.registerNewlayer(l);
                }
            }
        }
    }

    private String getFileName(String layerName, int index) {
        String result = layerName;
        for (char illegalCharacter : ILLEGAL_CHARACTERS) {
            result = result.replaceAll(Pattern.quote(String.valueOf(illegalCharacter)), '&' + String.valueOf((int)illegalCharacter) + ';');
        }
        if (index != 0) {
            result = result + '_' + index;
        }
        return result;
    }

    private void setLayerFileName(AutosaveLayerInfo layer) {
        int index = 0;
        while (true) {
            String filename = this.getFileName(layer.layer.getName(), index);
            boolean foundTheSame = false;
            for (AutosaveLayerInfo info : this.layersInfo) {
                if (info == layer || !filename.equals(info.layerFileName)) continue;
                foundTheSame = true;
                break;
            }
            if (!foundTheSame) {
                layer.layerFileName = filename;
                return;
            }
            ++index;
        }
    }

    private File getNewLayerFile(AutosaveLayerInfo layer) {
        int index = 0;
        Date now = new Date();
        while (true) {
            String filename = String.format("%1$s_%2$tY%2$tm%2$td_%2$tH%2$tM%2$tS%2$tL%3$s", layer.layerFileName, now, index == 0 ? "" : "_" + index);
            File result = new File(this.autosaveDir, filename + ".osm");
            try {
                if (result.createNewFile()) {
                    File pidFile = new File(this.autosaveDir, filename + ".pid");
                    try (PrintStream ps = new PrintStream(pidFile, "UTF-8");){
                        ps.println(ManagementFactory.getRuntimeMXBean().getName());
                    }
                    catch (Exception t) {
                        Main.error(t);
                    }
                    return result;
                }
                Main.warn(I18n.tr("Unable to create file {0}, other filename will be used", result.getAbsolutePath()));
                if (index > PROP_INDEX_LIMIT.get()) {
                    throw new IOException("index limit exceeded");
                }
            }
            catch (IOException e) {
                Main.error(I18n.tr("IOError while creating file, autosave will be skipped: {0}", e.getMessage()));
                return null;
            }
            ++index;
        }
    }

    private void savelayer(AutosaveLayerInfo info) {
        File file;
        if (!info.layer.getName().equals(info.layerName)) {
            this.setLayerFileName(info);
            info.layerName = info.layer.getName();
        }
        if (this.changedDatasets.remove(info.layer.data) && (file = this.getNewLayerFile(info)) != null) {
            info.backupFiles.add(file);
            new OsmExporter().exportData(file, info.layer, true);
        }
        while (info.backupFiles.size() > PROP_FILES_PER_LAYER.get()) {
            File oldFile = info.backupFiles.remove();
            if (!oldFile.delete()) {
                Main.warn(I18n.tr("Unable to delete old backup file {0}", oldFile.getAbsolutePath()));
                continue;
            }
            this.getPidFile(oldFile).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.layersLock;
        synchronized (object) {
            try {
                for (AutosaveLayerInfo info : this.layersInfo) {
                    this.savelayer(info);
                }
                this.changedDatasets.clear();
                if (PROP_NOTIFICATION.get().booleanValue() && !this.layersInfo.isEmpty()) {
                    this.displayNotification();
                }
            }
            catch (Exception t) {
                Main.error("Autosave failed:");
                Main.error(t);
            }
        }
    }

    protected void displayNotification() {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                new Notification(I18n.tr("Your work has been saved automatically.", new Object[0])).setDuration(Notification.TIME_SHORT).show();
            }
        });
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewlayer(OsmDataLayer layer) {
        Object object = this.layersLock;
        synchronized (object) {
            layer.data.addDataSetListener(this.datasetAdapter);
            AutosaveLayerInfo info = new AutosaveLayerInfo();
            info.layer = layer;
            this.layersInfo.add(info);
        }
    }

    @Override
    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            this.registerNewlayer((OsmDataLayer)newLayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof OsmDataLayer) {
            Object object = this.layersLock;
            synchronized (object) {
                OsmDataLayer osmLayer = (OsmDataLayer)oldLayer;
                osmLayer.data.removeDataSetListener(this.datasetAdapter);
                Iterator<AutosaveLayerInfo> it = this.layersInfo.iterator();
                while (it.hasNext()) {
                    AutosaveLayerInfo info = it.next();
                    if (info.layer != osmLayer) continue;
                    this.savelayer(info);
                    File lastFile = info.backupFiles.pollLast();
                    if (lastFile != null) {
                        this.moveToDeletedLayersFolder(lastFile);
                    }
                    for (File file : info.backupFiles) {
                        if (!file.delete()) continue;
                        this.getPidFile(file).delete();
                    }
                    it.remove();
                }
            }
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.changedDatasets.add(event.getDataset());
    }

    private final File getPidFile(File osmFile) {
        return new File(this.autosaveDir, osmFile.getName().replaceFirst("[.][^.]+$", ".pid"));
    }

    public List<File> getUnsavedLayersFiles() {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = this.autosaveDir.listFiles(OsmImporter.FILE_FILTER);
        if (files == null) {
            return result;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            boolean skipFile = false;
            File pidFile = this.getPidFile(file);
            if (pidFile.exists()) {
                try (BufferedReader reader = Files.newBufferedReader(pidFile.toPath(), StandardCharsets.UTF_8);){
                    String jvmId = reader.readLine();
                    if (jvmId != null) {
                        String pid = jvmId.split("@")[0];
                        skipFile = this.jvmPerfDataFileExists(pid);
                    }
                }
                catch (Exception t) {
                    Main.error(t);
                }
            }
            if (skipFile) continue;
            result.add(file);
        }
        return result;
    }

    private boolean jvmPerfDataFileExists(final String jvmId) {
        File jvmDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "hsperfdata_" + System.getProperty("user.name"));
        if (jvmDir.exists() && jvmDir.canRead()) {
            File[] files = jvmDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().equals(jvmId) && file.isFile();
                }
            });
            return files != null && files.length == 1;
        }
        return false;
    }

    public void recoverUnsavedLayers() {
        List<File> files = this.getUnsavedLayersFiles();
        final OpenFileAction.OpenFileTask openFileTsk = new OpenFileAction.OpenFileTask(files, null, I18n.tr("Restoring files", new Object[0]));
        Main.worker.submit(openFileTsk);
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                for (File f : openFileTsk.getSuccessfullyOpenedFiles()) {
                    AutosaveTask.this.moveToDeletedLayersFolder(f);
                }
            }
        });
    }

    private void moveToDeletedLayersFolder(File f) {
        File next;
        File backupFile = new File(this.deletedLayersDir, f.getName());
        File pidFile = this.getPidFile(f);
        if (backupFile.exists()) {
            this.deletedLayers.remove(backupFile);
            if (!backupFile.delete()) {
                Main.warn(String.format("Could not delete old backup file %s", backupFile));
            }
        }
        if (f.renameTo(backupFile)) {
            this.deletedLayers.add(backupFile);
            pidFile.delete();
        } else {
            Main.warn(String.format("Could not move autosaved file %s to %s folder", f.getName(), this.deletedLayersDir.getName()));
            if (!f.delete()) {
                Main.warn(String.format("Could not delete backup file %s", f));
            } else if (!pidFile.delete()) {
                Main.warn(String.format("Could not delete PID file %s", pidFile));
            }
        }
        while (this.deletedLayers.size() > PROP_DELETED_LAYERS.get() && (next = this.deletedLayers.remove()) != null) {
            if (next.delete()) continue;
            Main.warn(String.format("Could not delete archived backup file %s", next));
        }
    }

    public void discardUnsavedLayers() {
        for (File f : this.getUnsavedLayersFiles()) {
            this.moveToDeletedLayersFolder(f);
        }
    }

    private static class AutosaveLayerInfo {
        OsmDataLayer layer;
        String layerName;
        String layerFileName;
        final Deque<File> backupFiles = new LinkedList<File>();

        private AutosaveLayerInfo() {
        }
    }
}

