/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeRelationMemberRoleCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.CorrectionTable;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.RoleCorrectionTable;
import org.openstreetmap.josm.corrector.RoleCorrectionTableModel;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrectionTable;
import org.openstreetmap.josm.corrector.TagCorrectionTableModel;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class TagCorrector<P extends OsmPrimitive> {
    private String[] applicationOptions = new String[]{I18n.tr("Apply selected changes", new Object[0]), I18n.tr("Do not apply changes", new Object[0]), I18n.tr("Cancel", new Object[0])};

    public abstract Collection<Command> execute(P var1, P var2) throws UserCancelException;

    protected Collection<Command> applyCorrections(Map<OsmPrimitive, List<TagCorrection>> tagCorrectionsMap, Map<OsmPrimitive, List<RoleCorrection>> roleCorrectionMap, String description) throws UserCancelException {
        if (!tagCorrectionsMap.isEmpty() || !roleCorrectionMap.isEmpty()) {
            JScrollPane scrollPane;
            CorrectionTable table;
            JLabel primitiveLabel;
            List<TagCorrection> tagCorrections;
            ArrayList<Command> commands = new ArrayList<Command>();
            HashMap<OsmPrimitive, TagCorrectionTable> tagTableMap = new HashMap<OsmPrimitive, TagCorrectionTable>();
            HashMap<OsmPrimitive, TagCorrectionTable> roleTableMap = new HashMap<OsmPrimitive, TagCorrectionTable>();
            JPanel p = new JPanel(new GridBagLayout());
            JMultilineLabel label1 = new JMultilineLabel(description);
            label1.setMaxWidth(600);
            p.add((Component)label1, GBC.eop().anchor(10).fill(2));
            JMultilineLabel label2 = new JMultilineLabel(I18n.tr("Please select which changes you want to apply.", new Object[0]));
            label2.setMaxWidth(600);
            p.add((Component)label2, GBC.eop().anchor(10).fill(2));
            for (Map.Entry<OsmPrimitive, List<TagCorrection>> entry : tagCorrectionsMap.entrySet()) {
                OsmPrimitive osmPrimitive = entry.getKey();
                tagCorrections = entry.getValue();
                if (tagCorrections.isEmpty()) continue;
                JLabel propertiesLabel = new JLabel(I18n.tr("Tags of ", new Object[0]));
                p.add((Component)propertiesLabel, GBC.std());
                primitiveLabel = new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()) + ":", ImageProvider.get(osmPrimitive.getDisplayType()), 2);
                p.add((Component)primitiveLabel, GBC.eol());
                table = new TagCorrectionTable(tagCorrections);
                scrollPane = new JScrollPane(table);
                p.add((Component)scrollPane, GBC.eop().fill(2));
                tagTableMap.put(osmPrimitive, (TagCorrectionTable)table);
            }
            for (Map.Entry<OsmPrimitive, List<Object>> entry : roleCorrectionMap.entrySet()) {
                OsmPrimitive osmPrimitive = entry.getKey();
                List<Object> roleCorrections = entry.getValue();
                if (roleCorrections.isEmpty()) continue;
                JLabel rolesLabel = new JLabel(I18n.tr("Roles in relations referring to", new Object[0]));
                p.add((Component)rolesLabel, GBC.std());
                primitiveLabel = new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(osmPrimitive.getDisplayType()), 2);
                p.add((Component)primitiveLabel, GBC.eol());
                table = new RoleCorrectionTable(roleCorrections);
                scrollPane = new JScrollPane(table);
                p.add((Component)scrollPane, GBC.eop().fill(2));
                roleTableMap.put(osmPrimitive, (TagCorrectionTable)table);
            }
            int answer = JOptionPane.showOptionDialog(Main.parent, p, I18n.tr("Automatic tag correction", new Object[0]), 1, -1, null, this.applicationOptions, this.applicationOptions[0]);
            if (answer == 0) {
                for (Map.Entry<OsmPrimitive, List<TagCorrection>> entry : tagCorrectionsMap.entrySet()) {
                    tagCorrections = entry.getValue();
                    OsmPrimitive primitive2 = entry.getKey();
                    OsmPrimitive clone = null;
                    if (primitive2 instanceof Way) {
                        clone = new Way((Way)primitive2);
                    } else if (primitive2 instanceof Node) {
                        clone = new Node((Node)primitive2);
                    } else if (primitive2 instanceof Relation) {
                        clone = new Relation((Relation)primitive2);
                    } else {
                        throw new AssertionError();
                    }
                    HashSet<String> keysChanged = new HashSet<String>();
                    for (int i = 0; i < tagCorrections.size(); ++i) {
                        if (!((TagCorrectionTableModel)((TagCorrectionTable)tagTableMap.get(primitive2)).getCorrectionTableModel()).getApply(i)) continue;
                        TagCorrection tagCorrection = tagCorrections.get(i);
                        if (tagCorrection.isKeyChanged() && !keysChanged.contains(tagCorrection.oldKey)) {
                            clone.remove(tagCorrection.oldKey);
                        }
                        clone.put(tagCorrection.newKey, tagCorrection.newValue);
                        keysChanged.add(tagCorrection.newKey);
                    }
                    if (keysChanged.isEmpty()) continue;
                    commands.add(new ChangeCommand(primitive2, clone));
                }
                for (Map.Entry<OsmPrimitive, List<RoleCorrection>> entry : roleCorrectionMap.entrySet()) {
                    OsmPrimitive primitive3 = entry.getKey();
                    List<RoleCorrection> roleCorrections = entry.getValue();
                    for (int i = 0; i < roleCorrections.size(); ++i) {
                        RoleCorrection roleCorrection = roleCorrections.get(i);
                        if (!((RoleCorrectionTableModel)((RoleCorrectionTable)roleTableMap.get(primitive3)).getCorrectionTableModel()).getApply(i)) continue;
                        commands.add(new ChangeRelationMemberRoleCommand(roleCorrection.relation, roleCorrection.position, roleCorrection.newRole));
                    }
                }
            } else if (answer != 1) {
                throw new UserCancelException();
            }
            return commands;
        }
        return Collections.emptyList();
    }
}

