/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static final Collection<Pattern> ignoredKeys = new ArrayList<Pattern>();
    private static final StringSwitcher FORWARD_BACKWARD;
    private static final StringSwitcher UP_DOWN;
    private static final StringSwitcher[] stringSwitchers;

    private static final Pattern getPatternFor(String s) {
        return ReverseWayTagCorrector.getPatternFor(s, false);
    }

    private static final Pattern getPatternFor(String s, boolean exactMatch) {
        if (exactMatch) {
            return Pattern.compile("(^)(" + s + ")($)");
        }
        return Pattern.compile("(^|.*[:_])(" + s + ")(" + "[:_]" + ".*|$)", 2);
    }

    public static boolean isReversible(Way way) {
        for (Tag tag : TagCollection.from(way)) {
            if (tag.equals(TagSwitcher.apply(tag))) continue;
            return false;
        }
        return true;
    }

    public static List<Way> irreversibleWays(List<Way> ways) {
        ArrayList<Way> newWays = new ArrayList<Way>(ways);
        for (Way way : ways) {
            if (!ReverseWayTagCorrector.isReversible(way)) continue;
            newWays.remove(way);
        }
        return newWays;
    }

    public static String invertNumber(String value) {
        Pattern pattern = Pattern.compile("^([+-]?)(\\d.*)$", 2);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            return value;
        }
        String sign = matcher.group(1);
        String rest = matcher.group(2);
        sign = "-".equals(sign) ? "" : "-";
        return sign + rest;
    }

    @Override
    public Collection<Command> execute(Way oldway, Way way) throws UserCancelException {
        HashMap<OsmPrimitive, List<TagCorrection>> tagCorrectionsMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        ArrayList<TagCorrection> tagCorrections = new ArrayList<TagCorrection>();
        for (String key : way.keySet()) {
            boolean needsCorrection;
            String value = way.get(key);
            Tag newTag = TagSwitcher.apply(key, value);
            String newKey = newTag.getKey();
            String newValue = newTag.getValue();
            boolean bl = needsCorrection = !key.equals(newKey);
            if (way.get(newKey) != null && way.get(newKey).equals(newValue)) {
                needsCorrection = false;
            }
            if (!value.equals(newValue)) {
                needsCorrection = true;
            }
            if (!needsCorrection) continue;
            tagCorrections.add(new TagCorrection(key, value, newKey, newValue));
        }
        if (!tagCorrections.isEmpty()) {
            tagCorrectionsMap.put(way, tagCorrections);
        }
        HashMap<OsmPrimitive, List<RoleCorrection>> roleCorrectionMap = new HashMap<OsmPrimitive, List<RoleCorrection>>();
        ArrayList<RoleCorrection> roleCorrections = new ArrayList<RoleCorrection>();
        List<OsmPrimitive> referrers = oldway.getReferrers();
        for (OsmPrimitive referrer : referrers) {
            if (!(referrer instanceof Relation)) continue;
            Relation relation = (Relation)referrer;
            int position = 0;
            for (RelationMember member : relation.getMembers()) {
                if (!member.getMember().hasEqualSemanticAttributes(oldway) || !member.hasRole()) {
                    ++position;
                    continue;
                }
                boolean found = false;
                String newRole = null;
                for (StringSwitcher prefixSuffixSwitcher : stringSwitchers) {
                    newRole = prefixSuffixSwitcher.apply(member.getRole());
                    if (newRole.equals(member.getRole())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    roleCorrections.add(new RoleCorrection(relation, position, member, newRole));
                }
                ++position;
            }
        }
        if (!roleCorrections.isEmpty()) {
            roleCorrectionMap.put(way, roleCorrections);
        }
        return this.applyCorrections(tagCorrectionsMap, roleCorrectionMap, I18n.tr("When reversing this way, the following changes are suggested in order to maintain data consistency.", new Object[0]));
    }

    private static boolean ignoreKeyForCorrection(String key) {
        for (Pattern ignoredKey : ignoredKeys) {
            if (!ignoredKey.matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        for (String s : OsmPrimitive.getUninterestingKeys()) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(s));
        }
        for (String s : new String[]{"name", "ref", "tiger:county"}) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(s, false));
        }
        for (String s : new String[]{"tiger:county", "turn:lanes", "change:lanes", "placement"}) {
            ignoredKeys.add(ReverseWayTagCorrector.getPatternFor(s, true));
        }
        FORWARD_BACKWARD = new StringSwitcher("forward", "backward");
        UP_DOWN = new StringSwitcher("up", "down");
        stringSwitchers = new StringSwitcher[]{new StringSwitcher("left", "right"), new StringSwitcher("forwards", "backwards"), new StringSwitcher("east", "west"), new StringSwitcher("north", "south"), FORWARD_BACKWARD, UP_DOWN};
    }

    public static final class TagSwitcher {
        public static final Tag apply(Tag tag) {
            return TagSwitcher.apply(tag.getKey(), tag.getValue());
        }

        public static final Tag apply(String key, String value) {
            String newValue;
            String newKey;
            block9: {
                block7: {
                    block8: {
                        newKey = key;
                        newValue = value;
                        if (!key.startsWith("oneway") && !key.endsWith("oneway")) break block7;
                        if (!OsmUtils.isReversed(value)) break block8;
                        newValue = "yes";
                        break block9;
                    }
                    if (!OsmUtils.isTrue(value)) break block9;
                    newValue = "-1";
                    break block9;
                }
                if (key.startsWith("incline") || key.endsWith("incline") || key.startsWith("direction") || key.endsWith("direction")) {
                    newValue = UP_DOWN.apply(value);
                    if (newValue.equals(value)) {
                        newValue = ReverseWayTagCorrector.invertNumber(value);
                    }
                } else if (key.endsWith(":forward") || key.endsWith(":backward")) {
                    newKey = FORWARD_BACKWARD.apply(key);
                } else if (!ReverseWayTagCorrector.ignoreKeyForCorrection(key)) {
                    StringSwitcher prefixSuffixSwitcher;
                    StringSwitcher[] arr$ = stringSwitchers;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && key.equals(newKey = (prefixSuffixSwitcher = arr$[i$]).apply(key)) && value.equals(newValue = prefixSuffixSwitcher.apply(value)); ++i$) {
                    }
                }
            }
            return new Tag(newKey, newValue);
        }
    }

    private static class StringSwitcher {
        private final String a;
        private final String b;
        private final Pattern pattern;

        public StringSwitcher(String a, String b) {
            this.a = a;
            this.b = b;
            this.pattern = ReverseWayTagCorrector.getPatternFor(a + "|" + b);
        }

        public String apply(String text) {
            Matcher m = this.pattern.matcher(text);
            if (m.lookingAt()) {
                String leftRight = m.group(2).toLowerCase();
                StringBuilder result = new StringBuilder();
                result.append(text.substring(0, m.start(2)));
                result.append(leftRight.equals(this.a) ? this.b : this.a);
                result.append(text.substring(m.end(2)));
                return result.toString();
            }
            return text;
        }
    }
}

