/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.Arrays;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class ReverseWayNoTagCorrector {
    public static final TagCollection directionalTags = new TagCollection(Arrays.asList(new Tag("natural", "coastline"), new Tag("natural", "cliff"), new Tag("barrier", "guard_rail"), new Tag("barrier", "kerb"), new Tag("barrier", "retaining_wall"), new Tag("waterway", "stream"), new Tag("waterway", "river"), new Tag("waterway", "ditch"), new Tag("waterway", "drain"), new Tag("waterway", "canal")));

    public static final TagCollection getDirectionalTags(Way way) {
        return directionalTags.intersect(TagCollection.from(way));
    }

    public static boolean isReversible(Way way) {
        return ReverseWayNoTagCorrector.getDirectionalTags(way).isEmpty();
    }

    protected static String getHTML(TagCollection tags) {
        if (tags.size() == 1) {
            return tags.iterator().next().toString();
        }
        if (tags.size() > 1) {
            return Utils.joinAsHtmlUnorderedList(tags);
        }
        return "";
    }

    protected static boolean confirmReverseWay(Way way, TagCollection tags) {
        String msg = I18n.trn("<html>You are going to reverse the way ''{0}'',<br/> whose semantic meaning of its tag ''{1}'' is defined by its direction.<br/>Do you really want to change the way direction, thus its semantic meaning?</html>", "<html>You are going to reverse the way ''{0}'',<br/> whose semantic meaning of these tags are defined by its direction:<br/>{1}Do you really want to change the way direction, thus its semantic meaning?</html>", tags.size(), way.getDisplayName(DefaultNameFormatter.getInstance()), ReverseWayNoTagCorrector.getHTML(tags));
        int ret = ConditionalOptionPaneUtil.showOptionDialog("reverse_directional_way", Main.parent, msg, I18n.tr("Reverse directional way.", new Object[0]), 1, 2, null, null);
        switch (ret) {
            case -2147483648: 
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static void checkAndConfirmReverseWay(Way way) throws UserCancelException {
        TagCollection tags = ReverseWayNoTagCorrector.getDirectionalTags(way);
        if (!tags.isEmpty() && !ReverseWayNoTagCorrector.confirmReverseWay(way, tags)) {
            throw new UserCancelException();
        }
    }
}

