/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.tools.I18n;

public abstract class CorrectionTableModel<C>
extends AbstractTableModel {
    private List<C> corrections;
    private boolean[] apply;
    private int applyColumn;

    public CorrectionTableModel(List<C> corrections) {
        this.corrections = corrections;
        this.apply = new boolean[this.corrections.size()];
        Arrays.fill(this.apply, true);
        this.applyColumn = this.getColumnCount() - 1;
    }

    @Override
    public abstract int getColumnCount();

    protected abstract boolean isBoldCell(int var1, int var2);

    public abstract String getCorrectionColumnName(int var1);

    public abstract Object getCorrectionValueAt(int var1, int var2);

    public List<C> getCorrections() {
        return this.corrections;
    }

    public int getApplyColumn() {
        return this.applyColumn;
    }

    public boolean getApply(int i) {
        return this.apply[i];
    }

    @Override
    public int getRowCount() {
        return this.corrections.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.applyColumn) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == this.applyColumn) {
            return I18n.tr("Apply?", new Object[0]);
        }
        return this.getCorrectionColumnName(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == this.applyColumn;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == this.applyColumn && aValue instanceof Boolean) {
            this.apply[rowIndex] = (Boolean)aValue;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        if (colIndex == this.applyColumn) {
            return this.apply[rowIndex];
        }
        return this.getCorrectionValueAt(rowIndex, colIndex);
    }
}

