/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.corrector.CorrectionTableModel;

public abstract class CorrectionTable<T extends CorrectionTableModel<?>>
extends JTable {
    private static volatile BoldRenderer boldRenderer = null;

    protected CorrectionTable(T correctionTableModel) {
        super((TableModel)correctionTableModel);
        int correctionsSize = ((CorrectionTableModel)correctionTableModel).getCorrections().size();
        int lines = correctionsSize > 10 ? 10 : correctionsSize;
        this.setPreferredScrollableViewportSize(new Dimension(400, lines * this.getRowHeight()));
        this.getColumnModel().getColumn(((CorrectionTableModel)correctionTableModel).getApplyColumn()).setPreferredWidth(40);
        this.setRowSelectionAllowed(false);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (((CorrectionTableModel)this.getCorrectionTableModel()).isBoldCell(row, column)) {
            if (boldRenderer == null) {
                boldRenderer = new BoldRenderer();
            }
            return boldRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    public T getCorrectionTableModel() {
        return (T)((CorrectionTableModel)this.getModel());
    }

    public static class BoldRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Font f = this.getFont();
            this.setFont(new Font(f.getName(), f.getStyle() | 1, f.getSize()));
            this.setText((String)value);
            return this;
        }
    }
}

