/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.conflict.ConflictResolveCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberConflictResolverCommand
extends ConflictResolveCommand {
    private final Relation my;
    private final Relation their;
    private final List<RelationMember> mergedMembers;

    public RelationMemberConflictResolverCommand(Relation my, Relation their, List<RelationMember> mergedMembers) {
        this.my = my;
        this.their = their;
        this.mergedMembers = mergedMembers;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in member list of relation {0}", this.my.getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.my.setMembers(this.mergedMembers);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.my);
    }

    @Override
    public void undoCommand() {
        OsmDataLayer layer = this.getLayer();
        if (!Main.map.mapView.hasLayer(layer)) {
            Main.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), layer.toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(layer);
        OsmDataLayer editLayer = Main.main.getEditLayer();
        super.undoCommand();
        if (!editLayer.getConflicts().hasConflictForMy(this.my)) {
            editLayer.getConflicts().add(this.my, this.their);
        }
    }
}

