/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public abstract class ConflictResolveCommand
extends Command {
    private ConflictCollection resolvedConflicts = new ConflictCollection();

    public ConflictResolveCommand() {
    }

    public ConflictResolveCommand(OsmDataLayer layer) {
        super(layer);
    }

    protected void rememberConflict(Conflict<?> c) {
        if (!this.resolvedConflicts.hasConflictForMy((OsmPrimitive)c.getMy())) {
            this.resolvedConflicts.add(c);
        }
    }

    protected void reconstituteConflicts() {
        OsmDataLayer editLayer = this.getLayer();
        for (Conflict<?> c : this.resolvedConflicts) {
            if (editLayer.getConflicts().hasConflictForMy((OsmPrimitive)c.getMy())) continue;
            editLayer.getConflicts().add(c);
        }
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        if (!Main.map.mapView.hasLayer(this.getLayer())) {
            Main.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), this.getLayer().toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(this.getLayer());
        this.reconstituteConflicts();
    }
}

