/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictAddCommand
extends Command {
    private Conflict<? extends OsmPrimitive> conflict;

    public ConflictAddCommand(OsmDataLayer layer, Conflict<? extends OsmPrimitive> conflict) {
        super(layer);
        this.conflict = conflict;
    }

    protected void warnBecauseOfDoubleConflict() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Layer ''{0}'' already has a conflict for object<br>''{1}''.<br>This conflict cannot be added.</html>", this.getLayer().getName(), this.conflict.getMy().getDisplayName(DefaultNameFormatter.getInstance())), I18n.tr("Double conflict", new Object[0]), 0);
    }

    @Override
    public boolean executeCommand() {
        try {
            this.getLayer().getConflicts().add(this.conflict);
        }
        catch (IllegalStateException e) {
            Main.error(e);
            this.warnBecauseOfDoubleConflict();
        }
        return true;
    }

    @Override
    public void undoCommand() {
        if (!Main.map.mapView.hasLayer(this.getLayer())) {
            Main.warn(I18n.tr("Layer ''{0}'' does not exist any more. Cannot remove conflict for object ''{1}''.", this.getLayer().getName(), this.conflict.getMy().getDisplayName(DefaultNameFormatter.getInstance())));
            return;
        }
        this.getLayer().getConflicts().remove(this.conflict);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Add conflict for ''{0}''", this.conflict.getMy().getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(this.conflict.getMy().getDisplayType());
    }
}

