/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class SequenceCommand
extends Command {
    private Command[] sequence;
    private boolean sequenceComplete;
    private final String name;
    public boolean continueOnError = false;

    public SequenceCommand(String name, Collection<Command> sequenz) {
        this.name = name;
        this.sequence = sequenz.toArray(new Command[sequenz.size()]);
    }

    public SequenceCommand(String name, Command ... sequenz) {
        this(name, Arrays.asList(sequenz));
    }

    @Override
    public boolean executeCommand() {
        for (int i = 0; i < this.sequence.length; ++i) {
            boolean result = this.sequence[i].executeCommand();
            if (result || this.continueOnError) continue;
            this.undoCommands(i - 1);
            return false;
        }
        this.sequenceComplete = true;
        return true;
    }

    public Command getLastCommand() {
        if (this.sequence.length == 0) {
            return null;
        }
        return this.sequence[this.sequence.length - 1];
    }

    protected final void undoCommands(int start) {
        if (!this.sequenceComplete) {
            return;
        }
        for (int i = start; i >= 0; --i) {
            this.sequence[i].undoCommand();
        }
    }

    @Override
    public void undoCommand() {
        this.undoCommands(this.sequence.length - 1);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        for (Command c : this.sequence) {
            c.fillModifiedData(modified, deleted, added);
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Sequence: {0}", this.name);
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "sequence");
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        return Arrays.asList(this.sequence);
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet<? extends OsmPrimitive> prims = new HashSet<OsmPrimitive>();
        for (Command c : this.sequence) {
            prims.addAll(c.getParticipatingPrimitives());
        }
        return prims;
    }

    protected final void setSequence(Command[] sequence) {
        this.sequence = Utils.copyArray(sequence);
    }

    protected final void setSequenceComplete(boolean sequenceComplete) {
        this.sequenceComplete = sequenceComplete;
    }
}

