/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.TransformNodesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScaleCommand
extends TransformNodesCommand {
    private EastNorth pivot = this.getNodesCenter();
    private double scalingFactor;
    EastNorth startEN = null;

    public ScaleCommand(Collection<OsmPrimitive> objects, EastNorth currentEN) {
        super(objects);
        this.startEN = currentEN;
        this.handleEvent(currentEN);
    }

    @Override
    public final void handleEvent(EastNorth currentEN) {
        double startAngle = Math.atan2(this.startEN.east() - this.pivot.east(), this.startEN.north() - this.pivot.north());
        double endAngle = Math.atan2(currentEN.east() - this.pivot.east(), currentEN.north() - this.pivot.north());
        double startDistance = this.pivot.distance(this.startEN);
        double currentDistance = this.pivot.distance(currentEN);
        this.scalingFactor = Math.cos(startAngle - endAngle) * currentDistance / startDistance;
        this.transformNodes();
    }

    @Override
    protected void transformNodes() {
        for (Node n : this.nodes) {
            EastNorth oldEastNorth = ((Command.OldNodeState)this.oldStates.get((Object)n)).eastNorth;
            double dx = oldEastNorth.east() - this.pivot.east();
            double dy = oldEastNorth.north() - this.pivot.north();
            double nx = this.pivot.east() + this.scalingFactor * dx;
            double ny = this.pivot.north() + this.scalingFactor * dy;
            n.setEastNorth(new EastNorth(nx, ny));
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Scale {0} node", "Scale {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "node");
    }
}

