/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.TransformNodesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RotateCommand
extends TransformNodesCommand {
    private EastNorth pivot = this.getNodesCenter();
    private double startAngle = 0.0;
    private double rotationAngle = 0.0;

    public RotateCommand(Collection<OsmPrimitive> objects, EastNorth currentEN) {
        super(objects);
        this.startAngle = this.getAngle(currentEN);
        this.rotationAngle = 0.0;
        this.handleEvent(currentEN);
    }

    protected final double getAngle(EastNorth currentEN) {
        if (this.pivot == null) {
            return 0.0;
        }
        return Math.atan2(currentEN.east() - this.pivot.east(), currentEN.north() - this.pivot.north());
    }

    @Override
    public final void handleEvent(EastNorth currentEN) {
        double currentAngle = this.getAngle(currentEN);
        this.rotationAngle = currentAngle - this.startAngle;
        this.transformNodes();
    }

    @Override
    protected void transformNodes() {
        for (Node n : this.nodes) {
            double cosPhi = Math.cos(this.rotationAngle);
            double sinPhi = Math.sin(this.rotationAngle);
            EastNorth oldEastNorth = ((Command.OldNodeState)this.oldStates.get((Object)n)).eastNorth;
            double x = oldEastNorth.east() - this.pivot.east();
            double y = oldEastNorth.north() - this.pivot.north();
            double nx = cosPhi * x + sinPhi * y + this.pivot.east();
            double ny = -sinPhi * x + cosPhi * y + this.pivot.north();
            n.setEastNorth(new EastNorth(nx, ny));
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Rotate {0} node", "Rotate {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "node");
    }
}

