/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MoveCommand
extends Command {
    private Collection<Node> nodes = new LinkedList<Node>();
    private EastNorth startEN = null;
    private double x;
    private double y;
    private double backupX;
    private double backupY;
    private List<Command.OldNodeState> oldState = new LinkedList<Command.OldNodeState>();

    public MoveCommand(OsmPrimitive osm, double x, double y) {
        this(Collections.singleton(osm), x, y);
    }

    public MoveCommand(Node node, LatLon position) {
        this(Collections.singleton(node), node.getEastNorth().sub(Projections.project(position)));
    }

    public MoveCommand(Collection<OsmPrimitive> objects, EastNorth offset) {
        this(objects, offset.getX(), offset.getY());
    }

    public MoveCommand(Collection<OsmPrimitive> objects, double x, double y) {
        this.saveCheckpoint();
        this.x = x;
        this.y = y;
        this.nodes = AllNodesVisitor.getAllNodes(objects);
        for (Node n : this.nodes) {
            this.oldState.add(new Command.OldNodeState(n));
        }
    }

    public MoveCommand(Collection<OsmPrimitive> objects, EastNorth start, EastNorth end) {
        this(objects, end.getX() - start.getX(), end.getY() - start.getY());
        this.startEN = start;
    }

    public MoveCommand(OsmPrimitive p, EastNorth start, EastNorth end) {
        this(Collections.singleton(p), end.getX() - start.getX(), end.getY() - start.getY());
        this.startEN = start;
    }

    public void moveAgain(double x, double y) {
        for (Node n : this.nodes) {
            n.setEastNorth(n.getEastNorth().add(x, y));
        }
        this.x += x;
        this.y += y;
    }

    public void moveAgainTo(double x, double y) {
        this.moveAgain(x - this.x, y - this.y);
    }

    public void applyVectorTo(EastNorth currentEN) {
        if (this.startEN == null) {
            return;
        }
        this.x = currentEN.getX() - this.startEN.getX();
        this.y = currentEN.getY() - this.startEN.getY();
        this.updateCoordinates();
    }

    public void changeStartPoint(EastNorth newDraggedStartPoint) {
        this.startEN = new EastNorth(newDraggedStartPoint.getX() - this.x, newDraggedStartPoint.getY() - this.y);
    }

    public final void saveCheckpoint() {
        this.backupX = this.x;
        this.backupY = this.y;
    }

    public void resetToCheckpoint() {
        this.x = this.backupX;
        this.y = this.backupY;
        this.updateCoordinates();
    }

    private void updateCoordinates() {
        Iterator<Command.OldNodeState> it = this.oldState.iterator();
        for (Node n : this.nodes) {
            Command.OldNodeState os = it.next();
            if (os.eastNorth == null) continue;
            n.setEastNorth(os.eastNorth.add(this.x, this.y));
        }
    }

    @Override
    public boolean executeCommand() {
        for (Node n : this.nodes) {
            if (n == null) {
                throw new AssertionError((Object)"null detected in node list");
            }
            EastNorth en = n.getEastNorth();
            if (en == null) continue;
            n.setEastNorth(en.add(this.x, this.y));
            n.setModified(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        Iterator<Command.OldNodeState> it = this.oldState.iterator();
        for (Node n : this.nodes) {
            Command.OldNodeState os = it.next();
            n.setCoor(os.latlon);
            n.setModified(os.modified);
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        for (OsmPrimitive osmPrimitive : this.nodes) {
            modified.add(osmPrimitive);
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Move {0} node", "Move {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "node");
    }

    public Collection<Node> getParticipatingPrimitives() {
        return this.nodes;
    }
}

