/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.actionsupport.DeleteFromRelationConfirmationDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class DeleteCommand
extends Command {
    private final Collection<? extends OsmPrimitive> toDelete;
    private final Map<OsmPrimitive, PrimitiveData> clonedPrimitives = new HashMap<OsmPrimitive, PrimitiveData>();

    public DeleteCommand(Collection<? extends OsmPrimitive> data) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        if (data.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("At least one object to delete required, got empty collection", new Object[0]));
        }
        this.toDelete = data;
        this.checkConsistency();
    }

    public DeleteCommand(OsmPrimitive data) throws IllegalArgumentException {
        this(Collections.singleton(data));
    }

    public DeleteCommand(OsmDataLayer layer, OsmPrimitive data) throws IllegalArgumentException {
        this(layer, Collections.singleton(data));
    }

    public DeleteCommand(OsmDataLayer layer, Collection<? extends OsmPrimitive> data) throws IllegalArgumentException {
        super(layer);
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        if (data.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("At least one object to delete required, got empty collection", new Object[0]));
        }
        this.toDelete = data;
        this.checkConsistency();
    }

    private void checkConsistency() {
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (osmPrimitive == null) {
                throw new IllegalArgumentException("Primitive to delete must not be null");
            }
            if (osmPrimitive.getDataSet() != null) continue;
            throw new IllegalArgumentException("Primitive to delete must be in a dataset");
        }
    }

    @Override
    public boolean executeCommand() {
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            if (osmPrimitive.isDeleted()) {
                throw new IllegalArgumentException(osmPrimitive.toString() + " is already deleted");
            }
            this.clonedPrimitives.put(osmPrimitive, osmPrimitive.save());
            if (osmPrimitive instanceof Way) {
                ((Way)osmPrimitive).setNodes(null);
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            ((Relation)osmPrimitive).setMembers(null);
        }
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(true);
        }
        return true;
    }

    @Override
    public void undoCommand() {
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(false);
        }
        for (Map.Entry entry : this.clonedPrimitives.entrySet()) {
            ((OsmPrimitive)entry.getKey()).load((PrimitiveData)entry.getValue());
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    private Set<OsmPrimitiveType> getTypesToDelete() {
        HashSet<OsmPrimitiveType> typesToDelete = new HashSet<OsmPrimitiveType>();
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            typesToDelete.add(OsmPrimitiveType.from(osmPrimitive));
        }
        return typesToDelete;
    }

    @Override
    public String getDescriptionText() {
        if (this.toDelete.size() == 1) {
            OsmPrimitive primitive = this.toDelete.iterator().next();
            String msg = "";
            switch (OsmPrimitiveType.from(primitive)) {
                case NODE: {
                    msg = I18n.marktr("Delete node {0}");
                    break;
                }
                case WAY: {
                    msg = I18n.marktr("Delete way {0}");
                    break;
                }
                case RELATION: {
                    msg = I18n.marktr("Delete relation {0}");
                }
            }
            return I18n.tr(msg, primitive.getDisplayName(DefaultNameFormatter.getInstance()));
        }
        Set<OsmPrimitiveType> typesToDelete = this.getTypesToDelete();
        String msg = "";
        if (typesToDelete.size() > 1) {
            msg = I18n.trn("Delete {0} object", "Delete {0} objects", this.toDelete.size(), this.toDelete.size());
        } else {
            OsmPrimitiveType t = typesToDelete.iterator().next();
            switch (t) {
                case NODE: {
                    msg = I18n.trn("Delete {0} node", "Delete {0} nodes", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case WAY: {
                    msg = I18n.trn("Delete {0} way", "Delete {0} ways", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case RELATION: {
                    msg = I18n.trn("Delete {0} relation", "Delete {0} relations", this.toDelete.size(), this.toDelete.size());
                }
            }
        }
        return msg;
    }

    @Override
    public Icon getDescriptionIcon() {
        if (this.toDelete.size() == 1) {
            return ImageProvider.get(this.toDelete.iterator().next().getDisplayType());
        }
        Set<OsmPrimitiveType> typesToDelete = this.getTypesToDelete();
        if (typesToDelete.size() > 1) {
            return ImageProvider.get("data", "object");
        }
        return ImageProvider.get(typesToDelete.iterator().next());
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.toDelete.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>(this.toDelete.size());
        for (final OsmPrimitive osmPrimitive : this.toDelete) {
            children.add(new PseudoCommand(){

                @Override
                public String getDescriptionText() {
                    return I18n.tr("Deleted ''{0}''", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
                }

                @Override
                public Icon getDescriptionIcon() {
                    return ImageProvider.get(osmPrimitive.getDisplayType());
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osmPrimitive);
                }
            });
        }
        return children;
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toDelete;
    }

    public static Command deleteWithReferences(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean silent) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Set<OsmPrimitive> parents = OsmPrimitive.getReferrer(selection);
        parents.addAll(selection);
        if (parents.isEmpty()) {
            return null;
        }
        if (!silent && !DeleteCommand.checkAndConfirmOutlyingDelete(parents, null)) {
            return null;
        }
        return new DeleteCommand(layer, parents);
    }

    public static Command deleteWithReferences(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection) {
        return DeleteCommand.deleteWithReferences(layer, selection, false);
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection) {
        return DeleteCommand.delete(layer, selection, true, false);
    }

    protected static Collection<Node> computeNodesToDelete(OsmDataLayer layer, Collection<OsmPrimitive> primitivesToDelete) {
        HashSet<Node> nodesToDelete = new HashSet<Node>();
        for (Way way : OsmPrimitive.getFilteredList(primitivesToDelete, Way.class)) {
            for (Node n : way.getNodes()) {
                if (n.isTagged()) continue;
                List<OsmPrimitive> referringPrimitives = n.getReferrers();
                referringPrimitives.removeAll(primitivesToDelete);
                int count = 0;
                for (OsmPrimitive p : referringPrimitives) {
                    if (p.isDeleted()) continue;
                    ++count;
                }
                if (count != 0) continue;
                nodesToDelete.add(n);
            }
        }
        return nodesToDelete;
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean alsoDeleteNodesInWay) {
        return DeleteCommand.delete(layer, selection, alsoDeleteNodesInWay, false);
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean alsoDeleteNodesInWay, boolean silent) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        HashSet<OsmPrimitive> primitivesToDelete = new HashSet<OsmPrimitive>(selection);
        SubclassFilteredCollection<? extends OsmPrimitive, Relation> relationsToDelete = Utils.filteredCollection(primitivesToDelete, Relation.class);
        if (!(relationsToDelete.isEmpty() || silent || DeleteCommand.confirmRelationDeletion(relationsToDelete))) {
            return null;
        }
        HashSet<Way> waysToBeChanged = new HashSet<Way>();
        if (alsoDeleteNodesInWay) {
            Collection<Node> nodesToDelete = DeleteCommand.computeNodesToDelete(layer, primitivesToDelete);
            primitivesToDelete.addAll(nodesToDelete);
        }
        if (!silent && !DeleteCommand.checkAndConfirmOutlyingDelete(primitivesToDelete, Utils.filteredCollection(primitivesToDelete, Way.class))) {
            return null;
        }
        waysToBeChanged.addAll(OsmPrimitive.getFilteredSet(OsmPrimitive.getReferrer(primitivesToDelete), Way.class));
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Way w : waysToBeChanged) {
            Way wnew = new Way(w);
            wnew.removeNodes(OsmPrimitive.getFilteredSet(primitivesToDelete, Node.class));
            if (wnew.getNodesCount() < 2) {
                primitivesToDelete.add(w);
                continue;
            }
            cmds.add(new ChangeNodesCommand(w, wnew.getNodes()));
        }
        if (!silent) {
            Set<RelationToChildReference> references = RelationToChildReference.getRelationToChildReferences(primitivesToDelete);
            Iterator<RelationToChildReference> it = references.iterator();
            while (it.hasNext()) {
                RelationToChildReference ref = it.next();
                if (!ref.getParent().isDeleted()) continue;
                it.remove();
            }
            if (!references.isEmpty()) {
                DeleteFromRelationConfirmationDialog dialog = DeleteFromRelationConfirmationDialog.getInstance();
                dialog.getModel().populate(references);
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return null;
                }
            }
        }
        for (Relation cur : OsmPrimitive.getFilteredSet(OsmPrimitive.getReferrer(primitivesToDelete), Relation.class)) {
            Relation rel = new Relation(cur);
            rel.removeMembersFor(primitivesToDelete);
            cmds.add(new ChangeCommand(cur, rel));
        }
        if (!primitivesToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(layer, primitivesToDelete));
        }
        return new SequenceCommand(I18n.tr("Delete", new Object[0]), cmds);
    }

    public static Command deleteWaySegment(OsmDataLayer layer, WaySegment ws) {
        if (ws.way.getNodesCount() < 3) {
            return DeleteCommand.delete(layer, Collections.singleton(ws.way), false);
        }
        if (ws.way.firstNode() == ws.way.lastNode()) {
            ArrayList<Node> n = new ArrayList<Node>();
            n.addAll(ws.way.getNodes().subList(ws.lowerIndex + 1, ws.way.getNodesCount() - 1));
            n.addAll(ws.way.getNodes().subList(0, ws.lowerIndex + 1));
            Way wnew = new Way(ws.way);
            wnew.setNodes(n);
            return new ChangeCommand(ws.way, wnew);
        }
        ArrayList<Node> n1 = new ArrayList<Node>();
        ArrayList<Node> n2 = new ArrayList<Node>();
        n1.addAll(ws.way.getNodes().subList(0, ws.lowerIndex + 1));
        n2.addAll(ws.way.getNodes().subList(ws.lowerIndex + 1, ws.way.getNodesCount()));
        Way wnew = new Way(ws.way);
        if (n1.size() < 2) {
            wnew.setNodes(n2);
            return new ChangeCommand(ws.way, wnew);
        }
        if (n2.size() < 2) {
            wnew.setNodes(n1);
            return new ChangeCommand(ws.way, wnew);
        }
        ArrayList<List<Node>> chunks = new ArrayList<List<Node>>(2);
        chunks.add(n1);
        chunks.add(n2);
        return SplitWayAction.splitWay(layer, ws.way, chunks, Collections.emptyList()).getCommand();
    }

    public static boolean checkAndConfirmOutlyingDelete(Collection<? extends OsmPrimitive> primitives, Collection<? extends OsmPrimitive> ignore) {
        return Command.checkAndConfirmOutlyingOperation("delete", I18n.tr("Delete confirmation", new Object[0]), I18n.tr("You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to delete?", new Object[0]), I18n.tr("You are about to delete incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to delete?", new Object[0]), primitives, ignore);
    }

    private static boolean confirmRelationDeletion(Collection<Relation> relations) {
        JPanel msg = new JPanel(new GridBagLayout());
        msg.add(new JMultilineLabel("<html>" + I18n.trn("You are about to delete {0} relation: {1}<br/>This step is rarely necessary and cannot be undone easily after being uploaded to the server.<br/>Do you really want to delete?", "You are about to delete {0} relations: {1}<br/>This step is rarely necessary and cannot be undone easily after being uploaded to the server.<br/>Do you really want to delete?", relations.size(), relations.size(), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(relations)) + "</html>"));
        return ConditionalOptionPaneUtil.showConfirmationDialog("delete_relations", Main.parent, msg, I18n.tr("Delete relation?", new Object[0]), 0, 3, 0);
    }
}

