/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class Command
extends PseudoCommand {
    private Map<OsmPrimitive, PrimitiveData> cloneMap = new HashMap<OsmPrimitive, PrimitiveData>();
    private final OsmDataLayer layer;

    public Command() {
        this.layer = Main.main == null ? null : Main.main.getEditLayer();
    }

    public Command(OsmDataLayer layer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
    }

    public boolean executeCommand() {
        CloneVisitor visitor = new CloneVisitor();
        ArrayList<OsmPrimitive> all = new ArrayList<OsmPrimitive>();
        this.fillModifiedData(all, all, all);
        for (OsmPrimitive osm : all) {
            osm.accept(visitor);
        }
        this.cloneMap = visitor.orig;
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, PrimitiveData> e : this.cloneMap.entrySet()) {
            OsmPrimitive primitive = e.getKey();
            if (primitive.getDataSet() == null) continue;
            e.getKey().load(e.getValue());
        }
    }

    public boolean invalidBecauselayerRemoved(Layer oldLayer) {
        if (!(oldLayer instanceof OsmDataLayer)) {
            return false;
        }
        return this.layer == oldLayer;
    }

    public PrimitiveData getOrig(OsmPrimitive osm) {
        return this.cloneMap.get(osm);
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public abstract void fillModifiedData(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.cloneMap.keySet();
    }

    public static boolean checkAndConfirmOutlyingOperation(String operation, String dialogTitle, String outsideDialogMessage, String incompleteDialogMessage, Collection<? extends OsmPrimitive> primitives, Collection<? extends OsmPrimitive> ignore) {
        JPanel msg;
        boolean outside = false;
        boolean incomplete = false;
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive.isIncomplete()) {
                incomplete = true;
                continue;
            }
            if (!osmPrimitive.isOutsideDownloadArea() || ignore != null && ignore.contains(osmPrimitive)) continue;
            outside = true;
        }
        if (outside) {
            msg = new JPanel(new GridBagLayout());
            msg.add(new JMultilineLabel("<html>" + outsideDialogMessage + "</html>"));
            boolean bl = ConditionalOptionPaneUtil.showConfirmationDialog(operation + "_outside_nodes", Main.parent, msg, dialogTitle, 0, 3, 0);
            if (!bl) {
                return false;
            }
        }
        if (incomplete) {
            msg = new JPanel(new GridBagLayout());
            msg.add(new JMultilineLabel("<html>" + incompleteDialogMessage + "</html>"));
            boolean bl = ConditionalOptionPaneUtil.showConfirmationDialog(operation + "_incomplete", Main.parent, msg, dialogTitle, 0, 3, 0);
            if (!bl) {
                return false;
            }
        }
        return true;
    }

    public static class OldNodeState {
        final LatLon latlon;
        final EastNorth eastNorth;
        final boolean modified;

        public OldNodeState(Node node) {
            this.latlon = node.getCoor();
            this.eastNorth = node.getEastNorth();
            this.modified = node.isModified();
        }
    }

    private static final class CloneVisitor
    extends AbstractVisitor {
        public final Map<OsmPrimitive, PrimitiveData> orig = new LinkedHashMap<OsmPrimitive, PrimitiveData>();

        private CloneVisitor() {
        }

        @Override
        public void visit(Node n) {
            this.orig.put(n, n.save());
        }

        @Override
        public void visit(Way w) {
            this.orig.put(w, w.save());
        }

        @Override
        public void visit(Relation e) {
            this.orig.put(e, e.save());
        }
    }
}

