/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangePropertyKeyCommand
extends Command {
    private final List<OsmPrimitive> objects;
    private final String key;
    private final String newKey;

    public ChangePropertyKeyCommand(OsmPrimitive object, String key, String newKey) {
        this(Collections.singleton(object), key, newKey);
    }

    public ChangePropertyKeyCommand(Collection<? extends OsmPrimitive> objects, String key, String newKey) {
        this.objects = new LinkedList<OsmPrimitive>(objects);
        this.key = key;
        this.newKey = newKey;
    }

    @Override
    public boolean executeCommand() {
        if (!super.executeCommand()) {
            return false;
        }
        for (OsmPrimitive osm : this.objects) {
            if (!osm.hasKeys()) continue;
            osm.setModified(true);
            String oldValue = osm.get(this.key);
            osm.put(this.newKey, oldValue);
            osm.remove(this.key);
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.objects);
    }

    @Override
    public String getDescriptionText() {
        String text = I18n.tr("Replace \"{0}\" by \"{1}\" for", this.key, this.newKey);
        if (this.objects.size() == 1) {
            NameVisitor v = new NameVisitor();
            this.objects.iterator().next().accept(v);
            text = text + " " + I18n.tr(v.className, new Object[0]) + " " + v.name;
        } else {
            text = text + " " + this.objects.size() + " " + I18n.trn("object", "objects", this.objects.size(), new Object[0]);
        }
        return text;
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "key");
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>();
        final NameVisitor v = new NameVisitor();
        for (final OsmPrimitive osm : this.objects) {
            osm.accept(v);
            children.add(new PseudoCommand(){

                @Override
                public String getDescriptionText() {
                    return v.name;
                }

                @Override
                public Icon getDescriptionIcon() {
                    return v.icon;
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osm);
                }
            });
        }
        return children;
    }
}

