/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangePropertyCommand
extends Command {
    private final List<OsmPrimitive> objects = new LinkedList<OsmPrimitive>();
    private final AbstractMap<String, String> tags;

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> objects, AbstractMap<String, String> tags) {
        this.tags = tags;
        this.init(objects);
    }

    public ChangePropertyCommand(Collection<? extends OsmPrimitive> objects, String key, String value) {
        this.tags = new HashMap<String, String>(1);
        this.tags.put(key, value);
        this.init(objects);
    }

    public ChangePropertyCommand(OsmPrimitive object, String key, String value) {
        this(Arrays.asList(object), key, value);
    }

    private void init(Collection<? extends OsmPrimitive> objects) {
        for (OsmPrimitive osmPrimitive : objects) {
            boolean modified = false;
            for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                String oldVal = osmPrimitive.get(tag.getKey());
                String newVal = tag.getValue();
                if (newVal == null || newVal.isEmpty()) {
                    if (oldVal == null) continue;
                    modified = true;
                    continue;
                }
                if (oldVal != null && newVal.equals(oldVal)) continue;
                modified = true;
            }
            if (!modified) continue;
            this.objects.add(osmPrimitive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        Main.main.getCurrentDataSet().beginUpdate();
        try {
            super.executeCommand();
            for (OsmPrimitive osm : this.objects) {
                for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                    String oldVal = osm.get(tag.getKey());
                    String newVal = tag.getValue();
                    if (newVal == null || newVal.isEmpty()) {
                        if (oldVal == null) continue;
                        osm.remove(tag.getKey());
                        continue;
                    }
                    if (oldVal != null && newVal.equals(oldVal)) continue;
                    osm.put(tag.getKey(), newVal);
                }
                osm.setModified(true);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Main.main.getCurrentDataSet().endUpdate();
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.objects);
    }

    @Override
    public String getDescriptionText() {
        String text;
        if (this.objects.size() == 1 && this.tags.size() == 1) {
            OsmPrimitive primitive = this.objects.iterator().next();
            String msg = "";
            Map.Entry<String, String> entry = this.tags.entrySet().iterator().next();
            if (entry.getValue() == null) {
                switch (OsmPrimitiveType.from(primitive)) {
                    case NODE: {
                        msg = I18n.marktr("Remove \"{0}\" for node ''{1}''");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("Remove \"{0}\" for way ''{1}''");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("Remove \"{0}\" for relation ''{1}''");
                    }
                }
                text = I18n.tr(msg, entry.getKey(), primitive.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                switch (OsmPrimitiveType.from(primitive)) {
                    case NODE: {
                        msg = I18n.marktr("Set {0}={1} for node ''{2}''");
                        break;
                    }
                    case WAY: {
                        msg = I18n.marktr("Set {0}={1} for way ''{2}''");
                        break;
                    }
                    case RELATION: {
                        msg = I18n.marktr("Set {0}={1} for relation ''{2}''");
                    }
                }
                text = I18n.tr(msg, entry.getKey(), entry.getValue(), primitive.getDisplayName(DefaultNameFormatter.getInstance()));
            }
        } else if (this.objects.size() > 1 && this.tags.size() == 1) {
            Map.Entry<String, String> entry = this.tags.entrySet().iterator().next();
            text = entry.getValue() == null ? I18n.trn("Remove \"{0}\" for {1} object", "Remove \"{0}\" for {1} objects", this.objects.size(), entry.getKey(), this.objects.size()) : I18n.trn("Set {0}={1} for {2} object", "Set {0}={1} for {2} objects", this.objects.size(), entry.getKey(), entry.getValue(), this.objects.size());
        } else {
            boolean allnull = true;
            for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                if (tag.getValue() == null) continue;
                allnull = false;
                break;
            }
            text = allnull ? I18n.trn("Deleted {0} tags for {1} object", "Deleted {0} tags for {1} objects", this.objects.size(), this.tags.size(), this.objects.size()) : I18n.trn("Set {0} tags for {1} object", "Set {0} tags for {1} objects", this.objects.size(), this.tags.size(), this.objects.size());
        }
        return text;
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "key");
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>();
        for (final OsmPrimitive osm : this.objects) {
            children.add(new PseudoCommand(){

                @Override
                public String getDescriptionText() {
                    return osm.getDisplayName(DefaultNameFormatter.getInstance());
                }

                @Override
                public Icon getDescriptionIcon() {
                    return ImageProvider.get(osm.getDisplayType());
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osm);
                }
            });
        }
        return children;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }
}

