/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class AddPrimitivesCommand
extends Command {
    private List<PrimitiveData> data = new ArrayList<PrimitiveData>();
    private Collection<PrimitiveData> toSelect = new ArrayList<PrimitiveData>();
    private List<OsmPrimitive> createdPrimitives = null;
    private Collection<OsmPrimitive> createdPrimitivesToSelect = null;

    public AddPrimitivesCommand(List<PrimitiveData> data) {
        this(data, data);
    }

    public AddPrimitivesCommand(List<PrimitiveData> data, List<PrimitiveData> toSelect) {
        this.init(data, toSelect);
    }

    public AddPrimitivesCommand(List<PrimitiveData> data, List<PrimitiveData> toSelect, OsmDataLayer layer) {
        super(layer);
        this.init(data, toSelect);
    }

    private final void init(List<PrimitiveData> data, List<PrimitiveData> toSelect) {
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        this.data.addAll(data);
        if (toSelect != null) {
            this.toSelect.addAll(toSelect);
        }
    }

    @Override
    public boolean executeCommand() {
        Collection<OsmPrimitive> primitivesToSelect;
        if (this.createdPrimitives == null) {
            ArrayList<OsmPrimitive> newPrimitives = new ArrayList<OsmPrimitive>(this.data.size());
            primitivesToSelect = new ArrayList<OsmPrimitive>(this.toSelect.size());
            for (PrimitiveData pd : this.data) {
                boolean created;
                OsmPrimitive primitive = this.getLayer().data.getPrimitiveById(pd);
                boolean bl = created = primitive == null;
                if (created) {
                    primitive = pd.getType().newInstance(pd.getUniqueId(), true);
                }
                if (pd instanceof NodeData) {
                    primitive.load(pd);
                }
                if (created) {
                    this.getLayer().data.addPrimitive(primitive);
                }
                newPrimitives.add(primitive);
                if (!this.toSelect.contains(pd)) continue;
                primitivesToSelect.add(primitive);
            }
            for (int i = 0; i < newPrimitives.size(); ++i) {
                if (newPrimitives.get(i) instanceof Node) continue;
                ((OsmPrimitive)newPrimitives.get(i)).load(this.data.get(i));
            }
        } else {
            for (OsmPrimitive osm : this.createdPrimitives) {
                this.getLayer().data.addPrimitive(osm);
            }
            primitivesToSelect = this.createdPrimitivesToSelect;
        }
        this.getLayer().data.setSelected(primitivesToSelect);
        return true;
    }

    @Override
    public void undoCommand() {
        DataSet ds = this.getLayer().data;
        if (this.createdPrimitives == null) {
            this.createdPrimitives = new ArrayList<OsmPrimitive>(this.data.size());
            this.createdPrimitivesToSelect = new ArrayList<OsmPrimitive>(this.toSelect.size());
            for (PrimitiveData pd : this.data) {
                OsmPrimitive p = ds.getPrimitiveById(pd);
                this.createdPrimitives.add(p);
                if (!this.toSelect.contains(pd)) continue;
                this.createdPrimitivesToSelect.add(p);
            }
            this.createdPrimitives = PurgeCommand.topoSort(this.createdPrimitives);
            for (PrimitiveData p : this.data) {
                ds.removePrimitive(p);
            }
            this.data = null;
            this.toSelect = null;
        } else {
            for (OsmPrimitive osm : this.createdPrimitives) {
                ds.removePrimitive(osm);
            }
        }
    }

    @Override
    public String getDescriptionText() {
        int size = this.data != null ? this.data.size() : this.createdPrimitives.size();
        return I18n.trn("Added {0} object", "Added {0} objects", size, size);
    }

    @Override
    public Icon getDescriptionIcon() {
        return null;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        if (this.createdPrimitives != null) {
            return this.createdPrimitives;
        }
        HashSet<OsmPrimitive> prims = new HashSet<OsmPrimitive>();
        for (PrimitiveData d : this.data) {
            OsmPrimitive osm = this.getLayer().data.getPrimitiveById(d);
            if (osm == null) {
                throw new RuntimeException();
            }
            prims.add(osm);
        }
        return prims;
    }
}

