/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddCommand
extends Command {
    private final OsmPrimitive osm;

    public AddCommand(OsmPrimitive osm) {
        this.osm = osm;
    }

    public AddCommand(OsmDataLayer layer, OsmPrimitive osm) {
        super(layer);
        this.osm = osm;
    }

    protected static final void checkNodeStyles(OsmPrimitive osm) {
        if (osm instanceof Way) {
            ((Way)osm).clearCachedNodeStyles();
        }
    }

    @Override
    public boolean executeCommand() {
        this.getLayer().data.addPrimitive(this.osm);
        this.osm.setModified(true);
        AddCommand.checkNodeStyles(this.osm);
        return true;
    }

    @Override
    public void undoCommand() {
        this.getLayer().data.removePrimitive(this.osm);
        AddCommand.checkNodeStyles(this.osm);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        added.add(this.osm);
    }

    @Override
    public String getDescriptionText() {
        String msg;
        switch (OsmPrimitiveType.from(this.osm)) {
            case NODE: {
                msg = I18n.marktr("Add node {0}");
                break;
            }
            case WAY: {
                msg = I18n.marktr("Add way {0}");
                break;
            }
            case RELATION: {
                msg = I18n.marktr("Add relation {0}");
                break;
            }
            default: {
                msg = "";
            }
        }
        return I18n.tr(msg, this.osm.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get(this.osm.getDisplayType());
    }

    public Collection<OsmPrimitive> getParticipatingPrimitives() {
        return Collections.singleton(this.osm);
    }
}

