/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class UploadNotesTask {
    private UploadTask uploadTask;
    private NoteData noteData;

    public void uploadNotes(NoteData noteData, ProgressMonitor progressMonitor) {
        this.noteData = noteData;
        this.uploadTask = new UploadTask(I18n.tr("Uploading modified notes", new Object[0]), progressMonitor);
        Main.worker.submit(this.uploadTask);
    }

    private class UploadTask
    extends PleaseWaitRunnable {
        private boolean isCanceled;
        Map<Note, Note> updatedNotes;
        Map<Note, Exception> failedNotes;

        public UploadTask(String title, ProgressMonitor monitor) {
            super(title, monitor, false);
            this.isCanceled = false;
            this.updatedNotes = new HashMap<Note, Note>();
            this.failedNotes = new HashMap<Note, Exception>();
        }

        @Override
        protected void cancel() {
            if (Main.isDebugEnabled()) {
                Main.debug("note upload canceled");
            }
            this.isCanceled = true;
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            ProgressMonitor monitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            OsmApi api = OsmApi.getOsmApi();
            for (Note note : UploadNotesTask.this.noteData.getNotes()) {
                if (this.isCanceled) {
                    Main.info("Note upload interrupted by user");
                    break;
                }
                for (NoteComment comment : note.getComments()) {
                    if (!comment.getIsNew().booleanValue()) continue;
                    if (Main.isDebugEnabled()) {
                        Main.debug("found note change to upload");
                    }
                    this.processNoteComment(monitor, api, note, comment);
                }
            }
        }

        private void processNoteComment(ProgressMonitor monitor, OsmApi api, Note note, NoteComment comment) {
            try {
                Note newNote;
                switch (comment.getNoteAction()) {
                    case opened: {
                        if (Main.isDebugEnabled()) {
                            Main.debug("opening new note");
                        }
                        newNote = api.createNote(note.getLatLon(), comment.getText(), monitor);
                        note.setId(newNote.getId());
                        break;
                    }
                    case closed: {
                        if (Main.isDebugEnabled()) {
                            Main.debug("closing note " + note.getId());
                        }
                        newNote = api.closeNote(note, comment.getText(), monitor);
                        break;
                    }
                    case commented: {
                        if (Main.isDebugEnabled()) {
                            Main.debug("adding comment to note " + note.getId());
                        }
                        newNote = api.addCommentToNote(note, comment.getText(), monitor);
                        break;
                    }
                    case reopened: {
                        if (Main.isDebugEnabled()) {
                            Main.debug("reopening note " + note.getId());
                        }
                        newNote = api.reopenNote(note, comment.getText(), monitor);
                        break;
                    }
                    default: {
                        newNote = null;
                    }
                }
                this.updatedNotes.put(note, newNote);
            }
            catch (Exception e) {
                Main.error("Failed to upload note to server: " + note.getId());
                this.failedNotes.put(note, e);
            }
        }

        @Override
        protected void finish() {
            if (Main.isDebugEnabled()) {
                Main.debug("finish called in notes upload task. Notes to update: " + this.updatedNotes.size());
            }
            UploadNotesTask.this.noteData.updateNotes(this.updatedNotes);
            if (!this.failedNotes.isEmpty()) {
                Main.error("Some notes failed to upload");
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<Note, Exception> entry : this.failedNotes.entrySet()) {
                    sb.append(I18n.tr("Note {0} failed: {1}", entry.getKey().getId(), entry.getValue().getMessage()));
                    sb.append("\n");
                }
                Main.error("Notes failed to upload: " + sb.toString());
                JOptionPane.showMessageDialog(Main.map, sb.toString(), I18n.tr("Notes failed to upload", new Object[0]), 0);
            }
        }
    }
}

