/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Property;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SearchAction
extends JosmAction
implements ParameterizedAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 15;
    public static final int MAX_LENGTH_SEARCH_EXPRESSION_DISPLAY = 100;
    private static final LinkedList<SearchSetting> searchHistory = new LinkedList();
    private static volatile SearchSetting lastSearch;

    public static Collection<SearchSetting> getSearchHistory() {
        return searchHistory;
    }

    public static void saveToHistory(SearchSetting s) {
        if (searchHistory.isEmpty() || !s.equals(searchHistory.getFirst())) {
            searchHistory.addFirst(new SearchSetting(s));
        } else if (searchHistory.contains(s)) {
            searchHistory.remove(s);
            searchHistory.addFirst(new SearchSetting(s));
        }
        int maxsize = Main.pref.getInteger("search.history-size", 15);
        while (searchHistory.size() > maxsize) {
            searchHistory.removeLast();
        }
        LinkedHashSet<String> savedHistory = new LinkedHashSet<String>(searchHistory.size());
        for (SearchSetting item : searchHistory) {
            savedHistory.add(item.writeToString());
        }
        Main.pref.putCollection("search.history", savedHistory);
    }

    public static List<String> getSearchExpressionHistory() {
        ArrayList<String> ret = new ArrayList<String>(SearchAction.getSearchHistory().size());
        for (SearchSetting ss : SearchAction.getSearchHistory()) {
            ret.add(ss.text);
        }
        return ret;
    }

    public SearchAction() {
        super(I18n.tr("Search...", new Object[0]), "dialogs/search", I18n.tr("Search for objects.", new Object[0]), Shortcut.registerShortcut("system:find", I18n.tr("Search...", new Object[0]), 70, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Search"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        SearchAction.search();
    }

    @Override
    public void actionPerformed(ActionEvent e, Map<String, Object> parameters) {
        if (parameters.get("searchExpression") == null) {
            this.actionPerformed(e);
        } else {
            SearchAction.searchWithoutHistory((SearchSetting)parameters.get("searchExpression"));
        }
    }

    public static SearchSetting showSearchDialog(SearchSetting initialValues) {
        JPanel right;
        if (initialValues == null) {
            initialValues = new SearchSetting();
        }
        JLabel label = new JLabel(initialValues instanceof Filter ? I18n.tr("Filter string:", new Object[0]) : I18n.tr("Search string:", new Object[0]));
        final HistoryComboBox hcbSearchString = new HistoryComboBox();
        hcbSearchString.setText(initialValues.text);
        hcbSearchString.setToolTipText(I18n.tr("Enter the search expression", new Object[0]));
        List<String> searchExpressionHistory = SearchAction.getSearchExpressionHistory();
        Collections.reverse(searchExpressionHistory);
        hcbSearchString.setPossibleItems(searchExpressionHistory);
        hcbSearchString.setPreferredSize(new Dimension(40, hcbSearchString.getPreferredSize().height));
        JRadioButton replace = new JRadioButton(I18n.tr("replace selection", new Object[0]), initialValues.mode == SearchMode.replace);
        JRadioButton add = new JRadioButton(I18n.tr("add to selection", new Object[0]), initialValues.mode == SearchMode.add);
        JRadioButton remove = new JRadioButton(I18n.tr("remove from selection", new Object[0]), initialValues.mode == SearchMode.remove);
        JRadioButton in_selection = new JRadioButton(I18n.tr("find in selection", new Object[0]), initialValues.mode == SearchMode.in_selection);
        ButtonGroup bg = new ButtonGroup();
        bg.add(replace);
        bg.add(add);
        bg.add(remove);
        bg.add(in_selection);
        final JCheckBox caseSensitive = new JCheckBox(I18n.tr("case sensitive", new Object[0]), initialValues.caseSensitive);
        JCheckBox allElements = new JCheckBox(I18n.tr("all objects", new Object[0]), initialValues.allElements);
        allElements.setToolTipText(I18n.tr("Also include incomplete and deleted objects in search.", new Object[0]));
        final JCheckBox regexSearch = new JCheckBox(I18n.tr("regular expression", new Object[0]), initialValues.regexSearch);
        JCheckBox addOnToolbar = new JCheckBox(I18n.tr("add toolbar button", new Object[0]), false);
        JPanel top = new JPanel(new GridBagLayout());
        top.add((Component)label, GBC.std().insets(0, 0, 5, 0));
        top.add((Component)hcbSearchString, GBC.eol().fill(2));
        JPanel left = new JPanel(new GridBagLayout());
        left.add((Component)replace, GBC.eol());
        left.add((Component)add, GBC.eol());
        left.add((Component)remove, GBC.eol());
        left.add((Component)in_selection, GBC.eop());
        left.add((Component)caseSensitive, GBC.eol());
        if (Main.pref.getBoolean("expert", false)) {
            left.add((Component)allElements, GBC.eol());
            left.add((Component)regexSearch, GBC.eol());
            left.add((Component)addOnToolbar, GBC.eol());
        }
        if (Main.pref.getBoolean("dialog.search.new", true)) {
            right = new JPanel(new GridBagLayout());
            SearchAction.buildHintsNew(right, hcbSearchString);
        } else {
            right = new JPanel();
            SearchAction.buildHints(right);
        }
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)top, GBC.eol().fill(2).insets(5, 5, 5, 0));
        p.add((Component)left, GBC.std().anchor(11).insets(5, 10, 10, 0));
        p.add((Component)right, GBC.eol());
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, initialValues instanceof Filter ? I18n.tr("Filter", new Object[0]) : I18n.tr("Search", new Object[0]), new String[]{initialValues instanceof Filter ? I18n.tr("Submit filter", new Object[0]) : I18n.tr("Start Search", new Object[0]), I18n.tr("Cancel", new Object[0])}){

            @Override
            protected void buttonAction(int buttonIndex, ActionEvent evt) {
                if (buttonIndex == 0) {
                    try {
                        SearchCompiler.compile(hcbSearchString.getText(), caseSensitive.isSelected(), regexSearch.isSelected());
                        super.buttonAction(buttonIndex, evt);
                    }
                    catch (SearchCompiler.ParseError e) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Search expression is not valid: \n\n {0}", e.getMessage()), I18n.tr("Invalid search expression", new Object[0]), 0);
                    }
                } else {
                    super.buttonAction(buttonIndex, evt);
                }
            }
        };
        dialog.setButtonIcons(new String[]{"dialogs/search", "cancel"});
        dialog.configureContextsensitiveHelp("/Action/Search", true);
        dialog.setContent(p);
        dialog.showDialog();
        int result = dialog.getValue();
        if (result != 1) {
            return null;
        }
        SearchMode mode = replace.isSelected() ? SearchMode.replace : (add.isSelected() ? SearchMode.add : (remove.isSelected() ? SearchMode.remove : SearchMode.in_selection));
        initialValues.text = hcbSearchString.getText();
        initialValues.mode = mode;
        initialValues.caseSensitive = caseSensitive.isSelected();
        initialValues.allElements = allElements.isSelected();
        initialValues.regexSearch = regexSearch.isSelected();
        if (addOnToolbar.isSelected()) {
            ToolbarPreferences.ActionDefinition aDef = new ToolbarPreferences.ActionDefinition(Main.main.menu.search);
            aDef.getParameters().put("searchExpression", initialValues);
            aDef.setName(Utils.shortenString(initialValues.text, 100));
            ToolbarPreferences.ActionParser actionParser = new ToolbarPreferences.ActionParser(null);
            String res = actionParser.saveAction(aDef);
            Main.toolbar.addCustomButton(res, -1, false);
        }
        return initialValues;
    }

    private static void buildHints(JPanel right) {
        DescriptionTextBuilder descriptionText = new DescriptionTextBuilder();
        descriptionText.append("<html><style>li.header{font-size:110%; list-style-type:none; margin-top:5px;}</style><ul>");
        descriptionText.appendItem(I18n.tr("<b>Baker Street</b> - ''Baker'' and ''Street'' in any key", new Object[0]));
        descriptionText.appendItem(I18n.tr("<b>\"Baker Street\"</b> - ''Baker Street'' in any key", new Object[0]));
        descriptionText.appendItem(I18n.tr("<b>key:Bak</b> - ''Bak'' anywhere in the key ''key''", new Object[0]));
        descriptionText.appendItem(I18n.tr("<b>-key:Bak</b> - ''Bak'' nowhere in the key ''key''", new Object[0]));
        descriptionText.appendItem(I18n.tr("<b>key=value</b> - key ''key'' with value exactly ''value''", new Object[0]));
        descriptionText.appendItem(I18n.tr("<b>key=*</b> - key ''key'' with any value. Try also <b>*=value</b>, <b>key=</b>, <b>*=*</b>, <b>*=</b>", new Object[0]));
        descriptionText.appendItem(I18n.tr("<b>key:</b> - key ''key'' set to any value", new Object[0]));
        descriptionText.appendItem(I18n.tr("<b>key?</b> - key ''key'' with the value ''yes'', ''true'', ''1'' or ''on''", new Object[0]));
        if (Main.pref.getBoolean("expert", false)) {
            descriptionText.appendItemHeader(I18n.tr("Special targets", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>type:</b>... - objects with corresponding type (<b>node</b>, <b>way</b>, <b>relation</b>)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>user:</b>... - objects changed by user", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>user:anonymous</b> - objects changed by anonymous users", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>id:</b>... - objects with given ID (0 for new objects)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>version:</b>... - objects with given version (0 objects without an assigned version)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>changeset:</b>... - objects with given changeset ID (0 objects without an assigned changeset)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>nodes:</b>... - objects with given number of nodes (<b>nodes:</b>count, <b>nodes:</b>min-max, <b>nodes:</b>min- or <b>nodes:</b>-max)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>tags:</b>... - objects with given number of tags (<b>tags:</b>count, <b>tags:</b>min-max, <b>tags:</b>min- or <b>tags:</b>-max)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>role:</b>... - objects with given role in a relation", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>timestamp:</b>timestamp - objects with this last modification timestamp (2009-11-12T14:51:09Z, 2009-11-12 or T14:51 ...)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>timestamp:</b>min/max - objects with last modification within range", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>areasize:</b>... - closed ways with given area in m\u00b2 (<b>areasize:</b>min-max or <b>areasize:</b>max)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>modified</b> - all changed objects", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>selected</b> - all selected objects", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>incomplete</b> - all incomplete objects", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>untagged</b> - all untagged objects", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>closed</b> - all closed ways (a node is not considered closed)", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>child <i>expr</i></b> - all children of objects matching the expression", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>parent <i>expr</i></b> - all parents of objects matching the expression", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>(all)indownloadedarea</b> - objects (and all its way nodes / relation members) in downloaded area", new Object[0]));
            descriptionText.appendItem(I18n.tr("<b>(all)inview</b> - objects (and all its way nodes / relation members) in current view", new Object[0]));
        }
        descriptionText.appendItem(I18n.tr("Use <b>|</b> or <b>OR</b> to combine with logical or", new Object[0]));
        descriptionText.appendItem(I18n.tr("Use <b>\"</b> to quote operators (e.g. if key contains <b>:</b>)", new Object[0]) + "<br/>" + I18n.tr("Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).", new Object[0]));
        descriptionText.appendItem(I18n.tr("Use <b>(</b> and <b>)</b> to group expressions", new Object[0]));
        descriptionText.append("</ul></html>");
        JLabel description = new JLabel(descriptionText.toString());
        description.setFont(description.getFont().deriveFont(0));
        right.add(description);
    }

    private static void buildHintsNew(JPanel right, HistoryComboBox hcbSearchString) {
        right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("basic examples", new Object[0])).addKeyword(I18n.tr("Baker Street", new Object[0]), null, I18n.tr("''Baker'' and ''Street'' in any key", new Object[0]), new String[0]).addKeyword(I18n.tr("\"Baker Street\"", new Object[0]), "\"\"", I18n.tr("''Baker Street'' in any key", new Object[0]), new String[0]), GBC.eol());
        right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("basics", new Object[0])).addKeyword("<i>key</i>:<i>valuefragment</i>", null, I18n.tr("''valuefragment'' anywhere in ''key''", new Object[0]), "name:str matches name=Bakerstreet").addKeyword("-<i>key</i>:<i>valuefragment</i>", null, I18n.tr("''valuefragment'' nowhere in ''key''", new Object[0]), new String[0]).addKeyword("<i>key</i>=<i>value</i>", null, I18n.tr("''key'' with exactly ''value''", new Object[0]), new String[0]).addKeyword("<i>key</i>=*", null, I18n.tr("''key'' with any value", new Object[0]), new String[0]).addKeyword("*=<i>value</i>", null, I18n.tr("''value'' in any key", new Object[0]), new String[0]).addKeyword("<i>key</i>=", null, I18n.tr("matches if ''key'' exists", new Object[0]), new String[0]).addKeyword("<i>key</i>><i>value</i>", null, I18n.tr("matches if ''key'' is greater than ''value'' (analogously, less than)", new Object[0]), new String[0]), GBC.eol());
        right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("combinators", new Object[0])).addKeyword("<i>expr</i> <i>expr</i>", null, I18n.tr("logical and (both expressions have to be satisfied)", new Object[0]), new String[0]).addKeyword("<i>expr</i> | <i>expr</i>", "| ", I18n.tr("logical or (at least one expression has to be satisfied)", new Object[0]), new String[0]).addKeyword("<i>expr</i> OR <i>expr</i>", "OR ", I18n.tr("logical or (at least one expression has to be satisfied)", new Object[0]), new String[0]).addKeyword("-<i>expr</i>", null, I18n.tr("logical not", new Object[0]), new String[0]).addKeyword("(<i>expr</i>)", "()", I18n.tr("use parenthesis to group expressions", new Object[0]), new String[0]).addKeyword("\"key\"=\"value\"", "\"\"=\"\"", I18n.tr("to quote operators.<br>Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).", new Object[0]), "\"addr:street\""), GBC.eol());
        if (Main.pref.getBoolean("expert", false)) {
            right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("objects", new Object[0])).addKeyword("type:node", "type:node ", I18n.tr("all ways", new Object[0]), new String[0]).addKeyword("type:way", "type:way ", I18n.tr("all ways", new Object[0]), new String[0]).addKeyword("type:relation", "type:relation ", I18n.tr("all relations", new Object[0]), new String[0]).addKeyword("closed", "closed ", I18n.tr("all closed ways", new Object[0]), new String[0]).addKeyword("untagged", "untagged ", I18n.tr("object without useful tags", new Object[0]), new String[0]), GBC.eol());
            right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("metadata", new Object[0])).addKeyword("user:", "user:", I18n.tr("objects changed by user", "user:anonymous"), new String[0]).addKeyword("id:", "id:", I18n.tr("objects with given ID", new Object[0]), "id:0 (new objects)").addKeyword("version:", "version:", I18n.tr("objects with given version", new Object[0]), "version:0 (objects without an assigned version)").addKeyword("changeset:", "changeset:", I18n.tr("objects with given changeset ID", new Object[0]), "changeset:0 (objects without an assigned changeset)").addKeyword("timestamp:", "timestamp:", I18n.tr("objects with last modification timestamp within range", new Object[0]), "timestamp:2012/", "timestamp:2008/2011-02-04T12"), GBC.eol());
            right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("properties", new Object[0])).addKeyword("nodes:<i>20-</i>", "nodes:", I18n.tr("objects with at least 20 nodes", new Object[0]), new String[0]).addKeyword("tags:<i>5-10</i>", "tags:", I18n.tr("objects having 5 to 10 tags", new Object[0]), new String[0]).addKeyword("role:", "role:", I18n.tr("objects with given role in a relation", new Object[0]), new String[0]).addKeyword("areasize:<i>-100</i>", "areasize:", I18n.tr("closed ways with an area of 100 m\u00b2", new Object[0]), new String[0]), GBC.eol());
            right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("state", new Object[0])).addKeyword("modified", "modified ", I18n.tr("all modified objects", new Object[0]), new String[0]).addKeyword("new", "new ", I18n.tr("all new objects", new Object[0]), new String[0]).addKeyword("selected", "selected ", I18n.tr("all selected objects", new Object[0]), new String[0]).addKeyword("incomplete", "incomplete ", I18n.tr("all incomplete objects", new Object[0]), new String[0]), GBC.eol());
            right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("related objects", new Object[0])).addKeyword("child <i>expr</i>", "child ", I18n.tr("all children of objects matching the expression", new Object[0]), "child building").addKeyword("parent <i>expr</i>", "parent ", I18n.tr("all parents of objects matching the expression", new Object[0]), "parent bus_stop").addKeyword("nth:<i>7</i>", "nth: ", I18n.tr("n-th member of relation and/or n-th node of way", new Object[0]), "nth:5 (child type:relation)").addKeyword("nth%:<i>7</i>", "nth%: ", I18n.tr("every n-th member of relation and/or every n-th node of way", new Object[0]), "nth%:100 (child waterway)"), GBC.eol());
            right.add((Component)new SearchKeywordRow(hcbSearchString).addTitle(I18n.tr("view", new Object[0])).addKeyword("inview", "inview ", I18n.tr("objects in current view", new Object[0]), new String[0]).addKeyword("allinview", "allinview ", I18n.tr("objects (and all its way nodes / relation members) in current view", new Object[0]), new String[0]).addKeyword("indownloadedarea", "indownloadedarea ", I18n.tr("objects in downloaded area", new Object[0]), new String[0]).addKeyword("allindownloadedarea", "allindownloadedarea ", I18n.tr("objects (and all its way nodes / relation members) in downloaded area", new Object[0]), new String[0]), GBC.eol());
        }
    }

    public static void search() {
        SearchSetting se = SearchAction.showSearchDialog(lastSearch);
        if (se != null) {
            SearchAction.searchWithHistory(se);
        }
    }

    public static void searchWithHistory(SearchSetting s) {
        SearchAction.saveToHistory(s);
        lastSearch = new SearchSetting(s);
        SearchAction.search(s);
    }

    public static void searchWithoutHistory(SearchSetting s) {
        lastSearch = new SearchSetting(s);
        SearchAction.search(s);
    }

    public static int getSelection(SearchSetting s, Collection<OsmPrimitive> sel, Predicate<OsmPrimitive> p) {
        int foundMatches = 0;
        try {
            String searchText = s.text;
            SearchCompiler.Match matcher = SearchCompiler.compile(searchText, s.caseSensitive, s.regexSearch);
            if (s.mode == SearchMode.replace) {
                sel.clear();
            } else if (s.mode == SearchMode.in_selection) {
                foundMatches = sel.size();
            }
            Collection<OsmPrimitive> all = s.allElements ? Main.main.getCurrentDataSet().allPrimitives() : Main.main.getCurrentDataSet().allNonDeletedCompletePrimitives();
            for (OsmPrimitive osm : all) {
                if (s.mode == SearchMode.replace) {
                    if (!matcher.match(osm)) continue;
                    sel.add(osm);
                    ++foundMatches;
                    continue;
                }
                if (s.mode == SearchMode.add && !p.evaluate(osm) && matcher.match(osm)) {
                    sel.add(osm);
                    ++foundMatches;
                    continue;
                }
                if (s.mode == SearchMode.remove && p.evaluate(osm) && matcher.match(osm)) {
                    sel.remove(osm);
                    ++foundMatches;
                    continue;
                }
                if (s.mode != SearchMode.in_selection || !p.evaluate(osm) || matcher.match(osm)) continue;
                sel.remove(osm);
                --foundMatches;
            }
        }
        catch (SearchCompiler.ParseError e) {
            JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
        return foundMatches;
    }

    public static void getSelection(SearchSetting s, Collection<OsmPrimitive> all, Property<OsmPrimitive, Boolean> p) {
        try {
            String searchText = s.text;
            if (s instanceof Filter && ((Filter)s).inverted) {
                searchText = String.format("-(%s)", searchText);
            }
            SearchCompiler.Match matcher = SearchCompiler.compile(searchText, s.caseSensitive, s.regexSearch);
            for (OsmPrimitive osm : all) {
                if (s.mode == SearchMode.replace) {
                    if (matcher.match(osm)) {
                        p.set(osm, true);
                        continue;
                    }
                    p.set(osm, false);
                    continue;
                }
                if (s.mode == SearchMode.add && !p.get(osm).booleanValue() && matcher.match(osm)) {
                    p.set(osm, true);
                    continue;
                }
                if (s.mode == SearchMode.remove && p.get(osm).booleanValue() && matcher.match(osm)) {
                    p.set(osm, false);
                    continue;
                }
                if (s.mode != SearchMode.in_selection || !p.get(osm).booleanValue() || matcher.match(osm)) continue;
                p.set(osm, false);
            }
        }
        catch (SearchCompiler.ParseError e) {
            JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
    }

    public static void search(String search, SearchMode mode) {
        SearchAction.search(new SearchSetting(search, mode, false, false, false));
    }

    public static void search(SearchSetting s) {
        final DataSet ds = Main.main.getCurrentDataSet();
        HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>(ds.getAllSelected());
        int foundMatches = SearchAction.getSelection(s, sel, new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive o) {
                return ds.isSelected(o);
            }
        });
        ds.setSelected(sel);
        if (foundMatches == 0) {
            String msg = null;
            String text = Utils.shortenString(s.text, 100);
            if (s.mode == SearchMode.replace) {
                msg = I18n.tr("No match found for ''{0}''", text);
            } else if (s.mode == SearchMode.add) {
                msg = I18n.tr("Nothing added to selection by searching for ''{0}''", text);
            } else if (s.mode == SearchMode.remove) {
                msg = I18n.tr("Nothing removed from selection by searching for ''{0}''", text);
            } else if (s.mode == SearchMode.in_selection) {
                msg = I18n.tr("Nothing found in selection by searching for ''{0}''", text);
            }
            Main.map.statusLine.setHelpText(msg);
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Warning", new Object[0]), 2);
        } else {
            Main.map.statusLine.setHelpText(I18n.tr("Found {0} matches", foundMatches));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(SearchAction.getEditLayer() != null);
    }

    @Override
    public List<ActionParameter<?>> getActionParameters() {
        return Collections.singletonList(new ActionParameter.SearchSettingsActionParameter("searchExpression"));
    }

    public static String escapeStringForSearch(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    static {
        for (String s : Main.pref.getCollection("search.history", Collections.emptyList())) {
            SearchSetting ss = SearchSetting.readFromString(s);
            if (ss == null) continue;
            searchHistory.add(ss);
        }
        lastSearch = null;
    }

    public static class SearchSetting {
        public String text;
        public SearchMode mode;
        public boolean caseSensitive;
        public boolean regexSearch;
        public boolean allElements;

        public SearchSetting() {
            this("", SearchMode.replace, false, false, false);
        }

        public SearchSetting(String text, SearchMode mode, boolean caseSensitive, boolean regexSearch, boolean allElements) {
            this.caseSensitive = caseSensitive;
            this.regexSearch = regexSearch;
            this.allElements = allElements;
            this.mode = mode;
            this.text = text;
        }

        public SearchSetting(SearchSetting original) {
            this(original.text, original.mode, original.caseSensitive, original.regexSearch, original.allElements);
        }

        public String toString() {
            String cs = this.caseSensitive ? I18n.trc("search", "CS") : I18n.trc("search", "CI");
            String rx = this.regexSearch ? ", " + I18n.trc("search", "RX") : "";
            String all = this.allElements ? ", " + I18n.trc("search", "A") : "";
            return "\"" + this.text + "\" (" + cs + rx + all + ", " + (Object)((Object)this.mode) + ")";
        }

        public boolean equals(Object other) {
            if (!(other instanceof SearchSetting)) {
                return false;
            }
            SearchSetting o = (SearchSetting)other;
            return o.caseSensitive == this.caseSensitive && o.regexSearch == this.regexSearch && o.allElements == this.allElements && o.mode.equals((Object)this.mode) && o.text.equals(this.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public static SearchSetting readFromString(String s) {
            if (s.length() == 0) {
                return null;
            }
            SearchSetting result = new SearchSetting();
            int index = 1;
            result.mode = SearchMode.fromCode(s.charAt(0));
            if (result.mode == null) {
                result.mode = SearchMode.replace;
                index = 0;
            }
            while (index < s.length()) {
                if (s.charAt(index) == 'C') {
                    result.caseSensitive = true;
                } else if (s.charAt(index) == 'R') {
                    result.regexSearch = true;
                } else if (s.charAt(index) == 'A') {
                    result.allElements = true;
                } else {
                    if (s.charAt(index) == ' ') break;
                    Main.warn("Unknown char in SearchSettings: " + s);
                    break;
                }
                ++index;
            }
            if (index < s.length() && s.charAt(index) == ' ') {
                ++index;
            }
            result.text = s.substring(index);
            return result;
        }

        public String writeToString() {
            if (this.text == null || this.text.length() == 0) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            result.append(this.mode.getCode());
            if (this.caseSensitive) {
                result.append('C');
            }
            if (this.regexSearch) {
                result.append('R');
            }
            if (this.allElements) {
                result.append('A');
            }
            result.append(' ');
            result.append(this.text);
            return result.toString();
        }
    }

    private static class SearchKeywordRow
    extends JPanel {
        private final HistoryComboBox hcb;

        public SearchKeywordRow(HistoryComboBox hcb) {
            super(new FlowLayout(0));
            this.hcb = hcb;
        }

        public SearchKeywordRow addTitle(String title) {
            this.add(new JLabel(I18n.tr("{0}: ", title)));
            return this;
        }

        public SearchKeywordRow addKeyword(String displayText, final String insertText, String description, String ... examples) {
            JLabel label = new JLabel("<html><style>td{border:1px solid gray; font-weight:normal;}</style><table><tr><td>" + displayText + "</td></tr></table></html>");
            this.add(label);
            if (description != null || examples.length > 0) {
                label.setToolTipText("<html>" + description + (examples.length > 0 ? Utils.joinAsHtmlUnorderedList(Arrays.asList(examples)) : "") + "</html>");
            }
            if (insertText != null) {
                label.setCursor(Cursor.getPredefinedCursor(12));
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            JTextComponent tf = (JTextComponent)SearchKeywordRow.this.hcb.getEditor().getEditorComponent();
                            tf.getDocument().insertString(tf.getCaretPosition(), " " + insertText, null);
                        }
                        catch (BadLocationException ex) {
                            throw new RuntimeException(ex.getMessage(), ex);
                        }
                    }
                });
            }
            return this;
        }
    }

    private static class DescriptionTextBuilder {
        StringBuilder s = new StringBuilder(4096);

        private DescriptionTextBuilder() {
        }

        public StringBuilder append(String string) {
            return this.s.append(string);
        }

        StringBuilder appendItem(String item) {
            return this.append("<li>").append(item).append("</li>\n");
        }

        StringBuilder appendItemHeader(String itemHeader) {
            return this.append("<li class=\"header\">").append(itemHeader).append("</li>\n");
        }

        public String toString() {
            return this.s.toString();
        }
    }

    public static enum SearchMode {
        replace('R'),
        add('A'),
        remove('D'),
        in_selection('S');

        private final char code;

        private SearchMode(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }

        public static SearchMode fromCode(char code) {
            for (SearchMode mode : SearchMode.values()) {
                if (mode.getCode() != code) continue;
                return mode;
            }
            return null;
        }
    }
}

