/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class EditRelationAction
extends AbstractRelationAction {
    public EditRelationAction() {
        this.putValue("Name", I18n.tr("Edit", new Object[0]));
        this.putValue("ShortDescription", I18n.tr("Call relation editor for selected relation", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
    }

    public static Set<RelationMember> getMembersForCurrentSelection(Relation r) {
        OsmDataLayer editLayer;
        HashSet<RelationMember> members = new HashSet<RelationMember>();
        if (Main.isDisplayingMapView() && (editLayer = Main.main.getEditLayer()) != null && editLayer.data != null) {
            Collection<OsmPrimitive> selection = editLayer.data.getSelected();
            for (RelationMember member : r.getMembers()) {
                if (!selection.contains(member.getMember())) continue;
                members.add(member);
            }
        }
        return members;
    }

    public static void launchEditor(Relation toEdit) {
        if (toEdit == null || toEdit.isDeleted() || !Main.isDisplayingMapView()) {
            return;
        }
        RelationEditor.getEditor(Main.main.getEditLayer(), toEdit, EditRelationAction.getMembersForCurrentSelection(toEdit)).setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || this.relations.isEmpty()) {
            return;
        }
        if (this.relations.size() > Main.pref.getInteger("warn.open.maxrelations", 5) && 0 != JOptionPane.showConfirmDialog(Main.parent, "<html>" + I18n.trn("You are about to open <b>{0}</b> different relation editor simultaneously.<br/>Do you want to continue?", "You are about to open <b>{0}</b> different relation editors simultaneously.<br/>Do you want to continue?", this.relations.size(), this.relations.size()) + "</html>", I18n.tr("Confirmation", new Object[0]), 2, 2)) {
            return;
        }
        for (Relation r : this.relations) {
            EditRelationAction.launchEditor(r);
        }
    }

    @Override
    protected void updateEnabledState() {
        boolean enabled = false;
        for (Relation r : this.relations) {
            if (r.isDeleted()) continue;
            enabled = true;
            break;
        }
        this.setEnabled(enabled);
    }
}

