/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RotateCommand;
import org.openstreetmap.josm.command.ScaleCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.WireframeMapRenderer;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectAction
extends MapMode
implements SelectionManager.SelectionEnded,
KeyPressReleaseListener,
ModifierListener {
    private boolean lassoMode = false;
    public boolean repeatedKeySwitchLassoOption;
    private MouseEvent oldEvent = null;
    private Mode mode = null;
    private final SelectionManager selectionManager;
    private boolean cancelDrawMode = false;
    private boolean drawTargetHighlight;
    private boolean didMouseDrag = false;
    private final MapView mv;
    private Point startingDraggingPos;
    EastNorth startEN;
    private Point lastMousePos;
    private long mouseDownTime = 0L;
    private int mouseDownButton = 0;
    private long mouseReleaseTime = 0L;
    private int initialMoveDelay;
    private int initialMoveThreshold;
    private boolean initialMoveThresholdExceeded = false;
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    CycleManager cycleManager = new CycleManager();
    VirtualManager virtualManager = new VirtualManager();

    public SelectAction(MapFrame mapFrame) {
        super(I18n.tr("Select", new Object[0]), "move/move", I18n.tr("Select, move, scale and rotate objects", new Object[0]), Shortcut.registerShortcut("mapmode:select", I18n.tr("Mode: {0}", I18n.tr("Select", new Object[0])), 83, 5003), mapFrame, ImageProvider.getCursor("normal", "selection"));
        this.mv = mapFrame.mapView;
        this.putValue("help", HelpUtil.ht("/Action/Select"));
        this.selectionManager = new SelectionManager(this, false, this.mv);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Main.pref.getInteger("edit.initial-move-threshold", 5);
        this.repeatedKeySwitchLassoOption = Main.pref.getBoolean("mappaint.select.toggle-lasso-on-repeated-S", true);
        this.cycleManager.init();
        this.virtualManager.init();
        Main.map.keyDetector.addModifierListener(this);
        Main.map.keyDetector.addKeyListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(this.mv);
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(false);
        Main.map.keyDetector.removeModifierListener(this);
        Main.map.keyDetector.removeKeyListener(this);
        this.removeHighlighting();
    }

    @Override
    public void modifiersChanged(int modifiers) {
        if (!Main.isDisplayingMapView() || this.oldEvent == null) {
            return;
        }
        if (this.giveUserFeedback(this.oldEvent, modifiers)) {
            this.mv.repaint();
        }
    }

    private boolean giveUserFeedback(MouseEvent e) {
        return this.giveUserFeedback(e, e.getModifiers());
    }

    private boolean giveUserFeedback(MouseEvent e, int modifiers) {
        Collection<OsmPrimitive> c = SelectAction.asColl(this.mv.getNearestNodeOrWay(e.getPoint(), this.mv.isSelectablePredicate, true));
        this.updateKeyModifiers(modifiers);
        this.determineMapMode(!c.isEmpty());
        HashSet<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
        this.virtualManager.clear();
        if (this.mode == Mode.MOVE && !this.dragInProgress() && this.virtualManager.activateVirtualNodeNearPoint(e.getPoint())) {
            DataSet ds = SelectAction.getCurrentDataSet();
            if (ds != null && this.drawTargetHighlight) {
                ds.setHighlightedVirtualNodes(this.virtualManager.virtualWays);
            }
            this.mv.setNewCursor(SelectActionCursor.virtual_node.cursor(), (Object)this);
            return this.repaintIfRequired(newHighlights);
        }
        this.mv.setNewCursor(this.getCursor(c), (Object)this);
        if (!this.drawTargetHighlight || this.mode != Mode.MOVE || c.isEmpty()) {
            return this.repaintIfRequired(newHighlights);
        }
        boolean isToggleMode = this.ctrl && !this.dragInProgress();
        for (OsmPrimitive x : c) {
            if (!isToggleMode && x.isSelected()) continue;
            newHighlights.add(x);
        }
        return this.repaintIfRequired(newHighlights);
    }

    private Cursor getCursor(Collection<OsmPrimitive> nearbyStuff) {
        String c = "rect";
        switch (this.mode) {
            case MOVE: {
                OsmPrimitive osm;
                if (this.virtualManager.hasVirtualNode()) {
                    c = "virtual_node";
                    break;
                }
                Iterator<OsmPrimitive> it = nearbyStuff.iterator();
                OsmPrimitive osmPrimitive = osm = it.hasNext() ? it.next() : null;
                if (this.dragInProgress()) {
                    if (!this.ctrl || SelectAction.getCurrentDataSet().getSelectedNodes().isEmpty()) {
                        c = "move";
                        break;
                    }
                    boolean hasTarget = osm instanceof Node && !osm.isSelected();
                    c = hasTarget ? "merge_to_node" : "merge";
                    break;
                }
                c = osm instanceof Node ? "node" : c;
                String string = c = osm instanceof Way ? "way" : c;
                if (this.shift) {
                    c = c + "_add";
                    break;
                }
                if (!this.ctrl) break;
                c = c + (osm == null || osm.isSelected() ? "_rm" : "_add");
                break;
            }
            case ROTATE: {
                c = "rotate";
                break;
            }
            case SCALE: {
                c = "scale";
                break;
            }
            case SELECT: {
                c = this.lassoMode ? "lasso" : "rect" + (this.shift ? "_add" : (this.ctrl && !Main.isPlatformOsx() ? "_rm" : ""));
            }
        }
        return SelectActionCursor.valueOf(c).cursor();
    }

    private boolean removeHighlighting() {
        boolean needsRepaint = false;
        DataSet ds = SelectAction.getCurrentDataSet();
        if (ds != null && !ds.getHighlightedVirtualNodes().isEmpty()) {
            needsRepaint = true;
            ds.clearHighlightedVirtualNodes();
        }
        if (this.oldHighlights.isEmpty()) {
            return needsRepaint;
        }
        for (OsmPrimitive prim : this.oldHighlights) {
            prim.setHighlighted(false);
        }
        this.oldHighlights = new HashSet<OsmPrimitive>();
        return true;
    }

    private boolean repaintIfRequired(Set<OsmPrimitive> newHighlights) {
        if (!this.drawTargetHighlight) {
            return false;
        }
        boolean needsRepaint = false;
        for (OsmPrimitive x : newHighlights) {
            if (this.oldHighlights.contains(x)) continue;
            needsRepaint = true;
            x.setHighlighted(true);
        }
        this.oldHighlights.removeAll(newHighlights);
        for (OsmPrimitive x : this.oldHighlights) {
            x.setHighlighted(false);
            needsRepaint = true;
        }
        this.oldHighlights = newHighlights;
        return needsRepaint;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDownButton = e.getButton();
        if (!this.mv.isActiveLayerVisible() || !((Boolean)this.getValue("active")).booleanValue() || this.mouseDownButton != 1) {
            return;
        }
        this.mv.requestFocus();
        this.updateKeyModifiers(e);
        this.cancelDrawMode = this.shift || this.ctrl;
        this.didMouseDrag = false;
        this.initialMoveThresholdExceeded = false;
        this.mouseDownTime = System.currentTimeMillis();
        this.lastMousePos = e.getPoint();
        this.startEN = this.mv.getEastNorth(this.lastMousePos.x, this.lastMousePos.y);
        OsmPrimitive nearestPrimitive = this.mv.getNearestNodeOrWay(e.getPoint(), this.mv.isSelectablePredicate, true);
        this.determineMapMode(nearestPrimitive != null);
        switch (this.mode) {
            case ROTATE: 
            case SCALE: {
                if (!SelectAction.getCurrentDataSet().getSelected().isEmpty()) break;
                SelectAction.getCurrentDataSet().setSelected(SelectAction.asColl(nearestPrimitive));
                break;
            }
            case MOVE: {
                if (!this.cancelDrawMode && nearestPrimitive instanceof Way) {
                    this.virtualManager.activateVirtualNodeNearPoint(e.getPoint());
                }
                OsmPrimitive toSelect = this.cycleManager.cycleSetup(nearestPrimitive, e.getPoint());
                this.selectPrims(SelectAction.asColl(toSelect), false, false);
                this.useLastMoveCommandIfPossible();
                GuiHelper.scheduleTimer(this.initialMoveDelay + 1, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        SelectAction.this.updateStatusLine();
                    }
                }, false);
                break;
            }
            default: {
                if (this.ctrl && Main.isPlatformOsx()) break;
                this.selectionManager.register(this.mv, this.lassoMode);
                this.selectionManager.mousePressed(e);
            }
        }
        if (this.giveUserFeedback(e)) {
            this.mv.repaint();
        }
        this.updateStatusLine();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (Main.isPlatformOsx() && (this.mode == Mode.ROTATE || this.mode == Mode.SCALE)) {
            this.mouseDragged(e);
            return;
        }
        this.oldEvent = e;
        if (this.giveUserFeedback(e)) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        if (this.mouseDownButton == 1 && this.mouseReleaseTime > this.mouseDownTime) {
            return;
        }
        this.cancelDrawMode = true;
        if (this.mode == Mode.SELECT) {
            if (this.ctrl && Main.isPlatformOsx()) {
                this.selectionManager.unregister(this.mv);
                this.mv.requestClearRect();
                this.mv.setNewCursor(13, (Object)this);
            }
            return;
        }
        if (this.mode == Mode.MOVE && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.ROTATE && this.mode != Mode.SCALE && (e.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.MOVE) {
            boolean canMerge = this.ctrl && !SelectAction.getCurrentDataSet().getSelectedNodes().isEmpty();
            Node p = canMerge ? this.findNodeToMergeTo(e.getPoint()) : null;
            boolean needsRepaint = this.removeHighlighting();
            if (p != null) {
                p.setHighlighted(true);
                this.oldHighlights.add(p);
                needsRepaint = true;
            }
            this.mv.setNewCursor(this.getCursor(SelectAction.asColl(p)), (Object)this);
            this.oldEvent = e;
            if (needsRepaint) {
                this.mv.repaint();
            }
        }
        if (this.startingDraggingPos == null) {
            this.startingDraggingPos = new Point(e.getX(), e.getY());
        }
        if (this.lastMousePos == null) {
            this.lastMousePos = e.getPoint();
            return;
        }
        if (!this.initialMoveThresholdExceeded) {
            int dp = (int)this.lastMousePos.distance(e.getX(), e.getY());
            if (dp < this.initialMoveThreshold) {
                return;
            }
            this.initialMoveThresholdExceeded = true;
        }
        if (e.getPoint().equals(this.lastMousePos)) {
            return;
        }
        EastNorth currentEN = this.mv.getEastNorth(e.getX(), e.getY());
        if (this.virtualManager.hasVirtualWaysToBeConstructed()) {
            this.virtualManager.createMiddleNodeFromVirtual(currentEN);
        } else if (!this.updateCommandWhileDragging(currentEN)) {
            return;
        }
        this.mv.repaint();
        if (this.mode != Mode.SCALE) {
            this.lastMousePos = e.getPoint();
        }
        this.didMouseDrag = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.removeHighlighting()) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        this.startingDraggingPos = null;
        this.mouseReleaseTime = System.currentTimeMillis();
        if (this.mode == Mode.SELECT) {
            this.selectionManager.unregister(this.mv);
            if (SelectAction.getCurrentDataSet().getSelected().isEmpty() && !this.cancelDrawMode) {
                Main.map.selectDrawTool(true);
                this.updateStatusLine();
                return;
            }
        }
        if (this.mode == Mode.MOVE && e.getButton() == 1) {
            if (!this.didMouseDrag) {
                this.virtualManager.clear();
                if (this.lastMousePos == null || this.lastMousePos.distanceSq(e.getPoint()) < 100.0) {
                    this.updateKeyModifiers(e);
                    this.selectPrims(this.cycleManager.cyclePrims(), true, false);
                    Collection<OsmPrimitive> c = SelectAction.getCurrentDataSet().getSelected();
                    if (e.getClickCount() >= 2 && c.size() == 1 && c.iterator().next() instanceof Node) {
                        Main.worker.execute(new Runnable(){

                            @Override
                            public void run() {
                                Main.map.selectDrawTool(true);
                            }
                        });
                        return;
                    }
                }
            } else {
                this.confirmOrUndoMovement(e);
            }
        }
        this.mode = null;
        if (e.getButton() == 2) {
            this.removeHighlighting();
        } else {
            this.giveUserFeedback(e);
        }
        this.updateStatusLine();
    }

    @Override
    public void selectionEnded(Rectangle r, MouseEvent e) {
        this.updateKeyModifiers(e);
        this.selectPrims(this.selectionManager.getSelectedObjects(this.alt), true, true);
    }

    @Override
    public void doKeyPressed(KeyEvent e) {
        if (!(Main.isDisplayingMapView() && this.repeatedKeySwitchLassoOption && this.getShortcut().isEvent(e))) {
            return;
        }
        e.consume();
        if (!this.lassoMode) {
            Main.map.selectMapMode(Main.map.mapModeSelectLasso);
        } else {
            Main.map.selectMapMode(Main.map.mapModeSelect);
        }
    }

    @Override
    public void doKeyReleased(KeyEvent e) {
    }

    private void determineMapMode(boolean hasSelectionNearby) {
        this.mode = this.shift && this.ctrl ? Mode.ROTATE : (this.alt && this.ctrl ? Mode.SCALE : (hasSelectionNearby || this.dragInProgress() ? Mode.MOVE : Mode.SELECT));
    }

    private final boolean dragInProgress() {
        return this.didMouseDrag && this.startingDraggingPos != null;
    }

    private boolean updateCommandWhileDragging(EastNorth currentEN) {
        Collection<Node> affectedNodes;
        Collection<OsmPrimitive> selection = SelectAction.getCurrentDataSet().getSelectedNodesAndWays();
        if (selection.isEmpty()) {
            OsmPrimitive nearestPrimitive = this.mv.getNearestNodeOrWay(this.mv.getPoint(this.startEN), this.mv.isSelectablePredicate, true);
            SelectAction.getCurrentDataSet().setSelected(nearestPrimitive);
        }
        if ((affectedNodes = AllNodesVisitor.getAllNodes(selection)).size() < 2 && (this.mode == Mode.ROTATE || this.mode == Mode.SCALE)) {
            return false;
        }
        Command c = this.getLastCommand();
        if (this.mode == Mode.MOVE) {
            if (this.startEN == null) {
                return false;
            }
            SelectAction.getCurrentDataSet().beginUpdate();
            if (c instanceof MoveCommand && affectedNodes.equals(((MoveCommand)c).getParticipatingPrimitives())) {
                ((MoveCommand)c).saveCheckpoint();
                ((MoveCommand)c).applyVectorTo(currentEN);
            } else {
                c = new MoveCommand(selection, this.startEN, currentEN);
                Main.main.undoRedo.add(c);
            }
            for (Node n : affectedNodes) {
                LatLon ll = n.getCoor();
                if (ll == null || !ll.isOutSideWorld()) continue;
                ((MoveCommand)c).resetToCheckpoint();
                SelectAction.getCurrentDataSet().endUpdate();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                this.mv.setNewCursor(this.cursor, (Object)this);
                return false;
            }
        } else {
            this.startEN = currentEN;
            if (this.mode != Mode.ROTATE && this.mode != Mode.SCALE) {
                return false;
            }
            SelectAction.getCurrentDataSet().beginUpdate();
            if (this.mode == Mode.ROTATE) {
                if (c instanceof RotateCommand && affectedNodes.equals(((RotateCommand)c).getTransformedNodes())) {
                    ((RotateCommand)c).handleEvent(currentEN);
                } else {
                    Main.main.undoRedo.add(new RotateCommand(selection, currentEN));
                }
            } else if (this.mode == Mode.SCALE) {
                if (c instanceof ScaleCommand && affectedNodes.equals(((ScaleCommand)c).getTransformedNodes())) {
                    ((ScaleCommand)c).handleEvent(currentEN);
                } else {
                    Main.main.undoRedo.add(new ScaleCommand(selection, currentEN));
                }
            }
            Collection<Way> ways = SelectAction.getCurrentDataSet().getSelectedWays();
            if (this.doesImpactStatusLine(affectedNodes, ways)) {
                Main.map.statusLine.setDist(ways);
            }
        }
        SelectAction.getCurrentDataSet().endUpdate();
        return true;
    }

    private boolean doesImpactStatusLine(Collection<Node> affectedNodes, Collection<Way> selectedWays) {
        for (Way w : selectedWays) {
            for (Node n : w.getNodes()) {
                if (!affectedNodes.contains(n)) continue;
                return true;
            }
        }
        return false;
    }

    private void useLastMoveCommandIfPossible() {
        Command c = this.getLastCommand();
        Collection<Node> affectedNodes = AllNodesVisitor.getAllNodes(SelectAction.getCurrentDataSet().getSelected());
        if (c instanceof MoveCommand && affectedNodes.equals(((MoveCommand)c).getParticipatingPrimitives())) {
            ((MoveCommand)c).changeStartPoint(this.startEN);
        }
    }

    private Command getLastCommand() {
        Command c;
        Command command = c = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
        if (c instanceof SequenceCommand) {
            c = ((SequenceCommand)c).getLastCommand();
        }
        return c;
    }

    private void confirmOrUndoMovement(MouseEvent e) {
        int max;
        int limit = max = Main.pref.getInteger("warn.move.maxelements", 20);
        for (OsmPrimitive osm : SelectAction.getCurrentDataSet().getSelected()) {
            if (osm instanceof Way) {
                limit -= ((Way)osm).getNodes().size();
            }
            if (--limit >= 0) continue;
            break;
        }
        if (limit < 0) {
            ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Move elements", new Object[0]), new String[]{I18n.tr("Move them", new Object[0]), I18n.tr("Undo move", new Object[0])});
            ed.setButtonIcons(new String[]{"reorder", "cancel"});
            ed.setContent(I18n.trn("You moved more than {0} element. Moving a large number of elements is often an error.\nReally move them?", "You moved more than {0} elements. Moving a large number of elements is often an error.\nReally move them?", max, max));
            ed.setCancelButton(2);
            ed.toggleEnable("movedManyElements");
            ed.showDialog();
            if (ed.getValue() != 1) {
                Main.main.undoRedo.undo();
            }
        } else {
            this.updateKeyModifiers(e);
            if (this.ctrl) {
                this.mergePrims(e.getPoint());
            }
        }
        SelectAction.getCurrentDataSet().fireSelectionChanged();
    }

    private final void mergePrims(Point p) {
        Collection<Node> selNodes = SelectAction.getCurrentDataSet().getSelectedNodes();
        if (selNodes.isEmpty()) {
            return;
        }
        Node target = this.findNodeToMergeTo(p);
        if (target == null) {
            return;
        }
        LinkedList<Node> nodesToMerge = new LinkedList<Node>(selNodes);
        nodesToMerge.add(target);
        MergeNodesAction.doMergeNodes(Main.main.getEditLayer(), nodesToMerge, target);
    }

    private final Node findNodeToMergeTo(Point p) {
        List<Node> target = this.mv.getNearestNodes(p, SelectAction.getCurrentDataSet().getSelectedNodes(), this.mv.isSelectablePredicate);
        return target.isEmpty() ? null : (Node)target.iterator().next();
    }

    private void selectPrims(Collection<OsmPrimitive> prims, boolean released, boolean area) {
        DataSet ds = SelectAction.getCurrentDataSet();
        if (ds == null || this.shift && this.ctrl || this.ctrl && !released || this.virtualManager.hasVirtualWaysToBeConstructed() && !released) {
            return;
        }
        if (!released) {
            this.shift |= ds.getSelected().containsAll(prims);
        }
        if (this.ctrl) {
            if (area) {
                ds.clearSelection(prims);
            } else {
                ds.toggleSelected(prims);
            }
        } else if (this.shift) {
            ds.addSelected(prims);
        } else {
            ds.setSelected(prims);
        }
    }

    public final Mode getMode() {
        return this.mode;
    }

    @Override
    public String getModeHelpText() {
        if (this.mouseDownButton == 1 && this.mouseReleaseTime < this.mouseDownTime) {
            if (this.mode == Mode.SELECT) {
                return I18n.tr("Release the mouse button to select the objects in the rectangle.", new Object[0]);
            }
            if (this.mode == Mode.MOVE && System.currentTimeMillis() - this.mouseDownTime >= (long)this.initialMoveDelay) {
                boolean canMerge = SelectAction.getCurrentDataSet() != null && !SelectAction.getCurrentDataSet().getSelectedNodes().isEmpty();
                String mergeHelp = canMerge ? " " + I18n.tr("Ctrl to merge with nearest node.", new Object[0]) : "";
                return I18n.tr("Release the mouse button to stop moving.", new Object[0]) + mergeHelp;
            }
            if (this.mode == Mode.ROTATE) {
                return I18n.tr("Release the mouse button to stop rotating.", new Object[0]);
            }
            if (this.mode == Mode.SCALE) {
                return I18n.tr("Release the mouse button to stop scaling.", new Object[0]);
            }
        }
        return I18n.tr("Move objects by dragging; Shift to add to selection (Ctrl to toggle); Shift-Ctrl to rotate selected; Alt-Ctrl to scale selected; or change selection", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    public void setLassoMode(boolean lassoMode) {
        this.selectionManager.setLassoMode(lassoMode);
        this.lassoMode = lassoMode;
    }

    protected static <T> Collection<T> asColl(T o) {
        if (o == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(o);
    }

    private class VirtualManager {
        private Node virtualNode = null;
        private Collection<WaySegment> virtualWays = new LinkedList<WaySegment>();
        private int nodeVirtualSize;
        private int virtualSnapDistSq2;
        private int virtualSpace;

        private VirtualManager() {
        }

        private void init() {
            this.nodeVirtualSize = Main.pref.getInteger("mappaint.node.virtual-size", 8);
            int virtualSnapDistSq = Main.pref.getInteger("mappaint.node.virtual-snap-distance", 8);
            this.virtualSnapDistSq2 = virtualSnapDistSq * virtualSnapDistSq;
            this.virtualSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        }

        private boolean activateVirtualNodeNearPoint(Point p) {
            if (this.nodeVirtualSize > 0) {
                LinkedList<WaySegment> selVirtualWays = new LinkedList<WaySegment>();
                Pair vnp = null;
                Pair<Object, Object> wnp = new Pair<Object, Object>(null, null);
                Way w = null;
                for (WaySegment ws : SelectAction.this.mv.getNearestWaySegments(p, ((SelectAction)SelectAction.this).mv.isSelectablePredicate)) {
                    Point2D.Double pc;
                    w = ws.way;
                    wnp.a = w.getNode(ws.lowerIndex);
                    Point2D p1 = SelectAction.this.mv.getPoint2D((Node)wnp.a);
                    wnp.b = w.getNode(ws.lowerIndex + 1);
                    Point2D p2 = SelectAction.this.mv.getPoint2D((Node)wnp.b);
                    if (!WireframeMapRenderer.isLargeSegment(p1, p2, this.virtualSpace) || !(p.distanceSq(pc = new Point2D.Double((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0)) < (double)this.virtualSnapDistSq2)) continue;
                    Pair.sort(wnp);
                    if (vnp == null) {
                        vnp = new Pair(wnp.a, wnp.b);
                        this.virtualNode = new Node(SelectAction.this.mv.getLatLon(((Point2D)pc).getX(), ((Point2D)pc).getY()));
                    }
                    if (!vnp.equals(wnp)) continue;
                    (w.isSelected() ? selVirtualWays : this.virtualWays).add(ws);
                }
                if (!selVirtualWays.isEmpty()) {
                    this.virtualWays = selVirtualWays;
                }
            }
            return !this.virtualWays.isEmpty();
        }

        private void createMiddleNodeFromVirtual(EastNorth currentEN) {
            LinkedList<Command> virtualCmds = new LinkedList<Command>();
            virtualCmds.add(new AddCommand(this.virtualNode));
            for (WaySegment virtualWay : this.virtualWays) {
                Way w = virtualWay.way;
                Way wnew = new Way(w);
                wnew.addNode(virtualWay.lowerIndex + 1, this.virtualNode);
                virtualCmds.add(new ChangeCommand(w, wnew));
            }
            virtualCmds.add(new MoveCommand((OsmPrimitive)this.virtualNode, SelectAction.this.startEN, currentEN));
            String text = I18n.trn("Add and move a virtual new node to way", "Add and move a virtual new node to {0} ways", this.virtualWays.size(), this.virtualWays.size());
            Main.main.undoRedo.add(new SequenceCommand(text, virtualCmds));
            SelectAction.getCurrentDataSet().setSelected(Collections.singleton(this.virtualNode));
            this.clear();
        }

        private void clear() {
            this.virtualWays.clear();
            this.virtualNode = null;
        }

        private boolean hasVirtualNode() {
            return this.virtualNode != null;
        }

        private boolean hasVirtualWaysToBeConstructed() {
            return !this.virtualWays.isEmpty();
        }
    }

    private class CycleManager {
        private Collection<OsmPrimitive> cycleList = Collections.emptyList();
        private boolean cyclePrims = false;
        private OsmPrimitive cycleStart = null;
        private boolean waitForMouseUpParameter;
        private boolean multipleMatchesParameter;

        private CycleManager() {
        }

        private void init() {
            this.waitForMouseUpParameter = Main.pref.getBoolean("mappaint.select.waits-for-mouse-up", false);
            this.multipleMatchesParameter = Main.pref.getBoolean("selectaction.cycles.multiple.matches", false);
        }

        private OsmPrimitive cycleSetup(OsmPrimitive nearest, Point p) {
            OsmPrimitive osm = null;
            if (nearest != null) {
                osm = nearest;
                if (!SelectAction.this.alt && !this.multipleMatchesParameter) {
                    this.cycleList = SelectAction.asColl(osm);
                    if (this.waitForMouseUpParameter) {
                        osm = SelectAction.this.mv.getNearestNodeOrWay(p, ((SelectAction)SelectAction.this).mv.isSelectablePredicate, true);
                    }
                } else {
                    this.cycleList = SelectAction.this.mv.getAllNearest(p, ((SelectAction)SelectAction.this).mv.isSelectablePredicate);
                    if (this.cycleList.size() > 1) {
                        this.cyclePrims = false;
                        OsmPrimitive old = osm;
                        for (OsmPrimitive o : this.cycleList) {
                            if (!o.isSelected()) continue;
                            this.cyclePrims = true;
                            osm = o;
                            break;
                        }
                        if (!(this.cycleList.size() != 2 || this.waitForMouseUpParameter || osm.equals(old) || osm.isNew() || SelectAction.this.ctrl)) {
                            this.cyclePrims = false;
                            osm = old;
                        }
                    }
                }
            }
            return osm;
        }

        private Collection<OsmPrimitive> cyclePrims() {
            OsmPrimitive nxt2 = null;
            if (this.cycleList.size() <= 1) {
                return this.cycleList;
            }
            DataSet ds = SelectAction.getCurrentDataSet();
            OsmPrimitive first = this.cycleList.iterator().next();
            OsmPrimitive foundInDS = null;
            nxt2 = first;
            if (this.cyclePrims && SelectAction.this.shift) {
                for (OsmPrimitive nxt2 : this.cycleList) {
                    if (!nxt2.isSelected()) break;
                }
            } else {
                Iterator<OsmPrimitive> i = this.cycleList.iterator();
                while (i.hasNext()) {
                    nxt2 = i.next();
                    if (!nxt2.isSelected()) continue;
                    foundInDS = nxt2;
                    if (!this.cyclePrims && !SelectAction.this.ctrl) break;
                    ds.clearSelection(foundInDS);
                    OsmPrimitive osmPrimitive = nxt2 = i.hasNext() ? i.next() : first;
                    break;
                }
            }
            if (SelectAction.this.ctrl) {
                if (foundInDS != null) {
                    if (!this.cycleList.contains(this.cycleStart)) {
                        ds.clearSelection(this.cycleList);
                        this.cycleStart = foundInDS;
                    } else if (this.cycleStart.equals(nxt2)) {
                        ds.addSelected(nxt2);
                    }
                } else {
                    this.cycleStart = nxt2 = this.cycleList.contains(this.cycleStart) ? this.cycleStart : first;
                }
            } else {
                this.cycleStart = null;
            }
            return SelectAction.asColl(nxt2);
        }
    }

    private static enum SelectActionCursor {
        rect("normal", "selection"),
        rect_add("normal", "select_add"),
        rect_rm("normal", "select_remove"),
        way("normal", "select_way"),
        way_add("normal", "select_way_add"),
        way_rm("normal", "select_way_remove"),
        node("normal", "select_node"),
        node_add("normal", "select_node_add"),
        node_rm("normal", "select_node_remove"),
        virtual_node("normal", "addnode"),
        scale("scale", null),
        rotate("rotate", null),
        merge("crosshair", null),
        lasso("normal", "rope"),
        merge_to_node("crosshair", "joinnode"),
        move(13);

        private final Cursor c;

        private SelectActionCursor(String main, String sub) {
            this.c = ImageProvider.getCursor(main, sub);
        }

        private SelectActionCursor(int systemCursor) {
            this.c = Cursor.getPredefinedCursor(systemCursor);
        }

        public Cursor cursor() {
            return this.c;
        }
    }

    public static enum Mode {
        MOVE,
        ROTATE,
        SCALE,
        SELECT;

    }
}

