/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.ModifiersSpec;
import org.openstreetmap.josm.actions.mapmode.ParallelWays;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ParallelWayAction
extends MapMode
implements Preferences.PreferenceChangedListener,
MapViewPaintable,
ModifierListener {
    private Mode mode;
    private boolean copyTags;
    private boolean copyTagsDefault;
    private boolean snap;
    private boolean snapDefault;
    private double snapThreshold;
    private double snapDistanceMetric;
    private double snapDistanceImperial;
    private double snapDistanceChinese;
    private double snapDistanceNautical;
    private ModifiersSpec snapModifierCombo;
    private ModifiersSpec copyTagsModifierCombo;
    private ModifiersSpec addToSelectionModifierCombo;
    private ModifiersSpec toggleSelectedModifierCombo;
    private ModifiersSpec setSelectedModifierCombo;
    private int initialMoveDelay;
    private final MapView mv;
    private Point mousePressedPos;
    private boolean mouseIsDown;
    private long mousePressedTime;
    private boolean mouseHasBeenDragged;
    private WaySegment referenceSegment;
    private ParallelWays pWays;
    private Set<Way> sourceWays;
    private EastNorth helperLineStart;
    private EastNorth helperLineEnd;
    Stroke helpLineStroke;
    Stroke refLineStroke;
    Color mainColor;

    public ParallelWayAction(MapFrame mapFrame) {
        super(I18n.tr("Parallel", new Object[0]), "parallel", I18n.tr("Make parallel copies of ways", new Object[0]), Shortcut.registerShortcut("mapmode:parallel", I18n.tr("Mode: {0}", I18n.tr("Parallel", new Object[0])), 80, 5005), mapFrame, ImageProvider.getCursor("normal", "parallel"));
        this.putValue("help", HelpUtil.ht("/Action/Parallel"));
        this.mv = mapFrame.mapView;
        this.updateModeLocalPreferences();
        Main.pref.addPreferenceChangeListener(this);
    }

    @Override
    public void enterMode() {
        this.setMode(Mode.normal);
        this.pWays = null;
        this.updateAllPreferences();
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.addTemporaryLayer(this);
        this.helpLineStroke = GuiHelper.getCustomizedStroke(this.getStringPref("stroke.hepler-line", "1"));
        this.refLineStroke = GuiHelper.getCustomizedStroke(this.getStringPref("stroke.ref-line", "1 2 2"));
        this.mainColor = Main.pref.getColor(I18n.marktr("make parallel helper line"), null);
        if (this.mainColor == null) {
            this.mainColor = PaintColors.SELECTED.get();
        }
        Main.map.keyDetector.addModifierListener(this);
        this.sourceWays = new LinkedHashSet<Way>(ParallelWayAction.getCurrentDataSet().getSelectedWays());
        for (Way w : this.sourceWays) {
            w.setHighlighted(true);
        }
        this.mv.repaint();
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.removeTemporaryLayer(this);
        Main.map.statusLine.setDist(-1.0);
        Main.map.statusLine.repaint();
        Main.map.keyDetector.removeModifierListener(this);
        this.removeWayHighlighting(this.sourceWays);
        this.pWays = null;
        this.sourceWays = null;
        this.referenceSegment = null;
        this.mv.repaint();
    }

    @Override
    public String getModeHelpText() {
        switch (this.mode) {
            case normal: {
                return I18n.tr("Select ways as in Select mode. Drag selected ways or a single way to create a parallel copy (Alt toggles tag preservation)", new Object[0]);
            }
            case dragging: {
                return I18n.tr("Hold Ctrl to toggle snapping", new Object[0]);
            }
        }
        return "";
    }

    private void updateAllPreferences() {
        this.updateModeLocalPreferences();
    }

    private void updateModeLocalPreferences() {
        this.snapThreshold = Main.pref.getDouble(this.prefKey("snap-threshold-percent"), 0.7);
        this.snapDefault = Main.pref.getBoolean(this.prefKey("snap-default"), true);
        this.copyTagsDefault = Main.pref.getBoolean(this.prefKey("copy-tags-default"), true);
        this.initialMoveDelay = Main.pref.getInteger(this.prefKey("initial-move-delay"), 200);
        this.snapDistanceMetric = Main.pref.getDouble(this.prefKey("snap-distance-metric"), 0.5);
        this.snapDistanceImperial = Main.pref.getDouble(this.prefKey("snap-distance-imperial"), 1.0);
        this.snapDistanceChinese = Main.pref.getDouble(this.prefKey("snap-distance-chinese"), 1.0);
        this.snapDistanceNautical = Main.pref.getDouble(this.prefKey("snap-distance-nautical"), 0.1);
        this.snapModifierCombo = new ModifiersSpec(this.getStringPref("snap-modifier-combo", "?sC"));
        this.copyTagsModifierCombo = new ModifiersSpec(this.getStringPref("copy-tags-modifier-combo", "As?"));
        this.addToSelectionModifierCombo = new ModifiersSpec(this.getStringPref("add-to-selection-modifier-combo", "aSc"));
        this.toggleSelectedModifierCombo = new ModifiersSpec(this.getStringPref("toggle-selection-modifier-combo", "asC"));
        this.setSelectedModifierCombo = new ModifiersSpec(this.getStringPref("set-selection-modifier-combo", "asc"));
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void modifiersChanged(int modifiers) {
        if (Main.map == null || this.mv == null || !this.mv.isActiveLayerDrawable()) {
            return;
        }
        if (this.updateModifiersState(modifiers)) {
            this.updateStatusLine();
            this.updateCursor();
        }
    }

    private boolean updateModifiersState(int modifiers) {
        boolean oldAlt = this.alt;
        boolean oldShift = this.shift;
        boolean oldCtrl = this.ctrl;
        this.updateKeyModifiers(modifiers);
        return oldAlt != this.alt || oldShift != this.shift || oldCtrl != this.ctrl;
    }

    private void updateCursor() {
        Cursor newCursor = null;
        switch (this.mode) {
            case normal: {
                if (this.matchesCurrentModifiers(this.setSelectedModifierCombo)) {
                    newCursor = ImageProvider.getCursor("normal", "parallel");
                    break;
                }
                if (this.matchesCurrentModifiers(this.addToSelectionModifierCombo)) {
                    newCursor = ImageProvider.getCursor("normal", "parallel");
                    break;
                }
                if (!this.matchesCurrentModifiers(this.toggleSelectedModifierCombo)) break;
                newCursor = ImageProvider.getCursor("normal", "parallel");
                break;
            }
            case dragging: {
                newCursor = this.snap ? Cursor.getPredefinedCursor(13) : Cursor.getPredefinedCursor(13);
            }
        }
        if (newCursor != null) {
            this.mv.setNewCursor(newCursor, (Object)this);
        }
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        this.updateCursor();
        this.updateStatusLine();
    }

    private boolean sanityCheck() {
        boolean areWeSane;
        boolean bl = areWeSane = this.mv.isActiveLayerVisible() && this.mv.isActiveLayerDrawable() && (Boolean)this.getValue("active") != false;
        assert (areWeSane);
        return areWeSane;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInMapView();
        this.updateModifiersState(e.getModifiers());
        if (e.getButton() != 1) {
            return;
        }
        if (!this.sanityCheck()) {
            return;
        }
        this.updateFlagsOnlyChangeableOnPress();
        this.updateFlagsChangeableAlways();
        if (this.pWays != null && this.pWays.ways != null) {
            ParallelWayAction.getCurrentDataSet().clearSelection(this.pWays.ways);
            this.pWays = null;
        }
        this.mouseIsDown = true;
        this.mousePressedPos = e.getPoint();
        this.mousePressedTime = System.currentTimeMillis();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateModifiersState(e.getModifiers());
        if (e.getButton() != 1) {
            return;
        }
        if (!this.mouseHasBeenDragged) {
            Way nearestWay = this.mv.getNearestWay(e.getPoint(), OsmPrimitive.isSelectablePredicate);
            if (nearestWay == null) {
                if (this.matchesCurrentModifiers(this.setSelectedModifierCombo)) {
                    this.clearSourceWays();
                }
                this.resetMouseTrackingState();
                return;
            }
            boolean isSelected = nearestWay.isSelected();
            if (this.matchesCurrentModifiers(this.addToSelectionModifierCombo)) {
                if (!isSelected) {
                    this.addSourceWay(nearestWay);
                }
            } else if (this.matchesCurrentModifiers(this.toggleSelectedModifierCombo)) {
                if (isSelected) {
                    this.removeSourceWay(nearestWay);
                } else {
                    this.addSourceWay(nearestWay);
                }
            } else if (this.matchesCurrentModifiers(this.setSelectedModifierCombo)) {
                this.clearSourceWays();
                this.addSourceWay(nearestWay);
            }
        } else if (this.mode == Mode.dragging) {
            this.clearSourceWays();
        }
        this.setMode(Mode.normal);
        this.resetMouseTrackingState();
        this.mv.repaint();
    }

    private void removeWayHighlighting(Collection<Way> ways) {
        if (ways == null) {
            return;
        }
        for (Way w : ways) {
            w.setHighlighted(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double realD;
        if (!this.mouseIsDown) {
            return;
        }
        boolean modifiersChanged = this.updateModifiersState(e.getModifiers());
        this.updateFlagsChangeableAlways();
        if (modifiersChanged) {
            this.updateStatusLine();
            this.updateCursor();
        }
        if (System.currentTimeMillis() - this.mousePressedTime < (long)this.initialMoveDelay) {
            return;
        }
        this.mouseHasBeenDragged = true;
        Point p = e.getPoint();
        if (this.mode == Mode.normal) {
            if (!this.isModifiersValidForDragMode()) {
                return;
            }
            if (!this.initParallelWays(this.mousePressedPos, this.copyTags)) {
                return;
            }
            this.setMode(Mode.dragging);
        }
        EastNorth enp = this.mv.getEastNorth((int)p.getX(), (int)p.getY());
        EastNorth nearestPointOnRefLine = Geometry.closestPointToLine(this.referenceSegment.getFirstNode().getEastNorth(), this.referenceSegment.getSecondNode().getEastNorth(), enp);
        double d = enp.distance(nearestPointOnRefLine);
        double snappedRealD = realD = this.mv.getProjection().eastNorth2latlon(enp).greatCircleDistance(this.mv.getProjection().eastNorth2latlon(nearestPointOnRefLine));
        boolean toTheRight = Geometry.isToTheRightSideOfLine(this.referenceSegment.getFirstNode(), this.referenceSegment.getFirstNode(), this.referenceSegment.getSecondNode(), new Node(enp));
        if (this.snap) {
            SystemOfMeasurement som = NavigatableComponent.getSystemOfMeasurement();
            double snapDistance = som.equals(SystemOfMeasurement.CHINESE) ? this.snapDistanceChinese * SystemOfMeasurement.CHINESE.aValue : (som.equals(SystemOfMeasurement.IMPERIAL) ? this.snapDistanceImperial * SystemOfMeasurement.IMPERIAL.aValue : (som.equals(SystemOfMeasurement.NAUTICAL_MILE) ? this.snapDistanceNautical * SystemOfMeasurement.NAUTICAL_MILE.aValue : this.snapDistanceMetric));
            double modulo = realD % snapDistance;
            double closestWholeUnit = modulo < snapDistance / 2.0 ? realD - modulo : realD + (snapDistance - modulo);
            snappedRealD = Math.abs(closestWholeUnit - realD) < this.snapThreshold * snapDistance ? closestWholeUnit : closestWholeUnit + Math.signum(realD - closestWholeUnit) * snapDistance;
        }
        d = snappedRealD * (d / realD);
        this.helperLineStart = nearestPointOnRefLine;
        this.helperLineEnd = enp;
        if (toTheRight) {
            d = -d;
        }
        this.pWays.changeOffset(d);
        Main.map.statusLine.setDist(Math.abs(snappedRealD));
        Main.map.statusLine.repaint();
        this.mv.repaint();
    }

    private boolean matchesCurrentModifiers(ModifiersSpec spec) {
        return spec.matchWithKnown(this.alt, this.shift, this.ctrl);
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.mode == Mode.dragging) {
            if (mv == null) {
                return;
            }
            g.setStroke(this.refLineStroke);
            g.setColor(this.mainColor);
            Point p1 = mv.getPoint(this.referenceSegment.getFirstNode().getEastNorth());
            Point p2 = mv.getPoint(this.referenceSegment.getSecondNode().getEastNorth());
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            g.setStroke(this.helpLineStroke);
            g.setColor(this.mainColor);
            p1 = mv.getPoint(this.helperLineStart);
            p2 = mv.getPoint(this.helperLineEnd);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }

    private boolean isModifiersValidForDragMode() {
        return !this.alt && !this.shift && !this.ctrl || this.matchesCurrentModifiers(this.snapModifierCombo) || this.matchesCurrentModifiers(this.copyTagsModifierCombo);
    }

    private void updateFlagsOnlyChangeableOnPress() {
        this.copyTags = this.copyTagsDefault != this.matchesCurrentModifiers(this.copyTagsModifierCombo);
    }

    private void updateFlagsChangeableAlways() {
        this.snap = this.snapDefault != this.matchesCurrentModifiers(this.snapModifierCombo);
    }

    private void addSourceWay(Way w) {
        assert (this.sourceWays != null);
        ParallelWayAction.getCurrentDataSet().addSelected(w);
        w.setHighlighted(true);
        this.sourceWays.add(w);
    }

    private void removeSourceWay(Way w) {
        assert (this.sourceWays != null);
        ParallelWayAction.getCurrentDataSet().clearSelection(w);
        w.setHighlighted(false);
        this.sourceWays.remove(w);
    }

    private void clearSourceWays() {
        assert (this.sourceWays != null);
        ParallelWayAction.getCurrentDataSet().clearSelection(this.sourceWays);
        for (Way w : this.sourceWays) {
            w.setHighlighted(false);
        }
        this.sourceWays.clear();
    }

    private void resetMouseTrackingState() {
        this.mouseIsDown = false;
        this.mousePressedPos = null;
        this.mouseHasBeenDragged = false;
    }

    private boolean initParallelWays(Point p, boolean copyTags) {
        this.referenceSegment = this.mv.getNearestWaySegment(p, Way.isUsablePredicate, true);
        if (this.referenceSegment == null) {
            return false;
        }
        if (!this.sourceWays.contains(this.referenceSegment.way)) {
            this.clearSourceWays();
            this.addSourceWay(this.referenceSegment.way);
        }
        try {
            int referenceWayIndex = -1;
            int i = 0;
            for (Way w : this.sourceWays) {
                if (w == this.referenceSegment.way) {
                    referenceWayIndex = i;
                    break;
                }
                ++i;
            }
            this.pWays = new ParallelWays(this.sourceWays, copyTags, referenceWayIndex);
            this.pWays.commit();
            ParallelWayAction.getCurrentDataSet().setSelected(this.pWays.ways);
            return true;
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("ParallelWayAction\nThe ways selected must form a simple branchless path", new Object[0]), I18n.tr("Make parallel way error", new Object[0]), 1);
            this.resetMouseTrackingState();
            this.pWays = null;
            return false;
        }
    }

    private String prefKey(String subKey) {
        return "edit.make-parallel-way-action." + subKey;
    }

    private String getStringPref(String subKey, String def) {
        return Main.pref.get(this.prefKey(subKey), def);
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        if (e.getKey().startsWith(this.prefKey(""))) {
            this.updateAllPreferences();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        Main.pref.removePreferenceChangeListener(this);
    }

    private static enum Mode {
        dragging,
        normal;

    }
}

