/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class MapMode
extends JosmAction
implements MouseListener,
MouseMotionListener {
    protected final Cursor cursor;
    protected boolean ctrl;
    protected boolean alt;
    protected boolean shift;

    public MapMode(String name, String iconName, String tooltip, Shortcut shortcut, MapFrame mapFrame, Cursor cursor) {
        super(name, "mapmode/" + iconName, tooltip, shortcut, false);
        this.cursor = cursor;
        this.putValue("active", false);
    }

    public MapMode(String name, String iconName, String tooltip, MapFrame mapFrame, Cursor cursor) {
        this.putValue("Name", name);
        this.putValue("SmallIcon", ImageProvider.get("mapmode", iconName));
        this.putValue("ShortDescription", tooltip);
        this.cursor = cursor;
    }

    public void enterMode() {
        this.putValue("active", true);
        Main.map.mapView.setNewCursor(this.cursor, (Object)this);
        this.updateStatusLine();
    }

    public void exitMode() {
        this.putValue("active", false);
        Main.map.mapView.resetCursor(this);
    }

    protected void updateStatusLine() {
        Main.map.statusLine.setHelpText(this.getModeHelpText());
        Main.map.statusLine.repaint();
    }

    public String getModeHelpText() {
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (Main.isDisplayingMapView()) {
            Main.map.selectMapMode(this);
        }
    }

    public boolean layerIsSupported(Layer l) {
        return true;
    }

    protected void updateKeyModifiers(InputEvent e) {
        this.updateKeyModifiers(e.getModifiers());
    }

    protected void updateKeyModifiers(MouseEvent e) {
        this.updateKeyModifiers(e.getModifiers());
    }

    protected void updateKeyModifiers(int modifiers) {
        this.ctrl = (modifiers & 2) != 0;
        this.alt = (modifiers & 0x28) != 0;
        this.shift = (modifiers & 1) != 0;
    }

    protected void requestFocusInMapView() {
        if (this.isEnabled()) {
            Main.map.mapView.requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.requestFocusInMapView();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInMapView();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

