/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.ImproveWayAccuracyHelper;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class ImproveWayAccuracyAction
extends MapMode
implements SelectionChangedListener,
MapViewPaintable,
ModifierListener {
    private State state;
    private MapView mv;
    private Way targetWay;
    private Node candidateNode = null;
    private WaySegment candidateSegment = null;
    private Point mousePos = null;
    private boolean dragging = false;
    private final Cursor cursorSelect = ImageProvider.getCursor("normal", "mode");
    private final Cursor cursorSelectHover = ImageProvider.getCursor("hand", "mode");
    private final Cursor cursorImprove = ImageProvider.getCursor("crosshair", null);
    private final Cursor cursorImproveAdd = ImageProvider.getCursor("crosshair", "addnode");
    private final Cursor cursorImproveDelete = ImageProvider.getCursor("crosshair", "delete_node");
    private final Cursor cursorImproveAddLock = ImageProvider.getCursor("crosshair", "add_node_lock");
    private final Cursor cursorImproveLock = ImageProvider.getCursor("crosshair", "lock");
    private Color guideColor;
    private Stroke selectTargetWayStroke;
    private Stroke moveNodeStroke;
    private Stroke addNodeStroke;
    private Stroke deleteNodeStroke;
    private int dotSize;
    private boolean selectionChangedBlocked = false;
    protected String oldModeHelpText;

    public ImproveWayAccuracyAction(MapFrame mapFrame) {
        super(I18n.tr("Improve Way Accuracy", new Object[0]), "improvewayaccuracy", I18n.tr("Improve Way Accuracy mode", new Object[0]), Shortcut.registerShortcut("mapmode:ImproveWayAccuracy", I18n.tr("Mode: {0}", I18n.tr("Improve Way Accuracy", new Object[0])), 87, 5003), mapFrame, Cursor.getPredefinedCursor(0));
        this.readPreferences();
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.readPreferences();
        this.mv = Main.map.mapView;
        this.mousePos = null;
        this.oldModeHelpText = "";
        if (ImproveWayAccuracyAction.getCurrentDataSet() == null) {
            return;
        }
        this.updateStateByCurrentSelection();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.addTemporaryLayer(this);
        DataSet.addSelectionListener(this);
        Main.map.keyDetector.addModifierListener(this);
    }

    private void readPreferences() {
        this.guideColor = Main.pref.getColor(I18n.marktr("improve way accuracy helper line"), null);
        if (this.guideColor == null) {
            this.guideColor = PaintColors.HIGHLIGHT.get();
        }
        this.selectTargetWayStroke = GuiHelper.getCustomizedStroke(Main.pref.get("improvewayaccuracy.stroke.select-target", "2"));
        this.moveNodeStroke = GuiHelper.getCustomizedStroke(Main.pref.get("improvewayaccuracy.stroke.move-node", "1 6"));
        this.addNodeStroke = GuiHelper.getCustomizedStroke(Main.pref.get("improvewayaccuracy.stroke.add-node", "1"));
        this.deleteNodeStroke = GuiHelper.getCustomizedStroke(Main.pref.get("improvewayaccuracy.stroke.delete-node", "1"));
        this.dotSize = Main.pref.getInteger("improvewayaccuracy.dot-size", 6);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        DataSet.removeSelectionListener(this);
        Main.map.keyDetector.removeModifierListener(this);
        Main.map.mapView.repaint();
    }

    @Override
    protected void updateStatusLine() {
        String newModeHelpText = this.getModeHelpText();
        if (!newModeHelpText.equals(this.oldModeHelpText)) {
            this.oldModeHelpText = newModeHelpText;
            Main.map.statusLine.setHelpText(newModeHelpText);
            Main.map.statusLine.repaint();
        }
    }

    @Override
    public String getModeHelpText() {
        if (this.state == State.selecting) {
            if (this.targetWay != null) {
                return I18n.tr("Click on the way to start improving its shape.", new Object[0]);
            }
            return I18n.tr("Select a way that you want to make more accurate.", new Object[0]);
        }
        if (this.ctrl) {
            return I18n.tr("Click to add a new node. Release Ctrl to move existing nodes or hold Alt to delete.", new Object[0]);
        }
        if (this.alt) {
            return I18n.tr("Click to delete the highlighted node. Release Alt to move existing nodes or hold Ctrl to add new nodes.", new Object[0]);
        }
        return I18n.tr("Click to move the highlighted node. Hold Ctrl to add new nodes, or Alt to delete.", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(ImproveWayAccuracyAction.getEditLayer() != null);
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.mousePos == null) {
            return;
        }
        g.setColor(this.guideColor);
        if (this.state == State.selecting && this.targetWay != null) {
            g.setStroke(this.selectTargetWayStroke);
            List<Node> nodes = this.targetWay.getNodes();
            GeneralPath b = new GeneralPath();
            Point p0 = mv.getPoint(nodes.get(0));
            b.moveTo(p0.x, p0.y);
            for (Node n : nodes) {
                Point pn = mv.getPoint(n);
                b.lineTo(pn.x, pn.y);
            }
            if (this.targetWay.isClosed()) {
                b.lineTo(p0.x, p0.y);
            }
            g.draw(b);
        } else if (this.state == State.improving) {
            Point p1 = null;
            Point p2 = null;
            if (this.ctrl && this.candidateSegment != null) {
                g.setStroke(this.addNodeStroke);
                p1 = mv.getPoint(this.candidateSegment.getFirstNode());
                p2 = mv.getPoint(this.candidateSegment.getSecondNode());
            } else if (!this.alt && !this.ctrl && this.candidateNode != null) {
                g.setStroke(this.moveNodeStroke);
                List<Pair<Node, Node>> wpps = this.targetWay.getNodePairs(false);
                for (Pair<Node, Node> wpp : wpps) {
                    if (wpp.a == this.candidateNode) {
                        p1 = mv.getPoint((Node)wpp.b);
                    }
                    if (wpp.b == this.candidateNode) {
                        p2 = mv.getPoint((Node)wpp.a);
                    }
                    if (p1 == null || p2 == null) continue;
                    break;
                }
            } else if (this.alt && !this.ctrl && this.candidateNode != null) {
                g.setStroke(this.deleteNodeStroke);
                List<Node> nodes = this.targetWay.getNodes();
                int index = nodes.indexOf(this.candidateNode);
                if (index != 0 && index != nodes.size() - 1) {
                    p1 = mv.getPoint(nodes.get(index - 1));
                    p2 = mv.getPoint(nodes.get(index + 1));
                }
            }
            GeneralPath b = new GeneralPath();
            if (this.alt && !this.ctrl) {
                if (p1 != null && p2 != null) {
                    b.moveTo(p1.x, p1.y);
                    b.lineTo(p2.x, p2.y);
                }
            } else {
                if (p1 != null) {
                    b.moveTo(this.mousePos.x, this.mousePos.y);
                    b.lineTo(p1.x, p1.y);
                }
                if (p2 != null) {
                    b.moveTo(this.mousePos.x, this.mousePos.y);
                    b.lineTo(p2.x, p2.y);
                }
            }
            g.draw(b);
            if (this.candidateNode != null) {
                p1 = mv.getPoint(this.candidateNode);
                g.fillRect(p1.x - this.dotSize / 2, p1.y - this.dotSize / 2, this.dotSize, this.dotSize);
            }
        }
    }

    @Override
    public void modifiersChanged(int modifiers) {
        if (!Main.isDisplayingMapView() || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers(modifiers);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (this.selectionChangedBlocked) {
            return;
        }
        this.updateStateByCurrentSelection();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.mousePos = e.getPoint();
        this.updateKeyModifiers(e);
        this.updateCursorDependentObjectsIfNeeded();
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
        if (!this.isEnabled() || e.getButton() != 1) {
            return;
        }
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        if (this.state == State.selecting) {
            if (this.targetWay != null) {
                ImproveWayAccuracyAction.getCurrentDataSet().setSelected(this.targetWay.getPrimitiveId());
                this.updateStateByCurrentSelection();
            }
        } else if (this.state == State.improving && this.mousePos != null) {
            if (this.mv.getLatLon(this.mousePos.x, this.mousePos.y).isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot place a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            if (this.ctrl && !this.alt && this.candidateSegment != null) {
                LinkedList<Command> virtualCmds = new LinkedList<Command>();
                Node virtualNode = new Node(this.mv.getEastNorth(this.mousePos.x, this.mousePos.y));
                virtualCmds.add(new AddCommand(virtualNode));
                List<Way> firstNodeWays = OsmPrimitive.getFilteredList(this.candidateSegment.getFirstNode().getReferrers(), Way.class);
                List<Way> secondNodeWays = OsmPrimitive.getFilteredList(this.candidateSegment.getFirstNode().getReferrers(), Way.class);
                LinkedList<WaySegment> virtualSegments = new LinkedList<WaySegment>();
                for (Way w : firstNodeWays) {
                    List<Pair<Node, Node>> wpps = w.getNodePairs(true);
                    for (Way w2 : secondNodeWays) {
                        if (!w.equals(w2)) continue;
                        int i = -1;
                        for (Pair<Node, Node> wpp : wpps) {
                            ++i;
                            if ((!((Node)wpp.a).equals(this.candidateSegment.getFirstNode()) || !((Node)wpp.b).equals(this.candidateSegment.getSecondNode())) && (!((Node)wpp.b).equals(this.candidateSegment.getFirstNode()) || !((Node)wpp.a).equals(this.candidateSegment.getSecondNode()))) continue;
                            virtualSegments.add(new WaySegment(w, i));
                        }
                    }
                }
                for (WaySegment virtualSegment : virtualSegments) {
                    Way w = virtualSegment.way;
                    Way wnew = new Way(w);
                    wnew.addNode(virtualSegment.lowerIndex + 1, virtualNode);
                    virtualCmds.add(new ChangeCommand(w, wnew));
                }
                String text = I18n.trn("Add a new node to way", "Add a new node to {0} ways", virtualSegments.size(), virtualSegments.size());
                Main.main.undoRedo.add(new SequenceCommand(text, virtualCmds));
            } else if (this.alt && !this.ctrl && this.candidateNode != null) {
                List<OsmPrimitive> referrers = this.candidateNode.getReferrers();
                List<Way> ways = OsmPrimitive.getFilteredList(referrers, Way.class);
                if (referrers.size() != 1 || ways.size() != 1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot delete node that is referenced by multiple objects", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                } else if (this.candidateNode.isTagged()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot delete node that has tags", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                } else {
                    ArrayList<Node> nodeList = new ArrayList<Node>();
                    nodeList.add(this.candidateNode);
                    Command deleteCmd = DeleteCommand.delete(ImproveWayAccuracyAction.getEditLayer(), nodeList, true);
                    if (deleteCmd != null) {
                        Main.main.undoRedo.add(deleteCmd);
                    }
                }
            } else if (this.candidateNode != null) {
                EastNorth nodeEN = this.candidateNode.getEastNorth();
                EastNorth cursorEN = this.mv.getEastNorth(this.mousePos.x, this.mousePos.y);
                Main.main.undoRedo.add(new MoveCommand((OsmPrimitive)this.candidateNode, cursorEN.east() - nodeEN.east(), cursorEN.north() - nodeEN.north()));
            }
        }
        this.mousePos = null;
        this.updateCursor();
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.dragging) {
            this.mousePos = null;
        }
        Main.map.mapView.repaint();
    }

    private void updateCursor() {
        if (!this.isEnabled()) {
            this.mv.setNewCursor(null, (Object)this);
            return;
        }
        if (this.state == State.selecting) {
            this.mv.setNewCursor(this.targetWay == null ? this.cursorSelect : this.cursorSelectHover, (Object)this);
        } else if (this.state == State.improving) {
            if (this.alt && !this.ctrl) {
                this.mv.setNewCursor(this.cursorImproveDelete, (Object)this);
            } else if (this.shift || this.dragging) {
                if (this.ctrl) {
                    this.mv.setNewCursor(this.cursorImproveAddLock, (Object)this);
                } else {
                    this.mv.setNewCursor(this.cursorImproveLock, (Object)this);
                }
            } else if (this.ctrl && !this.alt) {
                this.mv.setNewCursor(this.cursorImproveAdd, (Object)this);
            } else {
                this.mv.setNewCursor(this.cursorImprove, (Object)this);
            }
        }
    }

    public void updateCursorDependentObjectsIfNeeded() {
        if (this.state == State.improving && (this.shift || this.dragging) && (this.candidateNode != null || this.candidateSegment != null)) {
            return;
        }
        if (this.mousePos == null) {
            this.candidateNode = null;
            this.candidateSegment = null;
            return;
        }
        if (this.state == State.selecting) {
            this.targetWay = ImproveWayAccuracyHelper.findWay(this.mv, this.mousePos);
        } else if (this.state == State.improving) {
            if (this.ctrl && !this.alt) {
                this.candidateSegment = ImproveWayAccuracyHelper.findCandidateSegment(this.mv, this.targetWay, this.mousePos);
                this.candidateNode = null;
            } else {
                this.candidateNode = ImproveWayAccuracyHelper.findCandidateNode(this.mv, this.targetWay, this.mousePos);
                this.candidateSegment = null;
            }
        }
    }

    public void startSelecting() {
        this.state = State.selecting;
        this.targetWay = null;
        this.mv.repaint();
        this.updateStatusLine();
    }

    public void startImproving(Way targetWay) {
        this.state = State.improving;
        Collection<OsmPrimitive> currentSelection = ImproveWayAccuracyAction.getCurrentDataSet().getSelected();
        if (currentSelection.size() != 1 || !currentSelection.iterator().next().equals(targetWay)) {
            this.selectionChangedBlocked = true;
            ImproveWayAccuracyAction.getCurrentDataSet().clearSelection();
            ImproveWayAccuracyAction.getCurrentDataSet().setSelected(targetWay.getPrimitiveId());
            this.selectionChangedBlocked = false;
        }
        this.targetWay = targetWay;
        this.candidateNode = null;
        this.candidateSegment = null;
        this.mv.repaint();
        this.updateStatusLine();
    }

    private void updateStateByCurrentSelection() {
        List<OsmPrimitive> r;
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ArrayList<Way> wayList = new ArrayList<Way>();
        Collection<OsmPrimitive> sel = ImproveWayAccuracyAction.getCurrentDataSet().getSelected();
        for (OsmPrimitive p : sel) {
            if (p instanceof Way) {
                wayList.add((Way)p);
            }
            if (!(p instanceof Node)) continue;
            nodeList.add((Node)p);
        }
        if (wayList.size() == 1) {
            this.startImproving((Way)wayList.get(0));
            return;
        }
        if (nodeList.size() > 0 && nodeList.size() == 1 && (r = ((Node)nodeList.get(0)).getReferrers()).size() == 1 && r.get(0) instanceof Way) {
            this.startImproving((Way)r.get(0));
            return;
        }
        this.startSelecting();
    }

    static enum State {
        selecting,
        improving;

    }
}

