/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class DrawAction
extends MapMode
implements SelectionChangedListener,
MapViewPaintable,
KeyPressReleaseListener,
ModifierListener {
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private Node lastUsedNode = null;
    private static final double PHI = Math.toRadians(90.0);
    private double toleranceMultiplier;
    private Node mouseOnExistingNode;
    private Set<Way> mouseOnExistingWays = new HashSet<Way>();
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private Set<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
    private boolean drawHelperLine;
    private boolean wayIsFinished = false;
    private boolean drawTargetHighlight;
    private Point mousePos;
    private Point oldMousePos;
    private Color rubberLineColor;
    private Node currentBaseNode;
    private Node previousNode;
    private EastNorth currentMouseEastNorth;
    private final SnapHelper snapHelper = new SnapHelper();
    private final Shortcut backspaceShortcut;
    private final BackSpaceAction backspaceAction;
    private final Shortcut snappingShortcut = Shortcut.registerShortcut("mapmode:drawanglesnapping", I18n.tr("Mode: Draw Angle snapping", new Object[0]), 65535, 5000);
    private boolean ignoreNextKeyRelease;
    private final SnapChangeAction snapChangeAction = new SnapChangeAction();
    private final JCheckBoxMenuItem snapCheckboxMenuItem = this.addMenuItem();
    private boolean useRepeatedShortcut;
    private Stroke rubberLineStroke;
    private static final BasicStroke BASIC_STROKE = new BasicStroke(1.0f);
    private static int snapToIntersectionThreshold;
    private Point rightClickPressPos;

    public DrawAction(MapFrame mapFrame) {
        super(I18n.tr("Draw", new Object[0]), "node/autonode", I18n.tr("Draw nodes", new Object[0]), Shortcut.registerShortcut("mapmode:draw", I18n.tr("Mode: {0}", I18n.tr("Draw", new Object[0])), 65, 5003), mapFrame, ImageProvider.getCursor("crosshair", null));
        this.snapHelper.setMenuCheckBox(this.snapCheckboxMenuItem);
        this.backspaceShortcut = Shortcut.registerShortcut("mapmode:backspace", I18n.tr("Backspace in Add mode", new Object[0]), 8, 5003);
        this.backspaceAction = new BackSpaceAction();
        this.cursorJoinNode = ImageProvider.getCursor("crosshair", "joinnode");
        this.cursorJoinWay = ImageProvider.getCursor("crosshair", "joinway");
        this.readPreferences();
        this.snapHelper.init();
    }

    private JCheckBoxMenuItem addMenuItem() {
        int n = Main.main.menu.editMenu.getItemCount();
        for (int i = n - 1; i > 0; --i) {
            JMenuItem item = Main.main.menu.editMenu.getItem(i);
            if (item == null || item.getAction() == null || !(item.getAction() instanceof SnapChangeAction)) continue;
            Main.main.menu.editMenu.remove(i);
        }
        return MainMenu.addWithCheckbox(Main.main.menu.editMenu, this.snapChangeAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
    }

    private boolean redrawIfRequired() {
        boolean needsRepaint;
        this.updateStatusLine();
        boolean bl = needsRepaint = this.drawHelperLine && !this.wayIsFinished;
        if (this.drawTargetHighlight) {
            for (OsmPrimitive x : this.newHighlights) {
                if (this.oldHighlights.contains(x)) continue;
                x.setHighlighted(true);
                needsRepaint = true;
            }
            this.oldHighlights.removeAll(this.newHighlights);
            for (OsmPrimitive x : this.oldHighlights) {
                x.setHighlighted(false);
                needsRepaint = true;
            }
        }
        this.oldHighlights = this.newHighlights;
        if (!needsRepaint && !this.drawTargetHighlight) {
            return false;
        }
        DataSet currentDataSet = DrawAction.getCurrentDataSet();
        if (this.getCurrentBaseNode() != null && currentDataSet != null && !currentDataSet.getSelected().isEmpty()) {
            Way continueFrom = DrawAction.getWayForNode(this.getCurrentBaseNode());
            if (this.alt && continueFrom != null && (!this.getCurrentBaseNode().isSelected() || continueFrom.isSelected())) {
                DrawAction.addRemoveSelection(currentDataSet, this.getCurrentBaseNode(), continueFrom);
                needsRepaint = true;
            } else if (!this.alt && continueFrom != null && !continueFrom.isSelected()) {
                currentDataSet.addSelected(continueFrom);
                needsRepaint = true;
            }
        }
        if (needsRepaint) {
            Main.map.mapView.repaint();
        }
        return needsRepaint;
    }

    private static void addRemoveSelection(DataSet ds, OsmPrimitive toAdd, OsmPrimitive toRemove) {
        ds.beginUpdate();
        ds.addSelected(toAdd);
        ds.clearSelection(toRemove);
        ds.endUpdate();
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.readPreferences();
        this.determineCurrentBaseNodeAndPreviousNode(DrawAction.getCurrentDataSet().getSelected());
        this.wayIsFinished = this.getCurrentBaseNode() == null;
        this.toleranceMultiplier = 0.01 * (double)NavigatableComponent.PROP_SNAP_DISTANCE.get().intValue();
        this.snapHelper.init();
        this.snapCheckboxMenuItem.getAction().setEnabled(true);
        Main.map.statusLine.getAnglePanel().addMouseListener(this.snapHelper.anglePopupListener);
        Main.registerActionShortcut(this.backspaceAction, this.backspaceShortcut);
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.addTemporaryLayer(this);
        DataSet.addSelectionListener(this);
        Main.map.keyDetector.addKeyListener(this);
        Main.map.keyDetector.addModifierListener(this);
        this.ignoreNextKeyRelease = true;
    }

    private void readPreferences() {
        this.rubberLineColor = Main.pref.getColor(I18n.marktr("helper line"), null);
        if (this.rubberLineColor == null) {
            this.rubberLineColor = PaintColors.SELECTED.get();
        }
        this.rubberLineStroke = GuiHelper.getCustomizedStroke(Main.pref.get("draw.stroke.helper-line", "3"));
        this.drawHelperLine = Main.pref.getBoolean("draw.helper-line", true);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        snapToIntersectionThreshold = Main.pref.getInteger("edit.snap-intersection-threshold", 10);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        DataSet.removeSelectionListener(this);
        Main.unregisterActionShortcut(this.backspaceAction, this.backspaceShortcut);
        this.snapHelper.unsetFixedMode();
        this.snapCheckboxMenuItem.getAction().setEnabled(false);
        Main.map.statusLine.getAnglePanel().removeMouseListener(this.snapHelper.anglePopupListener);
        Main.map.statusLine.activateAnglePanel(false);
        this.removeHighlighting();
        Main.map.keyDetector.removeKeyListener(this);
        Main.map.keyDetector.removeModifierListener(this);
        DataSet ds = DrawAction.getCurrentDataSet();
        if (ds != null) {
            ds.fireSelectionChanged();
        }
    }

    @Override
    public void modifiersChanged(int modifiers) {
        if (!Main.isDisplayingMapView() || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers(modifiers);
        this.computeHelperLine();
        this.addHighlighting();
    }

    @Override
    public void doKeyPressed(KeyEvent e) {
        if (!(this.snappingShortcut.isEvent(e) || this.useRepeatedShortcut && this.getShortcut().isEvent(e))) {
            return;
        }
        this.snapHelper.setFixedMode();
        this.computeHelperLine();
        this.redrawIfRequired();
    }

    @Override
    public void doKeyReleased(KeyEvent e) {
        if (!(this.snappingShortcut.isEvent(e) || this.useRepeatedShortcut && this.getShortcut().isEvent(e))) {
            return;
        }
        if (this.ignoreNextKeyRelease) {
            this.ignoreNextKeyRelease = false;
            return;
        }
        this.snapHelper.unFixOrTurnOff();
        this.computeHelperLine();
        this.redrawIfRequired();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.computeHelperLine();
        this.addHighlighting();
    }

    private void tryAgain(MouseEvent e) {
        DrawAction.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        this.mouseReleased(e);
    }

    private void finishDrawing() {
        Main.main.getCurrentDataSet().fireSelectionChanged();
        this.lastUsedNode = null;
        this.wayIsFinished = true;
        Main.map.selectSelectTool(true);
        this.snapHelper.noSnapNow();
        this.computeHelperLine();
        this.removeHighlighting();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.rightClickPressPos = e.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        String title;
        if (e.getButton() == 3) {
            Point curMousePos = e.getPoint();
            if (curMousePos.equals(this.rightClickPressPos)) {
                this.tryToSetBaseSegmentForAngleSnap();
            }
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        Main.map.mapView.requestFocus();
        if (e.getClickCount() > 1 && this.mousePos != null && this.mousePos.equals(this.oldMousePos)) {
            this.finishDrawing();
            return;
        }
        this.oldMousePos = this.mousePos;
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        DataSet ds = DrawAction.getCurrentDataSet();
        ArrayList<OsmPrimitive> selection = new ArrayList<OsmPrimitive>(ds.getSelected());
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<OsmPrimitive> newSelection = new LinkedList<OsmPrimitive>(ds.getSelected());
        ArrayList<Way> reuseWays = new ArrayList<Way>();
        ArrayList<Way> replacedWays = new ArrayList<Way>();
        boolean newNode = false;
        Node n = null;
        n = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        if (this.ctrl) {
            Iterator<Way> it = DrawAction.getCurrentDataSet().getSelectedWays().iterator();
            if (it.hasNext()) {
                if (!it.next().containsNode(n)) {
                    n = null;
                }
            } else {
                n = null;
            }
        }
        if (n != null && !this.snapHelper.isActive()) {
            if (selection.isEmpty() || this.wayIsFinished) {
                DrawAction.getCurrentDataSet().setSelected(n);
                Way continueFrom = DrawAction.getWayForNode(n);
                if (continueFrom != null) {
                    DrawAction.getCurrentDataSet().addSelected(continueFrom);
                }
                this.wayIsFinished = false;
                return;
            }
        } else {
            EastNorth newEN;
            if (n != null) {
                EastNorth foundPoint = n.getEastNorth();
                newEN = this.snapHelper.getSnapPoint(foundPoint);
                double tolerance = Main.map.mapView.getDist100Pixel() * this.toleranceMultiplier;
                if (foundPoint.distance(newEN) > tolerance) {
                    n = new Node(newEN);
                    newNode = true;
                }
            } else {
                EastNorth mouseEN = Main.map.mapView.getEastNorth(e.getX(), e.getY());
                newEN = this.snapHelper.isSnapOn() ? this.snapHelper.getSnapPoint(mouseEN) : mouseEN;
                n = new Node(newEN);
                newNode = true;
            }
            this.snapHelper.unsetFixedMode();
        }
        if (newNode) {
            if (n.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            cmds.add(new AddCommand(n));
            if (!this.ctrl) {
                List<WaySegment> wss = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(n), OsmPrimitive.isSelectablePredicate);
                if (this.snapHelper.isActive()) {
                    this.tryToMoveNodeOnIntersection(wss, n);
                }
                this.insertNodeIntoAllNearbySegments(wss, n, newSelection, cmds, replacedWays, reuseWays);
            }
        }
        boolean extendedWay = false;
        boolean wayIsFinishedTemp = this.wayIsFinished;
        this.wayIsFinished = false;
        if (!selection.isEmpty() && !this.shift) {
            Node selectedNode = null;
            Way selectedWay = null;
            for (OsmPrimitive p : selection) {
                if (p instanceof Node) {
                    if (selectedNode != null) {
                        this.tryAgain(e);
                        return;
                    }
                    selectedNode = (Node)p;
                    continue;
                }
                if (!(p instanceof Way)) continue;
                if (selectedWay != null) {
                    this.tryAgain(e);
                    return;
                }
                selectedWay = (Way)p;
            }
            Node n0 = this.findNodeToContinueFrom(selectedNode, selectedWay);
            if (n0 == null) {
                this.tryAgain(e);
                return;
            }
            if (!wayIsFinishedTemp) {
                Way wayToSelect;
                Way way;
                if (this.isSelfContainedWay(selectedWay, n0, n)) {
                    return;
                }
                if (n0 == n) {
                    this.finishDrawing();
                    return;
                }
                Way way2 = this.alt ? null : (way = selectedWay != null ? selectedWay : DrawAction.getWayForNode(n0));
                if (way != null) {
                    int nodeCount = 0;
                    for (Node p : way.getNodes()) {
                        if (!p.equals(n0)) continue;
                        ++nodeCount;
                    }
                    if (nodeCount > 1) {
                        way = null;
                    }
                }
                if (way == null) {
                    way = new Way();
                    way.addNode(n0);
                    cmds.add(new AddCommand(way));
                    wayToSelect = way;
                } else {
                    int i = replacedWays.indexOf(way);
                    if (i != -1) {
                        wayToSelect = way = (Way)reuseWays.get(i);
                    } else {
                        wayToSelect = way;
                        Way wnew = new Way(way);
                        cmds.add(new ChangeCommand(way, wnew));
                        way = wnew;
                    }
                }
                if (way.containsNode(n)) {
                    this.wayIsFinished = true;
                    selection.clear();
                }
                if (way.getNode(way.getNodesCount() - 1) == n0) {
                    way.addNode(n);
                } else {
                    way.addNode(0, n);
                }
                extendedWay = true;
                newSelection.clear();
                newSelection.add(wayToSelect);
            }
        }
        if (!extendedWay) {
            if (!newNode) {
                return;
            }
            if (reuseWays.isEmpty()) {
                title = I18n.tr("Add node", new Object[0]);
            } else {
                title = I18n.tr("Add node into way", new Object[0]);
                for (Way w : reuseWays) {
                    newSelection.remove(w);
                }
            }
            newSelection.clear();
            newSelection.add(n);
        } else {
            title = !newNode ? I18n.tr("Connect existing way to node", new Object[0]) : (reuseWays.isEmpty() ? I18n.tr("Add a new node to an existing way", new Object[0]) : I18n.tr("Add node into way and connect", new Object[0]));
        }
        SequenceCommand c = new SequenceCommand(title, cmds);
        Main.main.undoRedo.add(c);
        if (!this.wayIsFinished) {
            this.lastUsedNode = n;
        }
        DrawAction.getCurrentDataSet().setSelected(newSelection);
        if (n != null && Main.map.mapView.viewportFollowing) {
            Main.map.mapView.smoothScrollTo(n.getEastNorth());
        }
        this.computeHelperLine();
        this.removeHighlighting();
    }

    private void insertNodeIntoAllNearbySegments(List<WaySegment> wss, Node n, Collection<OsmPrimitive> newSelection, Collection<Command> cmds, List<Way> replacedWays, List<Way> reuseWays) {
        HashMap insertPoints = new HashMap();
        for (WaySegment ws : wss) {
            List<Integer> is;
            if (insertPoints.containsKey(ws.way)) {
                is = (List)insertPoints.get(ws.way);
            } else {
                is = new ArrayList();
                insertPoints.put(ws.way, is);
            }
            is.add(ws.lowerIndex);
        }
        HashSet<Pair<Node, Node>> segSet = new HashSet<Pair<Node, Node>>();
        for (Map.Entry insertPoint : insertPoints.entrySet()) {
            int i;
            Way w = (Way)insertPoint.getKey();
            List is = (List)insertPoint.getValue();
            Way wnew = new Way(w);
            DrawAction.pruneSuccsAndReverse(is);
            Iterator i$ = is.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                segSet.add(Pair.sort(new Pair<Node, Node>(w.getNode(i), w.getNode(i + 1))));
            }
            i$ = is.iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                wnew.addNode(i + 1, n);
            }
            if (this.alt) {
                newSelection.add((OsmPrimitive)insertPoint.getKey());
            }
            cmds.add(new ChangeCommand((OsmPrimitive)insertPoint.getKey(), wnew));
            replacedWays.add((Way)insertPoint.getKey());
            reuseWays.add(wnew);
        }
        DrawAction.adjustNode(segSet, n);
    }

    private boolean isSelfContainedWay(Way selectedWay, Node currentNode, Node targetNode) {
        int posn0;
        if (selectedWay != null && ((posn0 = selectedWay.getNodes().indexOf(currentNode)) != -1 && posn0 >= 1 && targetNode.equals(selectedWay.getNode(posn0 - 1)) || posn0 < selectedWay.getNodesCount() - 1 && targetNode.equals(selectedWay.getNode(posn0 + 1)))) {
            DrawAction.getCurrentDataSet().setSelected(targetNode);
            this.lastUsedNode = targetNode;
            return true;
        }
        return false;
    }

    private Node findNodeToContinueFrom(Node selectedNode, Way selectedWay) {
        if (selectedNode == null && selectedWay == null) {
            return null;
        }
        if (selectedNode == null) {
            if (selectedWay.isFirstLastNode(this.lastUsedNode)) {
                return this.lastUsedNode;
            }
            return null;
        }
        if (selectedWay == null) {
            return selectedNode;
        }
        if (selectedWay.isFirstLastNode(selectedNode)) {
            return selectedNode;
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers(e);
        this.mousePos = e.getPoint();
        if (this.snapHelper.isSnapOn() && this.ctrl) {
            this.tryToSetBaseSegmentForAngleSnap();
        }
        this.computeHelperLine();
        this.addHighlighting();
    }

    private void tryToSetBaseSegmentForAngleSnap() {
        WaySegment seg = Main.map.mapView.getNearestWaySegment(this.mousePos, OsmPrimitive.isSelectablePredicate);
        if (seg != null) {
            this.snapHelper.setBaseSegment(seg);
        }
    }

    private void computeHelperLine() {
        MapView mv = Main.map.mapView;
        if (this.mousePos == null) {
            this.currentMouseEastNorth = null;
            this.currentBaseNode = null;
            return;
        }
        Collection<OsmPrimitive> selection = DrawAction.getCurrentDataSet().getSelected();
        Node currentMouseNode = null;
        this.mouseOnExistingNode = null;
        this.mouseOnExistingWays = new HashSet<Way>();
        this.showStatusInfo(-1.0, -1.0, -1.0, this.snapHelper.isSnapOn());
        if (!this.ctrl && this.mousePos != null) {
            currentMouseNode = mv.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (!this.ctrl && currentMouseNode == null) {
            List<WaySegment> wss = mv.getNearestWaySegments(this.mousePos, OsmPrimitive.isSelectablePredicate);
            for (WaySegment ws : wss) {
                this.mouseOnExistingWays.add(ws.way);
            }
        }
        if (currentMouseNode != null) {
            if (selection.isEmpty()) {
                return;
            }
            this.currentMouseEastNorth = currentMouseNode.getEastNorth();
            this.mouseOnExistingNode = currentMouseNode;
        } else {
            this.currentMouseEastNorth = mv.getEastNorth(this.mousePos.x, this.mousePos.y);
        }
        this.determineCurrentBaseNodeAndPreviousNode(selection);
        if (this.previousNode == null) {
            this.snapHelper.noSnapNow();
        }
        if (this.getCurrentBaseNode() == null || this.getCurrentBaseNode() == currentMouseNode) {
            return;
        }
        double curHdg = Math.toDegrees(this.getCurrentBaseNode().getEastNorth().heading(this.currentMouseEastNorth));
        double baseHdg = -1.0;
        if (this.previousNode != null) {
            baseHdg = Math.toDegrees(this.previousNode.getEastNorth().heading(this.getCurrentBaseNode().getEastNorth()));
        }
        this.snapHelper.checkAngleSnapping(this.currentMouseEastNorth, baseHdg, curHdg);
    }

    private void showStatusInfo(double angle, double hdg, double distance, boolean activeFlag) {
        Main.map.statusLine.setAngle(angle);
        Main.map.statusLine.activateAnglePanel(activeFlag);
        Main.map.statusLine.setHeading(hdg);
        Main.map.statusLine.setDist(distance);
    }

    private void determineCurrentBaseNodeAndPreviousNode(Collection<OsmPrimitive> selection) {
        Node selectedNode = null;
        AbstractPrimitive selectedWay = null;
        for (OsmPrimitive p : selection) {
            if (p instanceof Node) {
                if (selectedNode != null) {
                    return;
                }
                selectedNode = (Node)p;
                continue;
            }
            if (!(p instanceof Way)) continue;
            if (selectedWay != null) {
                return;
            }
            selectedWay = (Way)p;
        }
        this.currentBaseNode = null;
        this.previousNode = null;
        if (selectedWay == null && selectedNode != null) {
            for (OsmPrimitive p : selectedNode.getReferrers()) {
                if (!p.isUsable() || !(p instanceof Way) || !((Way)p).isFirstLastNode(selectedNode)) continue;
                if (selectedWay != null) {
                    selectedWay = null;
                    break;
                }
                selectedWay = (Way)p;
            }
        }
        if (selectedNode == null) {
            if (selectedWay == null) {
                return;
            }
            this.continueWayFromNode((Way)selectedWay, this.lastUsedNode);
        } else if (selectedWay == null) {
            this.currentBaseNode = selectedNode;
        } else if (!selectedWay.isDeleted()) {
            this.continueWayFromNode((Way)selectedWay, selectedNode);
        }
    }

    private void continueWayFromNode(Way way, Node node) {
        int n = way.getNodesCount();
        if (node == way.firstNode()) {
            this.currentBaseNode = node;
            if (n > 1) {
                this.previousNode = way.getNode(1);
            }
        } else if (node == way.lastNode()) {
            this.currentBaseNode = node;
            if (n > 1) {
                this.previousNode = way.getNode(n - 2);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.mousePos = e.getPoint();
        this.snapHelper.noSnapNow();
        boolean repaintIssued = this.removeHighlighting();
        if (!repaintIssued) {
            Main.map.mapView.repaint();
        }
    }

    public static Way getWayForNode(Node n) {
        Way way = null;
        for (Way w : Utils.filteredCollection(n.getReferrers(), Way.class)) {
            if (!w.isUsable() || w.getNodesCount() < 1) continue;
            Node firstNode = w.getNode(0);
            Node lastNode = w.getNode(w.getNodesCount() - 1);
            if (firstNode != n && lastNode != n || firstNode == lastNode) continue;
            if (way != null) {
                return null;
            }
            way = w;
        }
        return way;
    }

    public Node getCurrentBaseNode() {
        if (!(this.currentBaseNode == null || this.currentBaseNode.getDataSet() != null && this.currentBaseNode.isUsable())) {
            this.currentBaseNode = null;
        }
        return this.currentBaseNode;
    }

    private static void pruneSuccsAndReverse(List<Integer> is) {
        HashSet<Integer> is2 = new HashSet<Integer>();
        for (int i : is) {
            if (is2.contains(i - 1) || is2.contains(i + 1)) continue;
            is2.add(i);
        }
        is.clear();
        is.addAll(is2);
        Collections.sort(is);
        Collections.reverse(is);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> segs, Node n) {
        double q;
        EastNorth B;
        EastNorth A2;
        Pair<Node, Node> seg;
        switch (segs.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> i = segs.iterator();
                seg = i.next();
                A2 = ((Node)seg.a).getEastNorth();
                B = ((Node)seg.b).getEastNorth();
                seg = i.next();
                EastNorth C = ((Node)seg.a).getEastNorth();
                EastNorth D = ((Node)seg.b).getEastNorth();
                double u = DrawAction.det(B.east() - A2.east(), B.north() - A2.north(), C.east() - D.east(), C.north() - D.north());
                if (u == 0.0) {
                    return;
                }
                q = DrawAction.det(B.north() - C.north(), B.east() - C.east(), D.north() - C.north(), D.east() - C.east()) / u;
                EastNorth intersection = new EastNorth(B.east() + q * (A2.east() - B.east()), B.north() + q * (A2.north() - B.north()));
                if (!(Main.map.mapView.getPoint2D(n).distance(Main.map.mapView.getPoint2D(intersection)) < (double)snapToIntersectionThreshold)) break;
                n.setEastNorth(intersection);
                return;
            }
        }
        EastNorth P = n.getEastNorth();
        seg = segs.iterator().next();
        A2 = ((Node)seg.a).getEastNorth();
        B = ((Node)seg.b).getEastNorth();
        double a = P.distanceSq(B);
        double b = P.distanceSq(A2);
        double c = A2.distanceSq(B);
        q = (a - b + c) / (2.0 * c);
        n.setEastNorth(new EastNorth(B.east() + q * (A2.east() - B.east()), B.north() + q * (A2.north() - B.north())));
    }

    static double det(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    private void tryToMoveNodeOnIntersection(List<WaySegment> wss, Node n) {
        EastNorth xPoint;
        if (wss.isEmpty()) {
            return;
        }
        WaySegment ws = wss.get(0);
        EastNorth p1 = ws.getFirstNode().getEastNorth();
        EastNorth p2 = ws.getSecondNode().getEastNorth();
        if (this.snapHelper.dir2 != null && this.getCurrentBaseNode() != null && (xPoint = Geometry.getSegmentSegmentIntersection(p1, p2, this.snapHelper.dir2, this.getCurrentBaseNode().getEastNorth())) != null) {
            n.setEastNorth(xPoint);
        }
    }

    private void addHighlighting() {
        this.newHighlights = new HashSet<OsmPrimitive>();
        if (this.ctrl) {
            Main.map.mapView.setNewCursor(this.cursor, (Object)this);
            this.redrawIfRequired();
            return;
        }
        if (this.mouseOnExistingNode == null && DrawAction.getCurrentDataSet().getSelected().isEmpty() && this.mousePos != null) {
            this.mouseOnExistingNode = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (this.mouseOnExistingNode != null) {
            Main.map.mapView.setNewCursor(this.cursorJoinNode, (Object)this);
            this.newHighlights.add(this.mouseOnExistingNode);
            this.redrawIfRequired();
            return;
        }
        if (this.mouseOnExistingWays.isEmpty()) {
            Main.map.mapView.setNewCursor(this.cursor, (Object)this);
            this.redrawIfRequired();
            return;
        }
        Main.map.mapView.setNewCursor(this.cursorJoinWay, (Object)this);
        this.newHighlights.addAll(this.mouseOnExistingWays);
        this.redrawIfRequired();
    }

    private boolean removeHighlighting() {
        this.newHighlights = new HashSet<OsmPrimitive>();
        return this.redrawIfRequired();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (Main.map.mapView == null || this.mousePos == null || this.getCurrentBaseNode() == null || this.currentMouseEastNorth == null || !Main.map.mapView.getBounds().contains(this.mousePos)) {
            return;
        }
        Graphics2D g2 = g;
        this.snapHelper.drawIfNeeded(g2, mv);
        if (!this.drawHelperLine || this.wayIsFinished || this.shift) {
            return;
        }
        if (!this.snapHelper.isActive()) {
            g2.setColor(this.rubberLineColor);
            g2.setStroke(this.rubberLineStroke);
        } else if (!this.snapHelper.drawConstructionGeometry) {
            return;
        }
        GeneralPath b = new GeneralPath();
        Point p1 = mv.getPoint(this.getCurrentBaseNode());
        Point p2 = mv.getPoint(this.currentMouseEastNorth);
        double t = Math.atan2(p2.y - p1.y, p2.x - p1.x) + Math.PI;
        b.moveTo(p1.x, p1.y);
        b.lineTo(p2.x, p2.y);
        if (this.alt) {
            b.moveTo((int)((double)p1.x + 8.0 * Math.cos(t + PHI)), (int)((double)p1.y + 8.0 * Math.sin(t + PHI)));
            b.lineTo((int)((double)p1.x + 8.0 * Math.cos(t - PHI)), (int)((double)p1.y + 8.0 * Math.sin(t - PHI)));
        }
        g2.draw(b);
        g2.setStroke(BASIC_STROKE);
    }

    @Override
    public String getModeHelpText() {
        Node n;
        OsmPrimitive x;
        StringBuilder rv = this.ctrl || this.oldHighlights.isEmpty() ? new StringBuilder(I18n.tr("Create new node.", new Object[0])) : ((x = this.oldHighlights.iterator().next()) instanceof Node ? new StringBuilder(I18n.tr("Select node under cursor.", new Object[0])) : new StringBuilder(I18n.trn("Insert new node into way.", "Insert new node into {0} ways.", this.oldHighlights.size(), this.oldHighlights.size())));
        if (this.getCurrentBaseNode() != null && !this.wayIsFinished) {
            if (this.alt) {
                rv.append(" ").append(I18n.tr("Start new way from last node.", new Object[0]));
            } else {
                rv.append(" ").append(I18n.tr("Continue way from last node.", new Object[0]));
            }
            if (this.snapHelper.isSnapOn()) {
                rv.append(" ").append(I18n.tr("Angle snapping active.", new Object[0]));
            }
        }
        if ((n = this.mouseOnExistingNode) != null && DrawAction.getCurrentDataSet() != null && DrawAction.getCurrentDataSet().getSelectedNodes().contains(n)) {
            rv = this.wayIsFinished ? new StringBuilder(I18n.tr("Select node under cursor.", new Object[0])) : new StringBuilder(I18n.tr("Finish drawing.", new Object[0]));
        }
        if (!(DrawAction.getCurrentDataSet() == null || DrawAction.getCurrentDataSet().getSelectedWays().isEmpty() || this.wayIsFinished || this.alt)) {
            Way w = DrawAction.getCurrentDataSet().getSelectedWays().iterator().next();
            for (Node m : w.getNodes()) {
                if (!m.equals(this.mouseOnExistingNode) && !this.mouseOnExistingWays.contains(w)) continue;
                rv.append(" ").append(I18n.tr("Finish drawing.", new Object[0]));
                break;
            }
        }
        return rv.toString();
    }

    public Collection<OsmPrimitive> getInProgressSelection() {
        Way continueFrom;
        DataSet ds = DrawAction.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        if (this.getCurrentBaseNode() != null && !ds.getSelected().isEmpty() && (continueFrom = DrawAction.getWayForNode(this.getCurrentBaseNode())) != null) {
            return Collections.singleton(continueFrom);
        }
        return ds.getSelected();
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(DrawAction.getEditLayer() != null);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.snapChangeAction.destroy();
    }

    private class SnapChangeAction
    extends JosmAction {
        public SnapChangeAction() {
            super(I18n.tr("Angle snapping", new Object[0]), "anglesnap", I18n.tr("Switch angle snapping mode while drawing", new Object[0]), null, false);
            this.putValue("help", HelpUtil.ht("/Action/Draw/AngleSnap"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DrawAction.this.snapHelper != null) {
                DrawAction.this.snapHelper.toggleSnapping();
            }
        }
    }

    private class SnapHelper {
        boolean snapOn;
        private boolean active;
        private boolean fixed;
        private boolean absoluteFix;
        private boolean drawConstructionGeometry;
        private boolean showProjectedPoint;
        private boolean showAngle;
        private boolean snapToProjections;
        EastNorth dir2;
        EastNorth projected;
        String labelText;
        double lastAngle;
        double customBaseHeading = -1.0;
        private EastNorth segmentPoint1;
        private EastNorth segmentPoint2;
        private EastNorth projectionSource;
        double[] snapAngles;
        double snapAngleTolerance;
        double pe;
        double pn;
        double e0;
        double n0;
        final String fixFmt = "%d " + I18n.tr("FIX", new Object[0]);
        Color snapHelperColor;
        private Color highlightColor;
        private Stroke normalStroke;
        private Stroke helperStroke;
        private Stroke highlightStroke;
        JCheckBoxMenuItem checkBox;
        public final Color ORANGE_TRANSPARENT = new Color(Color.ORANGE.getRed(), Color.ORANGE.getGreen(), Color.ORANGE.getBlue(), 128);
        MouseListener anglePopupListener = new PopupMenuLauncher(new JPopupMenu(){
            JCheckBoxMenuItem repeatedCb;
            JCheckBoxMenuItem helperCb;
            JCheckBoxMenuItem projectionCb;
            {
                this.repeatedCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Toggle snapping by {0}", DrawAction.this.getShortcut().getKeyText())){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                        Main.pref.put("draw.anglesnap.toggleOnRepeatedA", sel);
                        SnapHelper.this.init();
                    }
                });
                this.helperCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Show helper geometry", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                        Main.pref.put("draw.anglesnap.drawConstructionGeometry", sel);
                        Main.pref.put("draw.anglesnap.drawProjectedPoint", sel);
                        Main.pref.put("draw.anglesnap.showAngle", sel);
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
                this.projectionCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Snap to node projections", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                        Main.pref.put("draw.anglesnap.projectionsnap", sel);
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
                this.helperCb.setState(Main.pref.getBoolean("draw.anglesnap.drawConstructionGeometry", true));
                this.projectionCb.setState(Main.pref.getBoolean("draw.anglesnap.projectionsnapgvff", true));
                this.repeatedCb.setState(Main.pref.getBoolean("draw.anglesnap.toggleOnRepeatedA", true));
                this.add(this.repeatedCb);
                this.add(this.helperCb);
                this.add(this.projectionCb);
                this.add(new AbstractAction(I18n.tr("Disable", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SnapHelper.this.saveAngles("180");
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
                this.add(new AbstractAction(I18n.tr("0,90,...", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SnapHelper.this.saveAngles("0", "90", "180");
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
                this.add(new AbstractAction(I18n.tr("0,45,90,...", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SnapHelper.this.saveAngles("0", "45", "90", "135", "180");
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
                this.add(new AbstractAction(I18n.tr("0,30,45,60,90,...", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SnapHelper.this.saveAngles("0", "30", "45", "60", "90", "120", "135", "150", "180");
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
            }
        }){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 1) {
                    SnapHelper.this.toggleSnapping();
                    DrawAction.this.updateStatusLine();
                }
            }
        };

        private SnapHelper() {
        }

        public void init() {
            this.snapOn = false;
            this.checkBox.setState(this.snapOn);
            this.fixed = false;
            this.absoluteFix = false;
            Collection<String> angles = Main.pref.getCollection("draw.anglesnap.angles", Arrays.asList("0", "30", "45", "60", "90", "120", "135", "150", "180"));
            this.snapAngles = new double[2 * angles.size()];
            int i = 0;
            for (String s : angles) {
                try {
                    this.snapAngles[i] = Double.parseDouble(s);
                    this.snapAngles[++i] = 360.0 - Double.parseDouble(s);
                    ++i;
                }
                catch (NumberFormatException e) {
                    Main.warn("Incorrect number in draw.anglesnap.angles preferences: " + s);
                    this.snapAngles[i] = 0.0;
                    this.snapAngles[++i] = 0.0;
                    ++i;
                }
            }
            this.snapAngleTolerance = Main.pref.getDouble("draw.anglesnap.tolerance", 5.0);
            this.drawConstructionGeometry = Main.pref.getBoolean("draw.anglesnap.drawConstructionGeometry", true);
            this.showProjectedPoint = Main.pref.getBoolean("draw.anglesnap.drawProjectedPoint", true);
            this.snapToProjections = Main.pref.getBoolean("draw.anglesnap.projectionsnap", true);
            this.showAngle = Main.pref.getBoolean("draw.anglesnap.showAngle", true);
            DrawAction.this.useRepeatedShortcut = Main.pref.getBoolean("draw.anglesnap.toggleOnRepeatedA", true);
            this.normalStroke = DrawAction.this.rubberLineStroke;
            this.snapHelperColor = Main.pref.getColor(I18n.marktr("draw angle snap"), Color.ORANGE);
            this.highlightColor = Main.pref.getColor(I18n.marktr("draw angle snap highlight"), this.ORANGE_TRANSPARENT);
            this.highlightStroke = GuiHelper.getCustomizedStroke(Main.pref.get("draw.anglesnap.stroke.highlight", "10"));
            this.helperStroke = GuiHelper.getCustomizedStroke(Main.pref.get("draw.anglesnap.stroke.helper", "1 4"));
        }

        public void saveAngles(String ... angles) {
            Main.pref.putCollection("draw.anglesnap.angles", Arrays.asList(angles));
        }

        public void setMenuCheckBox(JCheckBoxMenuItem checkBox) {
            this.checkBox = checkBox;
        }

        public void drawIfNeeded(Graphics2D g2, MapView mv) {
            GeneralPath b;
            if (!this.snapOn || !this.active) {
                return;
            }
            Point p1 = mv.getPoint(DrawAction.this.getCurrentBaseNode());
            Point p2 = mv.getPoint(this.dir2);
            Point p3 = mv.getPoint(this.projected);
            if (this.drawConstructionGeometry) {
                g2.setColor(this.snapHelperColor);
                g2.setStroke(this.helperStroke);
                b = new GeneralPath();
                if (this.absoluteFix) {
                    b.moveTo(p2.x, p2.y);
                    b.lineTo(2 * p1.x - p2.x, 2 * p1.y - p2.y);
                } else {
                    b.moveTo(p2.x, p2.y);
                    b.lineTo(p3.x, p3.y);
                }
                g2.draw(b);
            }
            if (this.projectionSource != null) {
                g2.setColor(this.snapHelperColor);
                g2.setStroke(this.helperStroke);
                b = new GeneralPath();
                b.moveTo(p3.x, p3.y);
                Point pp = mv.getPoint(this.projectionSource);
                b.lineTo(pp.x, pp.y);
                g2.draw(b);
            }
            if (this.customBaseHeading >= 0.0) {
                g2.setColor(this.highlightColor);
                g2.setStroke(this.highlightStroke);
                b = new GeneralPath();
                Point pp1 = mv.getPoint(this.segmentPoint1);
                Point pp2 = mv.getPoint(this.segmentPoint2);
                b.moveTo(pp1.x, pp1.y);
                b.lineTo(pp2.x, pp2.y);
                g2.draw(b);
            }
            g2.setColor(DrawAction.this.rubberLineColor);
            g2.setStroke(this.normalStroke);
            b = new GeneralPath();
            b.moveTo(p1.x, p1.y);
            b.lineTo(p3.x, p3.y);
            g2.draw(b);
            g2.drawString(this.labelText, p3.x - 5, p3.y + 20);
            if (this.showProjectedPoint) {
                g2.setStroke(this.normalStroke);
                g2.drawOval(p3.x - 5, p3.y - 5, 10, 10);
            }
            g2.setColor(this.snapHelperColor);
            g2.setStroke(this.helperStroke);
        }

        public void checkAngleSnapping(EastNorth currentEN, double baseHeading, double curHeading) {
            double activeBaseHeading;
            EastNorth p0 = DrawAction.this.getCurrentBaseNode().getEastNorth();
            EastNorth snapPoint = currentEN;
            double angle = -1.0;
            double d = activeBaseHeading = this.customBaseHeading >= 0.0 ? this.customBaseHeading : baseHeading;
            if (this.snapOn && activeBaseHeading >= 0.0) {
                double nearestAngle;
                angle = curHeading - activeBaseHeading;
                if (angle < 0.0) {
                    angle += 360.0;
                }
                if (angle > 360.0) {
                    angle = 0.0;
                }
                if (this.fixed) {
                    nearestAngle = this.lastAngle;
                    this.active = true;
                } else {
                    nearestAngle = this.getNearestAngle(angle);
                    if (this.getAngleDelta(nearestAngle, angle) < this.snapAngleTolerance) {
                        this.active = this.customBaseHeading >= 0.0 ? true : Math.abs(nearestAngle - 180.0) > 0.001;
                        this.lastAngle = nearestAngle;
                    } else {
                        this.active = false;
                    }
                }
                if (this.active) {
                    this.e0 = p0.east();
                    this.n0 = p0.north();
                    this.buildLabelText(nearestAngle <= 180.0 ? nearestAngle : nearestAngle - 360.0);
                    double phi = (nearestAngle + activeBaseHeading) * Math.PI / 180.0;
                    this.pe = Math.sin(phi);
                    this.pn = Math.cos(phi);
                    double scale = 20.0 * Main.map.mapView.getDist100Pixel();
                    this.dir2 = new EastNorth(this.e0 + scale * this.pe, this.n0 + scale * this.pn);
                    snapPoint = this.getSnapPoint(currentEN);
                } else {
                    this.noSnapNow();
                }
            }
            LatLon mouseLatLon = Main.map.mapView.getProjection().eastNorth2latlon(snapPoint);
            double distance = DrawAction.this.getCurrentBaseNode().getCoor().greatCircleDistance(mouseLatLon);
            double hdg = Math.toDegrees(p0.heading(snapPoint));
            if (baseHeading >= 0.0) {
                angle = hdg - baseHeading;
                if (angle < 0.0) {
                    angle += 360.0;
                }
                if (angle > 360.0) {
                    angle = 0.0;
                }
            }
            DrawAction.this.showStatusInfo(angle, hdg, distance, this.isSnapOn());
        }

        private void buildLabelText(double nearestAngle) {
            this.labelText = this.showAngle ? (this.fixed ? (this.absoluteFix ? "=" : String.format(this.fixFmt, (int)nearestAngle)) : String.format("%d", (int)nearestAngle)) : (this.fixed ? (this.absoluteFix ? "=" : String.format(I18n.tr("FIX", new Object[0]), 0)) : "");
        }

        public EastNorth getSnapPoint(EastNorth p) {
            DataSet ds;
            Collection<Way> selectedWays;
            if (!this.active) {
                return p;
            }
            double de = p.east() - this.e0;
            double dn = p.north() - this.n0;
            double l = de * this.pe + dn * this.pn;
            double delta = Main.map.mapView.getDist100Pixel() / 20.0;
            if (!this.absoluteFix && l < delta) {
                this.active = false;
                return p;
            }
            this.projectionSource = null;
            if (this.snapToProjections && (selectedWays = (ds = DrawAction.getCurrentDataSet()).getSelectedWays()).size() == 1) {
                Way w = selectedWays.iterator().next();
                ArrayList<EastNorth> pointsToProject = new ArrayList<EastNorth>();
                if (w.getNodesCount() < 1000) {
                    for (Node n : w.getNodes()) {
                        pointsToProject.add(n.getEastNorth());
                    }
                }
                if (this.customBaseHeading >= 0.0) {
                    pointsToProject.add(this.segmentPoint1);
                    pointsToProject.add(this.segmentPoint2);
                }
                EastNorth enOpt = null;
                double dOpt = 100000.0;
                for (EastNorth en : pointsToProject) {
                    double l1 = (en.east() - this.e0) * this.pe + (en.north() - this.n0) * this.pn;
                    double d1 = Math.abs(l1 - l);
                    if (!(d1 < delta) || !(d1 < dOpt)) continue;
                    l = l1;
                    enOpt = en;
                    dOpt = d1;
                }
                if (enOpt != null) {
                    this.projectionSource = enOpt;
                }
            }
            this.projected = new EastNorth(this.e0 + l * this.pe, this.n0 + l * this.pn);
            return this.projected;
        }

        public void noSnapNow() {
            this.active = false;
            this.dir2 = null;
            this.projected = null;
            this.labelText = null;
        }

        public void setBaseSegment(WaySegment seg) {
            if (seg == null) {
                return;
            }
            this.segmentPoint1 = seg.getFirstNode().getEastNorth();
            this.segmentPoint2 = seg.getSecondNode().getEastNorth();
            double hdg = this.segmentPoint1.heading(this.segmentPoint2);
            if ((hdg = Math.toDegrees(hdg)) < 0.0) {
                hdg += 360.0;
            }
            if (hdg > 360.0) {
                hdg -= 360.0;
            }
            this.customBaseHeading = hdg;
        }

        private void enableSnapping() {
            this.snapOn = true;
            this.checkBox.setState(this.snapOn);
            this.customBaseHeading = -1.0;
            this.unsetFixedMode();
        }

        private void toggleSnapping() {
            this.snapOn = !this.snapOn;
            this.checkBox.setState(this.snapOn);
            this.customBaseHeading = -1.0;
            this.unsetFixedMode();
        }

        public void setFixedMode() {
            if (this.active) {
                this.fixed = true;
            }
        }

        public void unsetFixedMode() {
            this.fixed = false;
            this.absoluteFix = false;
            this.lastAngle = 0.0;
            this.active = false;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isSnapOn() {
            return this.snapOn;
        }

        private double getNearestAngle(double angle) {
            double minDelta = 100000.0;
            double bestAngle = 0.0;
            for (double snapAngle : this.snapAngles) {
                double delta = this.getAngleDelta(angle, snapAngle);
                if (!(delta < minDelta)) continue;
                minDelta = delta;
                bestAngle = snapAngle;
            }
            if (Math.abs(bestAngle - 360.0) < 0.001) {
                bestAngle = 0.0;
            }
            return bestAngle;
        }

        private double getAngleDelta(double a, double b) {
            double delta = Math.abs(a - b);
            if (delta > 180.0) {
                return 360.0 - delta;
            }
            return delta;
        }

        private void unFixOrTurnOff() {
            if (this.absoluteFix) {
                this.unsetFixedMode();
            } else {
                this.toggleSnapping();
            }
        }
    }

    public class BackSpaceAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Main.main.undoRedo.undo();
            Node n = null;
            Command lastCmd = Main.main.undoRedo.commands.peekLast();
            if (lastCmd == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : lastCmd.getParticipatingPrimitives()) {
                if (!(osmPrimitive instanceof Node)) continue;
                if (n == null) {
                    n = (Node)osmPrimitive;
                    DrawAction.this.wayIsFinished = false;
                    continue;
                }
                n = null;
                break;
            }
            if (n != null) {
                DrawAction.getCurrentDataSet().addSelected(n);
            }
        }
    }
}

