/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DeleteAction
extends MapMode
implements ModifierListener {
    private MouseEvent oldEvent = null;
    private WaySegment oldHighlightedWaySegment = null;
    private static final HighlightHelper highlightHelper = new HighlightHelper();
    private boolean drawTargetHighlight;

    public DeleteAction(MapFrame mapFrame) {
        super(I18n.tr("Delete Mode", new Object[0]), "delete", I18n.tr("Delete nodes or ways.", new Object[0]), Shortcut.registerShortcut("mapmode:delete", I18n.tr("Mode: {0}", I18n.tr("Delete", new Object[0])), 127, 5006), mapFrame, ImageProvider.getCursor("normal", "delete"));
    }

    @Override
    public void enterMode() {
        super.enterMode();
        if (!this.isEnabled()) {
            return;
        }
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.keyDetector.addModifierListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.keyDetector.removeModifierListener(this);
        this.removeHighlighting();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        DeleteAction.doActionPerformed(e);
    }

    public static void doActionPerformed(ActionEvent e) {
        boolean alt;
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean ctrl = (e.getModifiers() & 2) != 0;
        boolean bl = alt = (e.getModifiers() & 0x28) != 0;
        Command c = ctrl ? DeleteCommand.deleteWithReferences(DeleteAction.getEditLayer(), DeleteAction.getCurrentDataSet().getSelected()) : DeleteCommand.delete(DeleteAction.getEditLayer(), DeleteAction.getCurrentDataSet().getSelected(), !alt);
        if (c != null) {
            Main.main.undoRedo.add(c);
            DeleteAction.getCurrentDataSet().setSelected(new PrimitiveId[0]);
            Main.map.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.oldEvent = e;
        this.giveUserFeedback(e);
    }

    private void removeHighlighting() {
        highlightHelper.clear();
        DataSet ds = DeleteAction.getCurrentDataSet();
        if (ds != null) {
            ds.clearHighlightedWaySegments();
        }
    }

    private void addHighlighting(MouseEvent e, int modifiers) {
        if (!this.drawTargetHighlight) {
            return;
        }
        HashSet<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
        DeleteParameters parameters = this.getDeleteParameters(e, modifiers);
        if (parameters.mode == DeleteMode.segment) {
            this.repaintIfRequired(newHighlights, parameters.nearestSegment);
        } else {
            Command delCmd = this.buildDeleteCommands(e, modifiers, true);
            if (delCmd != null) {
                for (OsmPrimitive osmPrimitive : delCmd.getParticipatingPrimitives()) {
                    newHighlights.add(osmPrimitive);
                }
            }
            this.repaintIfRequired(newHighlights, null);
        }
    }

    private void repaintIfRequired(Set<OsmPrimitive> newHighlights, WaySegment newHighlightedWaySegment) {
        boolean needsRepaint = false;
        DataSet ds = DeleteAction.getCurrentDataSet();
        if (newHighlightedWaySegment == null && this.oldHighlightedWaySegment != null) {
            if (ds != null) {
                ds.clearHighlightedWaySegments();
                needsRepaint = true;
            }
            this.oldHighlightedWaySegment = null;
        } else if (newHighlightedWaySegment != null && !newHighlightedWaySegment.equals(this.oldHighlightedWaySegment)) {
            if (ds != null) {
                ds.setHighlightedWaySegments(Collections.singleton(newHighlightedWaySegment));
                needsRepaint = true;
            }
            this.oldHighlightedWaySegment = newHighlightedWaySegment;
        }
        if (needsRepaint |= highlightHelper.highlightOnly(newHighlights)) {
            Main.map.mapView.repaint();
        }
    }

    private void updateCursor(MouseEvent e, int modifiers) {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible() || e == null) {
            return;
        }
        DeleteParameters parameters = this.getDeleteParameters(e, modifiers);
        Main.map.mapView.setNewCursor(parameters.mode.cursor(), (Object)this);
    }

    private void giveUserFeedback(MouseEvent e, int modifiers) {
        this.updateCursor(e, modifiers);
        this.addHighlighting(e, modifiers);
    }

    private void giveUserFeedback(MouseEvent e) {
        this.giveUserFeedback(e, e.getModifiers());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        Main.map.mapView.requestFocus();
        Command c = this.buildDeleteCommands(e, e.getModifiers(), false);
        if (c != null) {
            Main.main.undoRedo.add(c);
        }
        DeleteAction.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        this.giveUserFeedback(e);
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click to delete. Shift: delete way segment. Alt: do not delete unused nodes when deleting a way. Ctrl: delete referring objects.", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.isActiveLayerDrawable());
    }

    public static void deleteRelation(OsmDataLayer layer, Relation toDelete) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        CheckParameterUtil.ensureParameterNotNull(toDelete, "toDelete");
        Command cmd = DeleteCommand.delete(layer, Collections.singleton(toDelete));
        if (cmd != null) {
            Main.main.undoRedo.add(cmd);
            if (DeleteAction.getCurrentDataSet().getSelectedRelations().contains(toDelete)) {
                DeleteAction.getCurrentDataSet().toggleSelected(toDelete);
            }
            RelationDialogManager.getRelationDialogManager().close(layer, toDelete);
        }
    }

    private DeleteParameters getDeleteParameters(MouseEvent e, int modifiers) {
        this.updateKeyModifiers(modifiers);
        DeleteParameters result = new DeleteParameters();
        result.nearestNode = Main.map.mapView.getNearestNode(e.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (result.nearestNode == null) {
            result.nearestSegment = Main.map.mapView.getNearestWaySegment(e.getPoint(), OsmPrimitive.isSelectablePredicate);
            result.mode = result.nearestSegment != null ? (this.shift ? DeleteMode.segment : (this.ctrl ? DeleteMode.way_with_references : (this.alt ? DeleteMode.way : DeleteMode.way_with_nodes))) : DeleteMode.none;
        } else {
            result.mode = this.ctrl ? DeleteMode.node_with_references : DeleteMode.node;
        }
        return result;
    }

    private Command buildDeleteCommands(MouseEvent e, int modifiers, boolean silent) {
        DeleteParameters parameters = this.getDeleteParameters(e, modifiers);
        switch (parameters.mode) {
            case node: {
                return DeleteCommand.delete(DeleteAction.getEditLayer(), Collections.singleton(parameters.nearestNode), false, silent);
            }
            case node_with_references: {
                return DeleteCommand.deleteWithReferences(DeleteAction.getEditLayer(), Collections.singleton(parameters.nearestNode), silent);
            }
            case segment: {
                return DeleteCommand.deleteWaySegment(DeleteAction.getEditLayer(), parameters.nearestSegment);
            }
            case way: {
                return DeleteCommand.delete(DeleteAction.getEditLayer(), Collections.singleton(parameters.nearestSegment.way), false, silent);
            }
            case way_with_nodes: {
                return DeleteCommand.delete(DeleteAction.getEditLayer(), Collections.singleton(parameters.nearestSegment.way), true, silent);
            }
            case way_with_references: {
                return DeleteCommand.deleteWithReferences(DeleteAction.getEditLayer(), Collections.singleton(parameters.nearestSegment.way), true);
            }
        }
        return null;
    }

    @Override
    public void modifiersChanged(int modifiers) {
        if (this.oldEvent == null) {
            return;
        }
        this.giveUserFeedback(this.oldEvent, modifiers);
    }

    private static class DeleteParameters {
        DeleteMode mode;
        Node nearestNode;
        WaySegment nearestSegment;

        private DeleteParameters() {
        }
    }

    private static enum DeleteMode {
        none("delete"),
        segment("delete_segment"),
        node("delete_node"),
        node_with_references("delete_node"),
        way("delete_way_only"),
        way_with_references("delete_way_normal"),
        way_with_nodes("delete_way_node_only");

        private final Cursor c;

        private DeleteMode(String cursorName) {
            this.c = ImageProvider.getCursor("normal", cursorName);
        }

        public Cursor cursor() {
            return this.c;
        }
    }
}

