/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.event.MouseEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.NoteInputDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.NotesDialog;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddNoteAction
extends MapMode {
    private NoteData noteData;

    public AddNoteAction(MapFrame mapFrame, NoteData data) {
        super(I18n.tr("Add a new Note", new Object[0]), "addnote", I18n.tr("Add note mode", new Object[0]), mapFrame, ImageProvider.getCursor("crosshair", "create_note"));
        CheckParameterUtil.ensureParameterNotNull(data, "data");
        this.noteData = data;
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click the location where you wish to create a new note", new Object[0]);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Main.map.selectMapMode(Main.map.mapModeSelect);
        LatLon latlon = Main.map.mapView.getLatLon(e.getPoint().x, e.getPoint().y);
        NoteInputDialog dialog = new NoteInputDialog(Main.parent, I18n.tr("Create new note", new Object[0]), I18n.tr("Create note", new Object[0]));
        dialog.showNoteDialog(I18n.tr("Enter a detailed comment to create a note", new Object[0]), NotesDialog.ICON_NEW);
        if (dialog.getValue() != 1) {
            Main.debug("User aborted note creation");
            return;
        }
        String input = dialog.getInputText();
        if (input != null && !input.isEmpty()) {
            this.noteData.createNote(latlon, input);
        } else {
            Notification notification = new Notification(I18n.tr("You must enter a comment to create a new note", new Object[0]));
            notification.setIcon(2);
            notification.show();
        }
    }
}

