/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PostDownloadHandler
implements Runnable {
    private DownloadTask task;
    private List<Future<?>> futures;

    public PostDownloadHandler(DownloadTask task, Future<?> future) {
        this.task = task;
        this.futures = new ArrayList();
        if (future != null) {
            this.futures.add(future);
        }
    }

    public PostDownloadHandler(DownloadTask task, Future<?> ... futures) {
        this.task = task;
        this.futures = new ArrayList();
        if (futures == null) {
            return;
        }
        for (Future<?> future : futures) {
            this.futures.add(future);
        }
    }

    public PostDownloadHandler(DownloadTask task, List<Future<?>> futures) {
        this.task = task;
        this.futures = new ArrayList();
        if (futures == null) {
            return;
        }
        this.futures.addAll(futures);
    }

    @Override
    public void run() {
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                Main.error(e);
                return;
            }
        }
        LinkedHashSet<Object> errors = new LinkedHashSet<Object>();
        errors.addAll(this.task.getErrorObjects());
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            final Object error = errors.iterator().next();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (error instanceof Exception) {
                        ExceptionDialogUtil.explainException((Exception)error);
                    } else {
                        JOptionPane.showMessageDialog(Main.parent, error.toString(), I18n.tr("Error during download", new Object[0]), 0);
                    }
                }
            });
            return;
        }
        if (!errors.isEmpty()) {
            final ArrayList<String> items = new ArrayList<String>();
            for (Object e : errors) {
                if (e instanceof String) {
                    items.add((String)e);
                    continue;
                }
                if (!(e instanceof Exception)) continue;
                items.add(ExceptionUtil.explainException((Exception)e));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Main.parent, "<html>" + Utils.joinAsHtmlUnorderedList(items) + "</html>", I18n.tr("Errors during download", new Object[0]), 0);
                }
            });
            return;
        }
    }
}

