/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SessionLoadAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DownloadSessionTask
extends AbstractDownloadTask {
    private SessionLoadAction.Loader loader;

    @Override
    public String getTitle() {
        return I18n.tr("Download session", new Object[0]);
    }

    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/.*\\.jo(s|z)"};
    }

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean newLayer, String url, ProgressMonitor progressMonitor) {
        if (url != null && url.matches("https?://.*/.*\\.jo(s|z)")) {
            try {
                URL u = new URL(url);
                this.loader = new SessionLoadAction.Loader(Utils.openURL(u), u.toURI(), url.endsWith(".joz"));
                return Main.worker.submit(this.loader);
            }
            catch (IOException | URISyntaxException e) {
                Main.error(e);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.loader != null) {
            this.loader.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL url) {
        return null;
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return Main.pref.getBoolean("remotecontrol.import.allow_session", false);
    }
}

