/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadOsmTask
extends AbstractDownloadTask {
    protected static final String PATTERN_OSM_API_URL = "https?://.*/api/0.6/(map|nodes?|ways?|relations?|\\*).*";
    protected static final String PATTERN_OVERPASS_API_URL = "https?://.*/interpreter\\?data=.*";
    protected static final String PATTERN_OVERPASS_API_XAPI_URL = "https?://.*/xapi(\\?.*\\[@meta\\]|_meta\\?).*";
    protected static final String PATTERN_EXTERNAL_OSM_FILE = "https?://.*/.*\\.osm";
    protected Bounds currentBounds;
    protected DataSet downloadedData;
    protected DownloadTask downloadTask;
    protected String newLayerName = null;

    @Override
    public String[] getPatterns() {
        if (this.getClass() == DownloadOsmTask.class) {
            return new String[]{PATTERN_OSM_API_URL, PATTERN_OVERPASS_API_URL, PATTERN_OVERPASS_API_XAPI_URL, PATTERN_EXTERNAL_OSM_FILE};
        }
        return super.getPatterns();
    }

    @Override
    public String getTitle() {
        if (this.getClass() == DownloadOsmTask.class) {
            return I18n.tr("Download OSM", new Object[0]);
        }
        return super.getTitle();
    }

    protected void rememberDownloadedData(DataSet ds) {
        this.downloadedData = ds;
    }

    public DataSet getDownloadedData() {
        return this.downloadedData;
    }

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return this.download(new BoundingBoxDownloader(downloadArea), newLayer, downloadArea, progressMonitor);
    }

    public Future<?> download(OsmServerReader reader, boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return this.download(new DownloadTask(newLayer, reader, progressMonitor), downloadArea);
    }

    protected Future<?> download(DownloadTask downloadTask, Bounds downloadArea) {
        this.downloadTask = downloadTask;
        this.currentBounds = new Bounds(downloadArea);
        return Main.worker.submit(downloadTask);
    }

    protected String modifyUrlBeforeLoad(String url) {
        return url;
    }

    @Override
    public Future<?> loadUrl(boolean new_layer, String url, ProgressMonitor progressMonitor) {
        url = this.modifyUrlBeforeLoad(url);
        this.downloadTask = new DownloadTask(new_layer, new OsmServerLocationReader(url), progressMonitor);
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osm)", url);
        return Main.worker.submit(this.downloadTask);
    }

    protected final void extractOsmFilename(String pattern, String url) {
        Matcher matcher = Pattern.compile(pattern).matcher(url);
        this.newLayerName = matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    @Override
    public String getConfirmationMessage(URL url) {
        String urlString;
        if (url != null && (urlString = url.toExternalForm()).matches(PATTERN_OSM_API_URL)) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(I18n.tr("OSM Server URL:", new Object[0]) + " " + url.getHost());
            items.add(I18n.tr("Command", new Object[0]) + ": " + url.getPath());
            if (url.getQuery() != null) {
                items.add(I18n.tr("Request details: {0}", url.getQuery().replaceAll(",\\s*", ", ")));
            }
            return Utils.joinAsHtmlUnorderedList(items);
        }
        return null;
    }

    protected class DownloadTask
    extends AbstractInternalTask {
        protected final OsmServerReader reader;

        public DownloadTask(boolean newLayer, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(newLayer, I18n.tr("Downloading data", new Object[0]), progressMonitor, false);
            this.reader = reader;
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadOsmTask.this.isCanceled()) {
                    return;
                }
                this.dataSet = this.parseDataSet();
            }
            catch (Exception e) {
                if (DownloadOsmTask.this.isCanceled()) {
                    Main.info(I18n.tr("Ignoring exception because download has been canceled. Exception was: {0}", e.toString()));
                    return;
                }
                if (e instanceof OsmTransferCanceledException) {
                    DownloadOsmTask.this.setCanceled(true);
                    return;
                }
                if (e instanceof OsmTransferException) {
                    DownloadOsmTask.this.rememberException(e);
                } else {
                    DownloadOsmTask.this.rememberException(new OsmTransferException(e));
                }
                DownloadOsmTask.this.setFailed(true);
            }
        }

        @Override
        protected void finish() {
            if (DownloadOsmTask.this.isFailed() || DownloadOsmTask.this.isCanceled()) {
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                DownloadOsmTask.this.rememberErrorMessage(I18n.tr("No data found in this area.", new Object[0]));
                this.dataSet.dataSources.add(new DataSource(DownloadOsmTask.this.currentBounds != null ? DownloadOsmTask.this.currentBounds : new Bounds(new LatLon(0.0, 0.0)), "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            this.loadData(DownloadOsmTask.this.newLayerName, DownloadOsmTask.this.currentBounds);
        }

        @Override
        protected void cancel() {
            DownloadOsmTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    public static abstract class AbstractInternalTask
    extends PleaseWaitRunnable {
        protected final boolean newLayer;
        protected DataSet dataSet;

        public AbstractInternalTask(boolean newLayer, String title, boolean ignoreException) {
            super(title, ignoreException);
            this.newLayer = newLayer;
        }

        public AbstractInternalTask(boolean newLayer, String title, ProgressMonitor progressMonitor, boolean ignoreException) {
            super(title, progressMonitor, ignoreException);
            this.newLayer = newLayer;
        }

        protected OsmDataLayer getEditLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.main.getEditLayer();
        }

        protected int getNumDataLayers() {
            int count = 0;
            if (!Main.isDisplayingMapView()) {
                return 0;
            }
            Collection<Layer> layers = Main.map.mapView.getAllLayers();
            for (Layer layer : layers) {
                if (!(layer instanceof OsmDataLayer)) continue;
                ++count;
            }
            return count;
        }

        protected OsmDataLayer getFirstDataLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            List<Layer> layers = Main.map.mapView.getAllLayersAsList();
            for (Layer layer : layers) {
                if (!(layer instanceof OsmDataLayer)) continue;
                return (OsmDataLayer)layer;
            }
            return null;
        }

        protected OsmDataLayer createNewLayer(String layerName) {
            if (layerName == null || layerName.isEmpty()) {
                layerName = OsmDataLayer.createNewName();
            }
            return new OsmDataLayer(this.dataSet, layerName, null);
        }

        protected OsmDataLayer createNewLayer() {
            return this.createNewLayer(null);
        }

        protected ProjectionBounds computeBbox(Bounds bounds) {
            BoundingXYVisitor v = new BoundingXYVisitor();
            if (bounds != null) {
                v.visit(bounds);
            } else {
                v.computeBoundingBox(this.dataSet.getNodes());
            }
            return v.getBounds();
        }

        protected void computeBboxAndCenterScale(Bounds bounds) {
            ProjectionBounds pb = this.computeBbox(bounds);
            BoundingXYVisitor v = new BoundingXYVisitor();
            v.visit(pb);
            Main.map.mapView.zoomTo(v);
        }

        protected OsmDataLayer addNewLayerIfRequired(String newLayerName, Bounds bounds) {
            int numDataLayers = this.getNumDataLayers();
            if (this.newLayer || numDataLayers == 0 || numDataLayers > 1 && this.getEditLayer() == null) {
                OsmDataLayer layer = this.createNewLayer(newLayerName);
                Main.main.addLayer((Layer)layer, this.computeBbox(bounds));
                return layer;
            }
            return null;
        }

        protected void loadData(String newLayerName, Bounds bounds) {
            OsmDataLayer layer = this.addNewLayerIfRequired(newLayerName, bounds);
            if (layer == null) {
                layer = this.getEditLayer();
                if (layer == null) {
                    layer = this.getFirstDataLayer();
                }
                layer.mergeFrom(this.dataSet);
                this.computeBboxAndCenterScale(bounds);
                layer.onPostDownloadFromServer();
            }
        }
    }
}

