/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmCompressedTask
extends DownloadOsmTask {
    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/.*\\.osm.(gz|bz2?|zip)"};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download Compressed OSM", new Object[0]);
    }

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean new_layer, final String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadOsmTask.DownloadTask(new_layer, new OsmServerLocationReader(url), progressMonitor){

            @Override
            protected DataSet parseDataSet() throws OsmTransferException {
                ProgressMonitor subTaskMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                if (url.matches("https?://.*/.*\\.osm.bz2?")) {
                    return this.reader.parseOsmBzip2(subTaskMonitor);
                }
                if (url.matches("https?://.*/.*\\.osm.gz")) {
                    return this.reader.parseOsmGzip(subTaskMonitor);
                }
                return this.reader.parseOsmZip(subTaskMonitor);
            }
        };
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osm.(gz|bz2?|zip))", url);
        return Main.worker.submit(this.downloadTask);
    }
}

