/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmChangeTask
extends DownloadOsmTask {
    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/api/0.6/changeset/\\p{Digit}+/download", "https?://.*/.*\\.osc"};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download OSM Change", new Object[0]);
    }

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean new_layer, String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(new_layer, (OsmServerReader)new OsmServerLocationReader(url), progressMonitor);
        this.extractOsmFilename("https?://.*/(.*\\.osc)", url);
        return Main.worker.submit(this.downloadTask);
    }

    private static class HistoryLoaderAndListener
    extends HistoryLoadTask
    implements HistoryDataSetListener {
        private final Map<OsmPrimitive, Date> toLoad;

        public HistoryLoaderAndListener(Map<OsmPrimitive, Date> toLoad) {
            this.toLoad = toLoad;
            this.add(toLoad.keySet());
            HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        }

        @Override
        public void historyUpdated(HistoryDataSet source, PrimitiveId id) {
            HashMap<OsmPrimitive, Date> toLoadNext = new HashMap<OsmPrimitive, Date>();
            Iterator<OsmPrimitive> it = this.toLoad.keySet().iterator();
            while (it.hasNext()) {
                HistoryOsmPrimitive hp;
                OsmPrimitive p = it.next();
                History history = source.getHistory(p.getPrimitiveId());
                Date date = this.toLoad.get(p);
                if (history == null || date == null || (hp = history.getByDate(date)) == null) continue;
                PrimitiveData data = null;
                switch (p.getType()) {
                    case NODE: {
                        data = new NodeData();
                        ((NodeData)data).setCoor(((HistoryNode)hp).getCoords());
                        break;
                    }
                    case WAY: {
                        data = new WayData();
                        List<Long> nodeIds = ((HistoryWay)hp).getNodes();
                        ((WayData)data).setNodes(nodeIds);
                        for (Long nodeId : nodeIds) {
                            if (p.getDataSet().getPrimitiveById(nodeId, OsmPrimitiveType.NODE) != null) continue;
                            Node n = new Node(nodeId);
                            p.getDataSet().addPrimitive(n);
                            toLoadNext.put(n, date);
                        }
                        break;
                    }
                    case RELATION: {
                        data = new RelationData();
                        List<RelationMemberData> members = ((HistoryRelation)hp).getMembers();
                        ((RelationData)data).setMembers(members);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unknown primitive type");
                    }
                }
                data.setUser(hp.getUser());
                try {
                    data.setVisible(hp.isVisible());
                }
                catch (IllegalStateException e) {
                    Main.error("Cannot change visibility for " + p + ": " + e.getMessage());
                }
                data.setTimestamp(hp.getTimestamp());
                data.setKeys(hp.getTags());
                data.setOsmId(hp.getId(), (int)hp.getVersion());
                try {
                    p.load(data);
                    it.remove();
                }
                catch (AssertionError e) {
                    Main.error("Cannot load " + p + ": " + ((Throwable)((Object)e)).getMessage());
                }
            }
            source.removeHistoryDataSetListener(this);
            if (toLoadNext.isEmpty()) {
                Main.map.repaint();
            } else {
                Main.worker.submit(new HistoryLoaderAndListener(toLoadNext));
            }
        }

        @Override
        public void historyDataSetCleared(HistoryDataSet source) {
        }
    }

    protected class DownloadTask
    extends DownloadOsmTask.DownloadTask {
        public DownloadTask(boolean newLayer, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(DownloadOsmChangeTask.this, newLayer, reader, progressMonitor);
        }

        @Override
        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsmChange(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        @Override
        protected void finish() {
            super.finish();
            if (DownloadOsmChangeTask.this.isFailed() || DownloadOsmChangeTask.this.isCanceled() || DownloadOsmChangeTask.this.downloadedData == null) {
                return;
            }
            try {
                HashMap<OsmPrimitive, Date> toLoad = new HashMap<OsmPrimitive, Date>();
                for (OsmPrimitive p : DownloadOsmChangeTask.this.downloadedData.allNonDeletedPrimitives()) {
                    if (!p.isIncomplete()) continue;
                    Date timestamp = null;
                    for (OsmPrimitive ref : p.getReferrers()) {
                        if (ref.isTimestampEmpty()) continue;
                        timestamp = ref.getTimestamp();
                        break;
                    }
                    toLoad.put(p, timestamp);
                }
                if (DownloadOsmChangeTask.this.isCanceled()) {
                    return;
                }
                Main.worker.submit(new HistoryLoaderAndListener(toLoad));
            }
            catch (Exception e) {
                DownloadOsmChangeTask.this.rememberException(e);
                DownloadOsmChangeTask.this.setFailed(true);
            }
        }
    }
}

