/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class DownloadOsmChangeCompressedTask
extends DownloadOsmChangeTask {
    @Override
    public String[] getPatterns() {
        return new String[]{"https?://.*/.*\\.osc.(gz|bz2?)"};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download Compressed OSM Change", new Object[0]);
    }

    @Override
    public Future<?> loadUrl(boolean new_layer, final String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadOsmChangeTask.DownloadTask(new_layer, new OsmServerLocationReader(url), progressMonitor){

            @Override
            protected DataSet parseDataSet() throws OsmTransferException {
                ProgressMonitor subTaskMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                if (url.matches("https?://.*/.*\\.osc.bz2?")) {
                    return this.reader.parseOsmChangeBzip2(subTaskMonitor);
                }
                return this.reader.parseOsmChangeGzip(subTaskMonitor);
            }
        };
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osc.(gz|bz2?))", url);
        return Main.worker.submit(this.downloadTask);
    }
}

